/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.dataset.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import org.apache.commons.collections.CollectionUtils;

public class DmPeriodAndFyUtil {
    public static Boolean validCur(String origin) {
        String curcheck = origin;
        String validcur = "^(\\d[\\+\\-]\\$cur)|(\\$cur[\\+\\-]\\d{1,})|\\$cur$";
        Pattern pattern = Pattern.compile(validcur, 2);
        Matcher m = pattern.matcher(curcheck);
        if (!m.matches()) {
            return false;
        }
        return true;
    }

    public static Object getCurOffset(String origin) {
        String curcheck = origin;
        String validcur = "[\\+|\\-]\\d{1,}";
        Pattern pattern = Pattern.compile(validcur, 2);
        Matcher m = pattern.matcher(curcheck);
        if (m.find()) {
            String offset = m.group();
            return Integer.valueOf(offset);
        }
        return null;
    }

    public static String getPeriodOrFyByOffset(String shownumber, String fyorperiod, String cur, Object offset) {
        String cubeNumber = BCMMemberReader.findModelNumberByShowNum(shownumber);
        Long modelId = BCMMemberReader.findModelIdByNum(cubeNumber);
        QFilter qf1 = new QFilter("isleaf", "=", (Object)"1");
        QFilter qf2 = new QFilter("model.id", "=", (Object)modelId);
        QFilter qf3 = new QFilter("status", "!=", (Object)"A");
        if (Objects.equals(fyorperiod, "FY")) {
            QFilter qf4 = new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"CurrentYear", "LastYear"}));
            DynamicObjectCollection fys = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"number", (QFilter[])new QFilter[]{qf1, qf2, qf3, qf4}, (String)"dseq");
            List fylist = fys.stream().map(s -> s.getString("number")).sorted().collect(Collectors.toList());
            int index = fylist.indexOf(cur);
            int allsize = fylist.size();
            int c = index + (Integer)offset;
            if (c < 0) {
                return (String)fylist.get(0);
            }
            if (c >= allsize) {
                return (String)fylist.get(allsize - 1);
            }
            return (String)fylist.get(c);
        }
        if (Objects.equals(fyorperiod, "P")) {
            QFilter qf = new QFilter("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"CurrentPeriod", "LastPeriod"}));
            DynamicObjectCollection ps = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"number", (QFilter[])new QFilter[]{qf, qf1, qf2, qf3}, (String)"dseq");
            List mlist = ps.stream().map(s -> s.getString("number")).collect(Collectors.toList());
            int i = cur.indexOf("_");
            if (i > 0) {
                String firstStr = cur.substring(0, i + 2);
                mlist = mlist.stream().filter(t -> t.startsWith(firstStr)).sorted().collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(mlist)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u6210\u5458\u4e0d\u652f\u6301\u504f\u79fb\u3002", (String)"DmPeriodAndFyUtil_0", (String)"epm-far-business", (Object[])new Object[0]));
            }
            int index = mlist.indexOf(cur);
            int allsize = mlist.size();
            int c = index + (Integer)offset;
            if (c < 0) {
                return (String)mlist.get(0);
            }
            if (c >= allsize) {
                return (String)mlist.get(allsize - 1);
            }
            return (String)mlist.get(c);
        }
        return cur;
    }
}

