/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.enums;

import kd.epm.far.common.common.enums.MultiLangEnumBridge;

public enum DataPatternEnum {
    YUAN("1", new MultiLangEnumBridge("\u5143", "DataPatternEnum_1", "epm-far-business"), 1),
    THOUSAND_YUAN("2", new MultiLangEnumBridge("\u5343\u5143", "DataPatternEnum_2", "epm-far-business"), 1000),
    TEN_THOUSAND_YUAN("3", new MultiLangEnumBridge("\u4e07\u5143", "DataPatternEnum_3", "epm-far-business"), 10000),
    MILLION_YUAN("4", new MultiLangEnumBridge("\u767e\u4e07\u5143", "DataPatternEnum_4", "epm-far-business"), 1000000),
    BILLION_YUAN("5", new MultiLangEnumBridge("\u4ebf\u5143", "DataPatternEnum_5", "epm-far-business"), 100000000);

    private final String type;
    private final MultiLangEnumBridge name;
    private final int ratio;

    private DataPatternEnum(String type, MultiLangEnumBridge bridge, int ratio) {
        this.type = type;
        this.name = bridge;
        this.ratio = ratio;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name.getDescription();
    }

    public int getRatio() {
        return this.ratio;
    }

    public static DataPatternEnum getDataPatternByType(String type) {
        for (DataPatternEnum value : DataPatternEnum.values()) {
            if (!value.getType().equals(type.trim())) continue;
            return value;
        }
        return YUAN;
    }

    public static DataPatternEnum getDataPatternByRatio(int tRatio) {
        for (DataPatternEnum value : DataPatternEnum.values()) {
            if (value.getRatio() != tRatio) continue;
            return value;
        }
        return YUAN;
    }

    public static boolean containsType(String type) {
        boolean flag = false;
        for (DataPatternEnum value : DataPatternEnum.values()) {
            if (!value.getType().equals(type)) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

