/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.enums;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.common.common.enums.MultiLangEnumBridge;

public enum DataSrcTypeEnum {
    CURRENT_MODEL(new MultiLangEnumBridge("\u5f53\u524d\u4f53\u7cfb", "DataSrcTypeEnum_5", "epm-far-business"), "5", "current"),
    MERGE_MODEL(new MultiLangEnumBridge("\u5408\u5e76\u4f53\u7cfb", "DataSrcTypeEnum_1", "epm-far-business"), "1", "bcm_model"),
    INTEGRATION_SCHEME(new MultiLangEnumBridge("\u96c6\u6210\u65b9\u6848", "DataSrcTypeEnum_2", "epm-far-business"), "2", "integrated_scheme"),
    INTEGRATED_DATA_SOURCE(new MultiLangEnumBridge("\u96c6\u6210\u6570\u636e\u6e90", "DataSrcTypeEnum_3", "epm-far-business"), "3", "integrated_data"),
    COMPONENT(new MultiLangEnumBridge("\u62a5\u8868\u5207\u7247", "DataSrcTypeEnum_4", "epm-far-business"), "4", "bcm_model"),
    RPT_MODEL(new MultiLangEnumBridge("\u8d22\u52a1\u4f53\u7cfb", "DataSrcTypeEnum_6", "epm-far-business"), "6", "bcm_model"),
    EB_MODEL(new MultiLangEnumBridge("\u9884\u7b97\u4f53\u7cfb", "DataSrcTypeEnum_7", "epm-far-business"), "7", "epm_model"),
    ISC_METADATA(new MultiLangEnumBridge("\u96c6\u6210\u5bf9\u8c61", "DataSrcTypeEnum_8", "epm-far-business"), "8", "isc_metadata_schema"),
    CM_TEMPLATE(new MultiLangEnumBridge("\u62a5\u8868-\u5408\u5e76\u62a5\u8868", "DataSrcTypeEnum_9", "epm-far-business"), "9", "bcm_model"),
    EPM_VOUCHER(new MultiLangEnumBridge("EPM\u6570\u636e\u67e5\u8be2", "DataSrcTypeEnum_10", "epm-far-business"), "10", "epdm_dm"),
    BCM_ISC_METADATA(new MultiLangEnumBridge("\u5408\u5e76\u62a5\u8868-\u96c6\u6210\u6e90", "DataSrcTypeEnum_11", "epm-far-business"), "11", "bcm_model");

    private final String type;
    private final MultiLangEnumBridge bridge;
    private final String formId;

    private DataSrcTypeEnum(MultiLangEnumBridge bridge, String type, String formId) {
        this.type = type;
        this.bridge = bridge;
        this.formId = formId;
    }

    public static DataSrcTypeEnum getByType(String type) {
        for (DataSrcTypeEnum value : DataSrcTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public MultiLangEnumBridge getBridge() {
        return this.bridge;
    }

    public String getFormId() {
        return this.formId;
    }

    public String getName() {
        return this.getBridge().loadKDString();
    }

    public static List<String> getBcmModelType() {
        return Lists.newArrayList((Object[])new String[]{MERGE_MODEL.getType(), COMPONENT.getType(), RPT_MODEL.getType()});
    }

    public static DataSrcTypeEnum getEnumByDisType(String type) {
        DisModelTypeEnum enumByType = DisModelTypeEnum.getEnumByType(type);
        switch (enumByType) {
            case CM: {
                return MERGE_MODEL;
            }
            case EB: {
                return EB_MODEL;
            }
            case RPT: {
                return RPT_MODEL;
            }
            case METADATA: {
                return ISC_METADATA;
            }
            case EPM_VOUCHER: {
                return EPM_VOUCHER;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6570\u636e\u6e90\u7c7b\u578b,\u6682\u4e0d\u652f\u6301\u3002", (String)"DisModelTypeEnum_Desc_2", (String)"epm-far-business", (Object[])new Object[0]));
    }
}

