/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.enums;

import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.common.common.enums.MultiLangEnumBridge;

public enum DisModelTypeEnum {
    CM("1", new MultiLangEnumBridge("\u5408\u5e76\u4f53\u7cfb", "DisModelTypeEnum_1", "epm-far-business")),
    EB("2", new MultiLangEnumBridge("\u9884\u7b97\u4f53\u7cfb", "DisModelTypeEnum_2", "epm-far-business")),
    RPT("3", new MultiLangEnumBridge("\u8d22\u52a1\u4f53\u7cfb", "DisModelTypeEnum_3", "epm-far-business")),
    METADATA("4", new MultiLangEnumBridge("\u96c6\u6210\u5bf9\u8c61", "DisModelTypeEnum_4", "epm-far-business")),
    BCM_ISC_METADATA("5", new MultiLangEnumBridge("\u5408\u5e76-\u96c6\u6210\u6e90", "DisModelTypeEnum_6", "epm-far-business")),
    EPM_VOUCHER("6", new MultiLangEnumBridge("\u51ed\u8bc1\u6c60", "DisModelTypeEnum_7", "epm-far-business"));

    private final String type;
    private MultiLangEnumBridge bridge;

    private DisModelTypeEnum(String type, MultiLangEnumBridge bridge) {
        this.type = type;
        this.bridge = bridge;
    }

    public static DisModelTypeEnum getEnumByType(String type) {
        for (DisModelTypeEnum value : DisModelTypeEnum.values()) {
            if (!value.type.equals(type)) continue;
            return value;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4f53\u7cfb\u7c7b\u578b\u3002", (String)"DisModelTypeEnum_Desc_1", (String)"epm-far-business", (Object[])new Object[0]));
    }

    public static DisModelTypeEnum getModelType(String dataSrcType, Long dataSrcId) {
        DataSrcTypeEnum type = DataSrcTypeEnum.getByType(dataSrcType);
        if (Objects.isNull((Object)type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6570\u636e\u6e90\u7c7b\u578b,\u6682\u4e0d\u652f\u6301\u3002", (String)"DisModelTypeEnum_Desc_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        switch (type) {
            case MERGE_MODEL: 
            case COMPONENT: 
            case CM_TEMPLATE: {
                return CM;
            }
            case RPT_MODEL: {
                return RPT;
            }
            case EB_MODEL: {
                return EB;
            }
            case ISC_METADATA: {
                return METADATA;
            }
            case BCM_ISC_METADATA: {
                return BCM_ISC_METADATA;
            }
            case EPM_VOUCHER: {
                return EPM_VOUCHER;
            }
            case CURRENT_MODEL: {
                ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dataSrcId);
                String modeltype = modelStrategyEx.getModel().getModelInfo().getModelType();
                return DisModelTypeEnum.getEnumByType(modeltype);
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6570\u636e\u6e90\u7c7b\u578b,\u6682\u4e0d\u652f\u6301\u3002", (String)"DisModelTypeEnum_Desc_2", (String)"epm-far-business", (Object[])new Object[0]));
    }

    public String getType() {
        return this.type;
    }

    public static boolean isCM(String type) {
        return CM.getType().equalsIgnoreCase(type) || RPT.getType().equalsIgnoreCase(type);
    }
}

