/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.enums;

import com.google.common.collect.Sets;
import java.util.Set;

public enum FidmDataTypeEnum {
    LCD("LCD", "1", "local cm dim"),
    LBD("LBD", "2", "local budget dim"),
    RCD("RCD", "3", "remote cm dim"),
    RBD("RBD", "4", "remote budget dim"),
    DM("DM", "5", "default cm metrix"),
    LEM("LEM", "6", "local ext metrix member"),
    LET("LET", "7", "local ext text member"),
    REM("REM", "8", "remote ext metrix member"),
    RET("RET", "9", "remote ext text member");

    public final String type;
    public final String index;
    public final String description;

    private FidmDataTypeEnum(String type, String index, String description) {
        this.type = type;
        this.index = index;
        this.description = description;
    }

    public String getOIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public static Set<String> getMeasureList() {
        return Sets.newHashSet((Object[])new String[]{FidmDataTypeEnum.DM.type, FidmDataTypeEnum.LEM.type, FidmDataTypeEnum.REM.type});
    }

    public String getType(Boolean islocal, Boolean isbcm, Boolean isext, Boolean ismetric) {
        StringBuilder str = new StringBuilder();
        if (islocal.booleanValue()) {
            str.append("L");
        } else {
            str.append("R");
        }
        if (isext.booleanValue()) {
            str.append("E");
            if (ismetric.booleanValue()) {
                str.append("M");
            } else {
                str.append("T");
            }
        } else if (isbcm.booleanValue()) {
            str.append("CD");
        } else {
            str.append("BD");
        }
        return str.toString();
    }
}

