/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.epm.far.business.common.enums.ChapterComeFromEnum;
import kd.epm.far.common.common.enums.MultiLangEnumBridge;

public enum OpenWordEnum {
    WEBOFFICE(new MultiLangEnumBridge("WEBOFFICE", "OpenWordEnum_0", "epm-far-business"), "0"),
    WPS(new MultiLangEnumBridge("\u91d1\u5c71WPS\u5728\u7ebf\u7248", "OpenWordEnum_1", "epm-far-business"), "1"),
    WPSPLUGIN(new MultiLangEnumBridge("\u91d1\u5c71WPS\u5ba2\u6237\u7aef", "OpenWordEnum_2", "epm-far-business"), "2"),
    WEB(new MultiLangEnumBridge("\u5728\u7ebf\u7248\u672c", "OpenWordEnum_3", "epm-far-business"), "3"),
    EPMCLIENT(new MultiLangEnumBridge("EPM\u5ba2\u6237\u7aef", "OpenWordEnum_4", "epm-far-business"), "4");

    private final String type;
    private final MultiLangEnumBridge nameBridge;

    private OpenWordEnum(MultiLangEnumBridge nameBridge, String type) {
        this.type = type;
        this.nameBridge = nameBridge;
    }

    public static OpenWordEnum getByType(String type) {
        for (OpenWordEnum value : OpenWordEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        return WEB;
    }

    public static ChapterComeFromEnum getComefromByType(String type) {
        OpenWordEnum openWordEnum = OpenWordEnum.getByType(type);
        if (openWordEnum == null) {
            return ChapterComeFromEnum.FIDM;
        }
        if (openWordEnum == EPMCLIENT) {
            return ChapterComeFromEnum.EPMC;
        }
        return ChapterComeFromEnum.FIDM;
    }

    public static List<ComboItem> getItems() {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(2);
        for (OpenWordEnum value : OpenWordEnum.values()) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(value.getName()));
            item.setValue(value.type);
            list.add(item);
        }
        return list;
    }

    public String getType() {
        return this.type;
    }

    public int getTypeToInt() {
        return Integer.parseInt(this.type);
    }

    public String getName() {
        return this.nameBridge.loadKDString();
    }

    public static String getText(Set<String> types) {
        StringBuilder sb = new StringBuilder();
        OpenWordEnum[] datas = OpenWordEnum.values();
        int length = datas.length;
        for (String wordType : types) {
            sb.append(OpenWordEnum.getByType(wordType).getName());
            sb.append(",");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }
}

