/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.base;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.expression.base.AbstractExpressionConditionItem;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionHelper;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionLikeHelper;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionMemberHelper;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionOperHelper;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionVarHelper;
import kd.epm.far.business.common.expression.dto.ExpressionInput;
import kd.epm.far.business.common.expression.dto.calc.DataSetCaclColumn;
import kd.epm.far.business.common.expression.dto.calc.DatasetCalcInfo;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSCondition;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionLike;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionMember;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionOper;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionVar;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.commons.collections4.CollectionUtils;

public class AbstractCalculate {
    private static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(AbstractCalculate.class);
    protected Object sourceData;
    protected Set<String> moneyKeys;
    protected Map<String, String> multiDataNameMap = new HashMap<String, String>(2);
    protected List<Map<String, Object>> multiSourceData = new ArrayList<Map<String, Object>>(2);
    protected String multiColumnPre = "newCol_";
    protected Map<String, String> multiColumnNameMap = new HashMap<String, String>(2);
    protected Set<String> multiMoneyKeys = new HashSet<String>(2);

    public void init() {
        List list = (List)this.sourceData;
        this.multiColumnNameMap = new HashMap<String, String>(2);
        this.multiSourceData = this.convertToNewMutiList(list, this.multiColumnNameMap);
        this.multiMoneyKeys = this.convertToNewMutiMoney(this.moneyKeys, this.multiColumnNameMap);
        this.multiDataNameMap = this.getSourceDataName(this.multiSourceData, this.multiMoneyKeys);
    }

    private List<Map<String, Object>> convertToNewMutiList(List<Map<String, Object>> source, Map<String, String> nameMap) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(2);
        int index = nameMap.size() + 1;
        for (Map<String, Object> item : source) {
            HashMap<String, Object> newItem = new HashMap<String, Object>(2);
            for (Map.Entry<String, Object> entry : item.entrySet()) {
                if (!nameMap.containsKey(entry.getKey())) {
                    nameMap.put(entry.getKey(), this.multiColumnPre + index);
                    ++index;
                }
                newItem.put(nameMap.get(entry.getKey()), entry.getValue());
            }
            result.add(newItem);
        }
        return result;
    }

    private Set<String> convertToNewMutiMoney(Set<String> source, Map<String, String> nameMap) {
        HashSet<String> realMoneyKeys = new HashSet<String>(2);
        if (source != null) {
            int index = nameMap.size() + 1;
            for (String item : source) {
                if (!nameMap.containsKey(item)) {
                    nameMap.put(item, this.multiColumnPre + index);
                    ++index;
                }
                realMoneyKeys.add(nameMap.get(item));
            }
        }
        return realMoneyKeys;
    }

    protected String getDataSetColumnName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        if (this.multiColumnNameMap.containsKey(name)) {
            return this.multiColumnNameMap.get(name);
        }
        return name;
    }

    private Map<String, String> getSourceDataName(List<Map<String, Object>> newSource, Set<String> newMoneyKeys) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        if (CollectionUtils.isEmpty(newSource)) {
            return result;
        }
        for (Map<String, Object> e : newSource) {
            for (Map.Entry<String, Object> entry : e.entrySet()) {
                String key = entry.getKey();
                Object valueObj = entry.getValue();
                if (Objects.isNull(valueObj)) continue;
                String[] value = valueObj instanceof String ? ((String)valueObj).split(";") : valueObj.toString().split(";");
                String number = "";
                String name = "";
                if (value.length > 0) {
                    number = value[0];
                }
                if (value.length == 1) {
                    name = value[0];
                } else if (value.length > 1) {
                    name = value[1];
                }
                e.put(key, number);
                if (newMoneyKeys.contains(key)) continue;
                result.put(key + "_" + number, name);
            }
        }
        return result;
    }

    protected String getMemberName(Row row, String dimensionNumber) {
        return this.getMemberName(row.getString(dimensionNumber), dimensionNumber);
    }

    protected String getMemberName(String memberNumber, String dimensionNumber) {
        return this.multiDataNameMap.get(dimensionNumber + "_" + memberNumber);
    }

    protected DataSet getDataSet() {
        for (Map<String, Object> item : this.multiSourceData) {
            for (String valeCol : this.multiMoneyKeys) {
                BigDecimal val = new BigDecimal(0);
                Object d = item.get(valeCol);
                if (Objects.nonNull(d)) {
                    val = TypeUtils.convertValueToDecimal(d.toString());
                }
                item.put(valeCol, val);
            }
        }
        DataSet dataSet = CalculateHelper.createAlgoDataSet(this.multiSourceData, this.multiMoneyKeys);
        return dataSet;
    }

    protected DataSet filter(ExpressionInput input, ExpressionDSEval dsEval, DatasetCalcInfo dsInfo, DataSet dataSet) {
        if (dsEval.getConditions().size() == 0) {
            return dataSet;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(input.getDmModelId());
        for (ExpressionDSCondition condition : dsEval.getConditions()) {
            DataSetCaclColumn column;
            if (condition.getColumnNumber() == null || StringUtils.isEmpty((String)condition.getColumnNumber().trim()) || (column = ExpressionConditionHelper.getColum(modelStrategyEx, dsInfo, condition)) == null) continue;
            String datasetColumn = this.getDataSetColumnName(column.getNumber());
            StringBuilder orString = new StringBuilder();
            for (AbstractExpressionConditionItem item : condition.getItems()) {
                String fiterStr = "";
                if (item instanceof ExpressionDSConditionVar) {
                    fiterStr = ExpressionConditionVarHelper.getFilter((ExpressionDSConditionVar)item, column, datasetColumn, input.getDimensionInfos());
                } else if (item instanceof ExpressionDSConditionLike) {
                    fiterStr = ExpressionConditionLikeHelper.getFilter((ExpressionDSConditionLike)item, column, datasetColumn);
                } else if (item instanceof ExpressionDSConditionMember) {
                    fiterStr = ExpressionConditionMemberHelper.getFilter(modelStrategyEx, (ExpressionDSConditionMember)item, column, datasetColumn);
                } else if (item instanceof ExpressionDSConditionOper) {
                    fiterStr = ExpressionConditionOperHelper.getFilter((ExpressionDSConditionOper)item, column, datasetColumn);
                }
                if (!StringUtils.isNotEmpty((String)fiterStr)) continue;
                if (orString.length() > 0) {
                    orString.append(" or ");
                }
                orString.append("(");
                orString.append(fiterStr);
                orString.append(")");
            }
            if (orString.length() <= 0) continue;
            dataSet = dataSet.where(orString.toString());
        }
        return dataSet;
    }
}

