/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.base;

import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSSplitTextHelper;

public enum ExpressionDsFlagEnum {
    Normal("0", "#$", "bind"),
    Float("1", "#*$", "float");

    private final String type;
    private final String flag;
    private final String funcName;

    private ExpressionDsFlagEnum(String type, String flag, String funcName) {
        this.type = type;
        this.flag = flag;
        this.funcName = funcName;
    }

    public static ExpressionDsFlagEnum getByFlag(String flagStr) {
        for (ExpressionDsFlagEnum r : ExpressionDsFlagEnum.values()) {
            if (!r.getFlag().equalsIgnoreCase(flagStr)) continue;
            return r;
        }
        return null;
    }

    public static ExpressionDsFlagEnum getByType(String type) {
        for (ExpressionDsFlagEnum r : ExpressionDsFlagEnum.values()) {
            if (!r.getType().equalsIgnoreCase(type)) continue;
            return r;
        }
        return null;
    }

    public static ExpressionDsFlagEnum getByFlagEx(String flagStr) {
        for (ExpressionDsFlagEnum r : ExpressionDsFlagEnum.values()) {
            if (!r.getFlag().equalsIgnoreCase(flagStr)) continue;
            return r;
        }
        return Normal;
    }

    public static ExpressionDsFlagEnum containsDs(String content) {
        for (ExpressionDsFlagEnum r : ExpressionDsFlagEnum.values()) {
            if (!content.contains(r.getFlag()) || !ExpressionDSSplitTextHelper.checkDsParam(new StringBuilder(content))) continue;
            return r;
        }
        if (content.contains("{{") && content.contains("}}")) {
            for (ExpressionDsFlagEnum r : ExpressionDsFlagEnum.values()) {
                if (!content.contains(r.getFuncName() + "(")) continue;
                return r;
            }
        }
        return null;
    }

    public static ExpressionDsFlagEnum getByFuncName(String funcName) {
        for (ExpressionDsFlagEnum r : ExpressionDsFlagEnum.values()) {
            if (!r.getFuncName().equalsIgnoreCase(funcName)) continue;
            return r;
        }
        return null;
    }

    public static ExpressionDsFlagEnum getByFuncNameEx(String funcName) {
        for (ExpressionDsFlagEnum r : ExpressionDsFlagEnum.values()) {
            if (!r.getFuncName().equalsIgnoreCase(funcName)) continue;
            return r;
        }
        return Normal;
    }

    public String getType() {
        return this.type;
    }

    public String getFlag() {
        return this.flag;
    }

    public String getFuncName() {
        return this.funcName;
    }
}

