/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.base;

import java.math.BigDecimal;
import kd.epm.far.business.common.expression.base.AbstractExpressionEval;
import kd.epm.far.business.common.expression.base.ExpressionDsFlagEnum;
import kd.epm.far.business.common.expression.base.ExpressionResultTypeEnum;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;

public class ExpressionUtils {
    public static void setSourceResult(AbstractExpressionEval dsEval, AbstractExpressionEval result) {
        dsEval.setResultType(result.getResultType());
        dsEval.setResult(result.getResult());
        dsEval.setResultStr(result.getResultStr());
    }

    public static void setSuccessResult(AbstractExpressionEval dsEval, BigDecimal result, String resultStr) {
        dsEval.setResultType(ExpressionResultTypeEnum.BigDecimal.getType());
        dsEval.setResult(result);
        dsEval.setResultStr(resultStr);
    }

    public static void setSuccessResult(AbstractExpressionEval dsEval, String result) {
        dsEval.setResultType(ExpressionResultTypeEnum.String.getType());
        dsEval.setResult(result);
        dsEval.setResultStr(result);
    }

    public static void setSourceResult(AbstractExpressionEval dsEval) {
        dsEval.setResultType(ExpressionResultTypeEnum.String.getType());
        dsEval.setResult(dsEval.getSource());
        dsEval.setResultStr(dsEval.getSource());
    }

    public static void setErrorResult(AbstractExpressionEval dsEval, String message) {
        StringBuilder error = new StringBuilder();
        error.append("#");
        error.append(message);
        dsEval.setResultType(ExpressionResultTypeEnum.Error.getType());
        dsEval.setResult(error.toString());
        dsEval.setResultStr(error.toString());
    }

    public static boolean containError(AbstractExpressionEval dsEval) {
        if (ExpressionResultTypeEnum.Error.getType().equalsIgnoreCase(dsEval.getResultType())) {
            return true;
        }
        for (AbstractExpressionEval expressionEval : dsEval.getChilds()) {
            boolean isError = ExpressionUtils.containError(expressionEval);
            if (!isError) continue;
            return true;
        }
        return false;
    }

    public static boolean containDs(AbstractExpressionEval dsEval) {
        if (dsEval instanceof ExpressionDSEval) {
            return true;
        }
        for (AbstractExpressionEval expressionEval : dsEval.getChilds()) {
            boolean isNeedCalc = ExpressionUtils.containDs(expressionEval);
            if (!isNeedCalc) continue;
            return true;
        }
        return false;
    }

    public static ExpressionDSEval getFloatDs(AbstractExpressionEval dsEval) {
        if (dsEval instanceof ExpressionDSEval) {
            ExpressionDSEval floatDs = (ExpressionDSEval)dsEval;
            if (ExpressionDsFlagEnum.Float.getType().equalsIgnoreCase(floatDs.getDsFlagType())) {
                return floatDs;
            }
        }
        for (AbstractExpressionEval expressionEval : dsEval.getChilds()) {
            ExpressionDSEval floatDs = ExpressionUtils.getFloatDs(expressionEval);
            if (floatDs == null) continue;
            return floatDs;
        }
        return null;
    }

    public static boolean containFloatDs(AbstractExpressionEval dsEval) {
        ExpressionDSEval floatDs = ExpressionUtils.getFloatDs(dsEval);
        return floatDs != null;
    }
}

