/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate;

import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.expression.base.AbstractExpressionEval;
import kd.epm.far.business.common.expression.base.ExpressionUtils;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSCalcHelper;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSSplitHelper;
import kd.epm.far.business.common.expression.calculate.func.ExpressionFuncCalcHelper;
import kd.epm.far.business.common.expression.calculate.func.ExpressionFuncSplitHelper;
import kd.epm.far.business.common.expression.dto.ExpressionInput;
import kd.epm.far.business.common.expression.dto.ExpressionResult;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.common.expression.dto.eval.ExpressionFuncEval;
import kd.epm.far.business.common.expression.dto.eval.ExpressionTextEval;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class ExpressionCalculateService {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(ExpressionCalculateService.class);

    public ExpressionResult getResult(ExpressionInput input) {
        try {
            AbstractExpressionEval root = this.splitFirst(input.getSource());
            this.calcSecond(input, root);
            boolean isValiad = ExpressionUtils.containDs(root) && !ExpressionUtils.containError(root);
            return this.createResult(input, root, isValiad);
        }
        catch (Exception ex) {
            logger.error("dm ExpressionCalculateService getResult error", (Throwable)ex);
            ExpressionTextEval root = new ExpressionTextEval(input.getSource());
            return this.createResult(input, root, false);
        }
    }

    private void calcSecond(ExpressionInput input, AbstractExpressionEval eval) {
        for (AbstractExpressionEval child : eval.getChilds()) {
            this.calcSecond(input, child);
        }
        if (eval instanceof ExpressionDSEval) {
            ExpressionDSCalcHelper.calc(input, (ExpressionDSEval)eval);
        }
        if (eval instanceof ExpressionFuncEval || eval instanceof ExpressionTextEval) {
            ExpressionFuncCalcHelper.calc(eval);
        }
    }

    private AbstractExpressionEval splitFirst(String source) {
        if (StringUtils.isEmpty((String)source)) {
            return new ExpressionTextEval(source);
        }
        AbstractExpressionEval root = new ExpressionTextEval(source);
        List<AbstractExpressionEval> expressionEvals = ExpressionFuncSplitHelper.split(source);
        if (expressionEvals.size() == 1) {
            root = expressionEvals.get(0);
        } else {
            root.setChilds(expressionEvals);
        }
        for (AbstractExpressionEval eval : expressionEvals) {
            List<AbstractExpressionEval> childs = ExpressionDSSplitHelper.split(eval.getSource());
            if (childs.size() == 1 && eval.getType().equalsIgnoreCase(childs.get(0).getType())) continue;
            eval.setChilds(childs);
        }
        return root;
    }

    private ExpressionResult createResult(ExpressionInput input, AbstractExpressionEval root, boolean isValiad) {
        ExpressionResult expressionResult = new ExpressionResult();
        expressionResult.setInput(input);
        expressionResult.setRoot(root);
        expressionResult.setResult(root == null ? "" : root.getResultStr());
        expressionResult.setValiad(isValiad);
        return expressionResult;
    }
}

