/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.condition;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.expression.base.AbstractExpressionConditionItem;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSHelper;
import kd.epm.far.business.common.expression.dto.calc.DataSetCaclColumn;
import kd.epm.far.business.common.expression.dto.calc.DatasetCalcInfo;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSCondition;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionLike;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionMember;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionOper;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionVar;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.fidm.util.TypeUtils;

public class ExpressionConditionHelper {
    public static DataSetCaclColumn getColum(ModelStrategyEx modelStrategyEx, DatasetCalcInfo dsInfo, ExpressionDSCondition condition) {
        return ExpressionDSHelper.getColum(modelStrategyEx, dsInfo, condition.getColumnNumber());
    }

    public static List<ExpressionDSCondition> splitDSCondition(String source) {
        ArrayList<ExpressionDSCondition> conditions = new ArrayList<ExpressionDSCondition>(5);
        if (StringUtils.isEmpty((String)source)) {
            return conditions;
        }
        StringBuilder columnNumberStr = new StringBuilder();
        boolean isGetMemberBegin = false;
        StringBuilder memberParamStr = new StringBuilder();
        boolean type = false;
        for (int i = 0; i < source.length(); ++i) {
            ExpressionDSCondition condition;
            List<AbstractExpressionConditionItem> items;
            char c = source.charAt(i);
            if (!isGetMemberBegin) {
                if (c == '.') {
                    isGetMemberBegin = true;
                    memberParamStr = new StringBuilder();
                    continue;
                }
                if (c == ',') {
                    columnNumberStr = new StringBuilder();
                    memberParamStr = new StringBuilder();
                    continue;
                }
                columnNumberStr.append(c);
                continue;
            }
            memberParamStr.append(c);
            if (!type) {
                if (c == '{') {
                    type = true;
                    continue;
                }
                if (c != ',') continue;
                items = ExpressionConditionHelper.splitDSConditionParams(memberParamStr.toString());
                condition = new ExpressionDSCondition();
                condition.setItems(items);
                condition.setSource(columnNumberStr + "." + memberParamStr.substring(0, memberParamStr.length() - 1));
                condition.setColumnNumber(columnNumberStr.toString());
                conditions.add(condition);
                isGetMemberBegin = false;
                columnNumberStr = new StringBuilder();
                memberParamStr = new StringBuilder();
                continue;
            }
            if (!type || c != '}') continue;
            items = ExpressionConditionHelper.splitDSConditionParams(memberParamStr.toString());
            condition = new ExpressionDSCondition();
            condition.setItems(items);
            condition.setSource(columnNumberStr + "." + memberParamStr);
            condition.setColumnNumber(columnNumberStr.toString());
            conditions.add(condition);
            isGetMemberBegin = false;
            columnNumberStr = new StringBuilder();
            memberParamStr = new StringBuilder();
        }
        if (StringUtils.isNotEmpty((String)columnNumberStr.toString())) {
            List<AbstractExpressionConditionItem> items = ExpressionConditionHelper.splitDSConditionParams(memberParamStr.toString());
            ExpressionDSCondition condition = new ExpressionDSCondition();
            condition.setItems(items);
            condition.setSource(columnNumberStr + "." + memberParamStr);
            condition.setColumnNumber(columnNumberStr.toString());
            conditions.add(condition);
        }
        return conditions;
    }

    private static List<AbstractExpressionConditionItem> splitDSConditionParams(String source) {
        ArrayList<AbstractExpressionConditionItem> conditionItems = new ArrayList<AbstractExpressionConditionItem>(5);
        if (StringUtils.isEmpty((String)source)) {
            return conditionItems;
        }
        source = source.replace("{", "").replace("}", "");
        List<String> array = TypeUtils.splitString(source, ",");
        for (String itemStr : array) {
            AbstractExpressionConditionItem var;
            int childBaseIndex = itemStr.indexOf(46);
            if (childBaseIndex >= 0) {
                var = new ExpressionDSConditionMember();
                ((ExpressionDSConditionMember)var).setRangeKey(itemStr.substring(childBaseIndex + 1));
                ((ExpressionDSConditionMember)var).setMemberNumber(itemStr.substring(0, childBaseIndex));
                var.setSource(itemStr);
                conditionItems.add(var);
                continue;
            }
            if (itemStr.startsWith("$")) {
                var = new ExpressionDSConditionVar();
                ((ExpressionDSConditionVar)var).setVarKey(itemStr);
                var.setSource(itemStr);
                conditionItems.add(var);
                continue;
            }
            if (itemStr.startsWith(">") || itemStr.startsWith("<") || itemStr.startsWith("=") || itemStr.startsWith("!")) {
                var = ExpressionConditionHelper.createExpressionDSConditionOper(itemStr);
                conditionItems.add(var);
                continue;
            }
            if (itemStr.contains("%")) {
                var = new ExpressionDSConditionLike();
                ((ExpressionDSConditionLike)var).setKey(itemStr);
                var.setSource(itemStr);
                conditionItems.add(var);
                continue;
            }
            var = new ExpressionDSConditionMember();
            ((ExpressionDSConditionMember)var).setRangeKey("");
            ((ExpressionDSConditionMember)var).setMemberNumber(itemStr);
            var.setSource(itemStr);
            conditionItems.add(var);
        }
        return conditionItems;
    }

    private static ExpressionDSConditionOper createExpressionDSConditionOper(String itemStr) {
        StringBuilder operStr = new StringBuilder();
        StringBuilder textStr = new StringBuilder();
        boolean isText = false;
        for (int i = 0; i < itemStr.length(); ++i) {
            char c = itemStr.charAt(i);
            if (!isText) {
                if (c == '>' || c == '<' || c == '=' || c == '!') {
                    operStr.append(c);
                    continue;
                }
                isText = true;
            }
            textStr.append(c);
        }
        ExpressionDSConditionOper oper = new ExpressionDSConditionOper();
        oper.setOperKey(operStr.toString());
        oper.setValueStr(textStr.toString());
        oper.setSource(itemStr);
        return oper;
    }
}

