/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.condition;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.expression.dto.calc.DataSetCaclColumn;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionMember;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimMemberRange;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.common.common.enums.RangeEnum;

public class ExpressionConditionMemberHelper {
    public static ResultInfo check(ModelStrategyEx modelStrategyEx, DataSetCaclColumn column, ExpressionDSConditionMember conditionItem) {
        RangeEnum find;
        String tips = "";
        if (conditionItem == null) {
            return ResultInfo.success();
        }
        if (StringUtils.isNotEmpty((String)conditionItem.getRangeKey()) && (find = (RangeEnum)Arrays.stream(RangeEnum.values()).filter(m -> conditionItem.getRangeKey().equalsIgnoreCase(m.getNumber())).findFirst().orElse(null)) == null) {
            tips = String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u53c2\u6570\u4e2d\u8303\u56f4\"%1$s\"\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_8", (String)"epm-far-business", (Object[])new Object[0]), conditionItem.getRangeKey());
            return ResultInfo.fail(tips);
        }
        if (StringUtils.isEmpty((String)conditionItem.getMemberNumber())) {
            return ResultInfo.success();
        }
        if (modelStrategyEx != null) {
            DimMemberInfo memberInfo;
            DimensionInfo dimensionInfo = modelStrategyEx.getDim().getDimList(false).stream().filter(m -> column.getNumber().equalsIgnoreCase(m.getNumber())).findFirst().orElse(null);
            if (dimensionInfo == null) {
                return ResultInfo.success();
            }
            if (modelStrategyEx != null && (memberInfo = modelStrategyEx.getDimMember().findMemberByNumber(dimensionInfo.getNumber(), conditionItem.getMemberNumber(), false)) == null) {
                tips = String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u53c2\u6570\u4e2d\u6210\u5458\"%1$s\"\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_7", (String)"epm-far-business", (Object[])new Object[0]), conditionItem.getMemberNumber());
                return ResultInfo.fail(tips);
            }
        }
        return ResultInfo.success();
    }

    public static String getFilter(ModelStrategyEx modelStrategyEx, ExpressionDSConditionMember conditionItem, DataSetCaclColumn column, String datasetColumn) {
        StringBuilder filterStr = new StringBuilder();
        if (column == null) {
            return filterStr.toString();
        }
        if (StringUtils.isEmpty((String)conditionItem.getMemberNumber())) {
            return filterStr.toString();
        }
        RangeEnum find = null;
        if (StringUtils.isNotEmpty((String)conditionItem.getRangeKey())) {
            find = Arrays.stream(RangeEnum.values()).filter(m -> conditionItem.getRangeKey().equalsIgnoreCase(m.getNumber())).findFirst().orElse(null);
        }
        if (find == null || RangeEnum.VALUE_10.getNumber().equalsIgnoreCase(find.getNumber())) {
            filterStr.append(datasetColumn);
            filterStr.append("=");
            filterStr.append("'");
            filterStr.append(conditionItem.getMemberNumber());
            filterStr.append("'");
        } else {
            DimMemberInfo memberInfo;
            DimensionInfo dimensionInfo = DimensionUtils.getDimByNumber(modelStrategyEx.getDim().getDimList(), column.getNumber());
            if (dimensionInfo != null && (memberInfo = modelStrategyEx.getDimMember().findMemberByNumber(column.getNumber(), conditionItem.getMemberNumber(), false)) != null && find != null) {
                memberInfo.setRange(find.getValue());
                DimMemberRange range = modelStrategyEx.getDimMember().getMemberRange(dimensionInfo, memberInfo);
                if (range != null && range.getMemberInfos().size() > 0) {
                    filterStr.append(datasetColumn);
                    filterStr.append(" in ");
                    filterStr.append(" ( ");
                    filterStr.append(ExpressionConditionMemberHelper.getMemberRangeFilterStr(range.getMemberInfos()));
                    filterStr.append(" ) ");
                }
            }
        }
        return filterStr.toString();
    }

    private static String getMemberRangeFilterStr(List<DimMemberInfo> memberInfos) {
        StringBuilder memberStr = new StringBuilder();
        for (DimMemberInfo m : memberInfos) {
            if (memberStr.length() == 0) {
                memberStr.append("'");
                memberStr.append(m.getNumber());
                memberStr.append("'");
                continue;
            }
            memberStr.append(",'");
            memberStr.append(m.getNumber());
            memberStr.append("'");
        }
        return memberStr.toString();
    }
}

