/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.ds;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.dataset.ExpressionDataSet;
import kd.epm.far.business.common.expression.base.ExpressionDsFlagEnum;
import kd.epm.far.business.common.expression.base.ExpressionResultTypeEnum;
import kd.epm.far.business.common.expression.base.ExpressionUtils;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSCheckcHelper;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionMutilLineCalculate;
import kd.epm.far.business.common.expression.dto.ExpressionInput;
import kd.epm.far.business.common.expression.dto.calc.DatasetCalcInfo;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.common.util.ResultInfoEx;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.lock.LockKeyFactory;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class ExpressionDSCalcHelper {
    private static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(ExpressionDSCalcHelper.class);

    public static boolean calc(ExpressionInput input, ExpressionDSEval dsEval) {
        if (dsEval == null) {
            return false;
        }
        String tips = "";
        ResultInfoEx<DatasetCalcInfo> resultInfoEx = ExpressionDSCheckcHelper.check(input, dsEval);
        if (!resultInfoEx.isSuccess().booleanValue()) {
            ExpressionUtils.setErrorResult(dsEval, resultInfoEx.getMessage());
            return true;
        }
        DatasetCalcInfo dsInfo = resultInfoEx.getData();
        ResultInfo dsCalcResult = ExpressionDSCalcHelper.datasetCalcInCache(input, dsInfo);
        if (!dsCalcResult.isSuccess().booleanValue()) {
            ExpressionUtils.setErrorResult(dsEval, resultInfoEx.getMessage());
            return true;
        }
        Object sourceData = dsCalcResult.getData();
        if ("1".equalsIgnoreCase(dsInfo.getDatasetType())) {
            ExpressionDSCalcHelper.singleCalc(dsEval, sourceData);
        } else if ("3".equalsIgnoreCase(dsInfo.getDatasetType())) {
            ExpressionDSCalcHelper.mutilValueCalc(dsEval, sourceData);
        } else if ("2".equalsIgnoreCase(dsInfo.getDatasetType())) {
            ExpressionDSCalcHelper.mutilLineCalc(input, dsInfo, dsEval, sourceData);
        } else {
            tips = ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6570\u636e\u96c6\u7c7b\u578b\u3002", (String)"ExpressionDSHelper_18", (String)"epm-far-business", (Object[])new Object[0]);
            ExpressionUtils.setErrorResult(dsEval, tips);
            return true;
        }
        return true;
    }

    private static void mutilLineCalc(ExpressionInput input, DatasetCalcInfo dsInfo, ExpressionDSEval dsEval, Object sourceData) {
        String tips = "";
        try {
            ExpressionMutilLineCalculate calculate = new ExpressionMutilLineCalculate(input, dsInfo, dsEval, sourceData);
            if (ExpressionDsFlagEnum.Float.getType().equalsIgnoreCase(dsEval.getDsFlagType())) {
                List<Map<String, Object>> list = calculate.getMultiRow();
                dsEval.setResultType(ExpressionResultTypeEnum.List.getType());
                dsEval.setResult(list);
                dsEval.setResultStr("");
            } else {
                Object sum = calculate.getSum();
                ExpressionDSCalcHelper.singleCalc(dsEval, sum);
            }
        }
        catch (KDBizException kdBizException) {
            ExpressionUtils.setErrorResult(dsEval, kdBizException.getMessage());
            return;
        }
        catch (Exception ex) {
            tips = ResManager.loadKDString((String)"\u591a\u884c\u6570\u636e\u96c6\u8ba1\u7b97\u5f02\u5e38\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ExpressionDSHelper_15", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(tips, (Throwable)ex);
            ExpressionUtils.setErrorResult(dsEval, tips);
            return;
        }
    }

    private static void mutilValueCalc(ExpressionDSEval dsEval, Object sourceData) {
        if (sourceData instanceof HashMap && dsEval.getMoneySet().size() > 0) {
            HashMap mapData = (HashMap)sourceData;
            Object obj = mapData.get(dsEval.getMoneySet().get(0));
            ExpressionDSCalcHelper.singleCalc(dsEval, obj);
        } else {
            dsEval.setResultType(ExpressionResultTypeEnum.String.getType());
            dsEval.setResult(sourceData == null ? "" : sourceData.toString());
            dsEval.setResultStr(sourceData == null ? "" : sourceData.toString());
        }
    }

    private static void singleCalc(ExpressionDSEval dsEval, Object sourceData) {
        if (TypeUtils.isNumber(sourceData)) {
            dsEval.setResultType(ExpressionResultTypeEnum.BigDecimal.getType());
            dsEval.setResult(sourceData);
            dsEval.setResultStr(sourceData.toString());
        } else {
            dsEval.setResultType(ExpressionResultTypeEnum.String.getType());
            dsEval.setResult(sourceData);
            dsEval.setResultStr(sourceData == null ? "" : sourceData.toString());
        }
    }

    private static ResultInfo datasetCalcInCache(ExpressionInput input, DatasetCalcInfo dsInfo) {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(input.getCacheStartKey());
        cacheKey.append(CacheKey.AppendString);
        cacheKey.append(input.getDmModelId());
        cacheKey.append("_dscalc_");
        cacheKey.append(dsInfo.getDatasetId());
        ResultInfo resultInfo = (ResultInfo)LockKeyFactory.getLocalLock().getOrLoad(cacheKey.toString(), () -> (ResultInfo)GlobalCacheServiceHelper.getCommonCache().getOrLoad(cacheKey.toString(), () -> {
            ResultInfo result = ExpressionDSCalcHelper.datasetCalc(input, dsInfo);
            return result;
        }));
        return resultInfo;
    }

    private static ResultInfo datasetCalc(ExpressionInput input, DatasetCalcInfo dsInfo) {
        ExpressionDataSet expressionDataSet = null;
        String datasetName = dsInfo.getDatasetName();
        String tips = "";
        try {
            expressionDataSet = new ExpressionDataSet(input.getChapterId(), dsInfo.getDatasetId(), input.getDimensionInfos());
            Object sourceData = expressionDataSet.getResult();
            if (sourceData instanceof RuntimeException) {
                tips = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6[%1$s]\u8ba1\u7b97\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"DataSetService_3", (String)"epm-far-business", (Object[])new Object[0]), datasetName);
                logger.error(tips, (Throwable)((RuntimeException)sourceData));
            }
            return ResultInfo.success(sourceData);
        }
        catch (KDBizException kdBizException) {
            tips = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6[%1$s]\u8ba1\u7b97\u5931\u8d25\uff0c%2$s", (String)"DataSetService_2", (String)"epm-far-business", (Object[])new Object[0]), datasetName, kdBizException.getMessage());
            return ResultInfo.fail(tips);
        }
        catch (Exception ex) {
            tips = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6[%1$s]\u8ba1\u7b97\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"DataSetService_3", (String)"epm-far-business", (Object[])new Object[0]), datasetName);
            logger.error(tips, (Throwable)ex);
            return ResultInfo.fail(tips);
        }
    }
}

