/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.ds;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.expression.base.AbstractExpressionConditionItem;
import kd.epm.far.business.common.expression.base.ExpressionDsFlagEnum;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionHelper;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionLikeHelper;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionMemberHelper;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionOperHelper;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionVarHelper;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSHelper;
import kd.epm.far.business.common.expression.dto.ExpressionInput;
import kd.epm.far.business.common.expression.dto.calc.DataSetCaclColumn;
import kd.epm.far.business.common.expression.dto.calc.DatasetCalcInfo;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSCondition;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionLike;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionMember;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionOper;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSConditionVar;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.common.util.ResultInfoEx;
import kd.epm.far.business.fidm.util.TypeUtils;

public class ExpressionDSCheckcHelper {
    public static ResultInfoEx<DatasetCalcInfo> check(ExpressionInput input, ExpressionDSEval dsEval) {
        ResultInfoEx<DatasetCalcInfo> resultInfoEx = ExpressionDSCheckcHelper.getDataInfo(input, dsEval);
        if (!resultInfoEx.isSuccess().booleanValue()) {
            return resultInfoEx;
        }
        DatasetCalcInfo dsInfo = resultInfoEx.getData();
        ModelStrategyEx modelStrategyEx = ExpressionDSHelper.getModelStrategyEx(dsInfo);
        ResultInfo genealResult = ExpressionDSCheckcHelper.checkGeneal(dsInfo, dsEval);
        if (!genealResult.isSuccess().booleanValue()) {
            return ResultInfoEx.fail(genealResult.getMessage());
        }
        ResultInfo moneyResult = ExpressionDSCheckcHelper.checkMoneySet(modelStrategyEx, dsInfo, dsEval);
        if (!moneyResult.isSuccess().booleanValue()) {
            return ResultInfoEx.fail(moneyResult.getMessage());
        }
        ResultInfo conditionResult = ExpressionDSCheckcHelper.checkCondition(modelStrategyEx, dsInfo, dsEval);
        if (!conditionResult.isSuccess().booleanValue()) {
            return ResultInfoEx.fail(conditionResult.getMessage());
        }
        return resultInfoEx;
    }

    private static ResultInfo checkCondition(ModelStrategyEx modelStrategyEx, DatasetCalcInfo dsInfo, ExpressionDSEval dsEval) {
        String tips = "";
        if ("2".equalsIgnoreCase(dsInfo.getDatasetType())) {
            for (ExpressionDSCondition condition : dsEval.getConditions()) {
                if (condition.getColumnNumber() == null || StringUtils.isEmpty((String)condition.getColumnNumber().trim())) continue;
                DataSetCaclColumn column = ExpressionConditionHelper.getColum(modelStrategyEx, dsInfo, condition);
                if (column == null) {
                    tips = String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u53c2\u6570\u4e2d\u5217\"%1$s\"\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_5", (String)"epm-far-business", (Object[])new Object[0]), condition.getColumnNumber());
                    return ResultInfo.fail(tips);
                }
                for (AbstractExpressionConditionItem item : condition.getItems()) {
                    ResultInfo resultInfo = ResultInfo.success();
                    if (item instanceof ExpressionDSConditionVar) {
                        resultInfo = ExpressionConditionVarHelper.check((ExpressionDSConditionVar)item);
                    } else if (item instanceof ExpressionDSConditionLike) {
                        resultInfo = ExpressionConditionLikeHelper.check((ExpressionDSConditionLike)item);
                    } else if (item instanceof ExpressionDSConditionMember) {
                        resultInfo = ExpressionConditionMemberHelper.check(modelStrategyEx, column, (ExpressionDSConditionMember)item);
                    } else if (item instanceof ExpressionDSConditionOper) {
                        resultInfo = ExpressionConditionOperHelper.check((ExpressionDSConditionOper)item);
                    }
                    if (resultInfo.isSuccess().booleanValue()) continue;
                    return resultInfo;
                }
            }
        } else if ("1".equalsIgnoreCase(dsInfo.getDatasetType())) {
            if (dsEval.getConditions().size() > 0) {
                tips = ResManager.loadKDString((String)"\u5355\u503c\u6570\u636e\u96c6\u4e0d\u652f\u6301\u6761\u4ef6\u53c2\u6570\u3002", (String)"ExpressionDSHelper_11", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(tips);
            }
        } else if ("3".equalsIgnoreCase(dsInfo.getDatasetType()) && dsEval.getConditions().size() > 0) {
            tips = ResManager.loadKDString((String)"\u591a\u503c\u6570\u636e\u96c6\u4e0d\u652f\u6301\u6761\u4ef6\u53c2\u6570\u3002", (String)"ExpressionDSHelper_13", (String)"epm-far-business", (Object[])new Object[0]);
            return ResultInfo.fail(tips);
        }
        return ResultInfo.success();
    }

    private static ResultInfo checkMoneySet(ModelStrategyEx modelStrategyEx, DatasetCalcInfo dsInfo, ExpressionDSEval dsEval) {
        String tips = "";
        if ("3".equalsIgnoreCase(dsInfo.getDatasetType())) {
            if (dsEval.getMoneySet().isEmpty()) {
                tips = ResManager.loadKDString((String)"\u591a\u503c\u6570\u636e\u96c6\u9700\u8981\u6307\u5b9a\u53d6\u6570\u516c\u5f0f\u7f16\u7801\u3002", (String)"ExpressionDSHelper_12", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(tips);
            }
            List<String> lines = dsInfo.getMutilValues().stream().map(m -> m.getNumber()).collect(Collectors.toList());
            for (String money : dsEval.getMoneySet()) {
                boolean isExist = TypeUtils.containsIgnore(lines, money);
                if (isExist) continue;
                tips = String.format(ResManager.loadKDString((String)"\u591a\u503c\u6570\u636e\u96c6\u53d6\u6570\u516c\u5f0f\u7f16\u7801\"%1$s\"\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_4", (String)"epm-far-business", (Object[])new Object[0]), money);
                return ResultInfo.fail(tips);
            }
        } else if ("2".equalsIgnoreCase(dsInfo.getDatasetType())) {
            if (dsEval.getMoneySet().isEmpty()) {
                tips = ResManager.loadKDString((String)"\u591a\u884c\u6570\u636e\u96c6\u9700\u8981\u6307\u5b9a\u5ea6\u91cf\u5217\u3002", (String)"ExpressionDSHelper_19", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(tips);
            }
            boolean isFloat = ExpressionDsFlagEnum.Float.getType().equalsIgnoreCase(dsEval.getDsFlagType());
            for (String money : dsEval.getMoneySet()) {
                DataSetCaclColumn column;
                boolean isExist = TypeUtils.containsIgnore(dsInfo.getMoneySet(), money);
                if (isExist) continue;
                if (isFloat) {
                    if ("*".equalsIgnoreCase(money) || (column = ExpressionDSHelper.getColum(modelStrategyEx, dsInfo, money)) != null) continue;
                    tips = String.format(ResManager.loadKDString((String)"\"%1$s\"\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_23", (String)"epm-far-business", (Object[])new Object[0]), money);
                    return ResultInfo.fail(tips);
                }
                column = ExpressionDSHelper.getColum(modelStrategyEx, dsInfo, money);
                if (column != null) continue;
                tips = String.format(ResManager.loadKDString((String)"\"%1$s\"\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_23", (String)"epm-far-business", (Object[])new Object[0]), money);
                return ResultInfo.fail(tips);
            }
        } else {
            for (String money : dsEval.getMoneySet()) {
                boolean isExist = TypeUtils.containsIgnore(dsInfo.getMoneySet(), money);
                if (isExist) continue;
                tips = String.format(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\"%1$s\"\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_3", (String)"epm-far-business", (Object[])new Object[0]), money);
                return ResultInfo.fail(tips);
            }
        }
        return ResultInfo.success();
    }

    private static ResultInfo checkGeneal(DatasetCalcInfo dsInfo, ExpressionDSEval dsEval) {
        String tips = "";
        boolean isFloat = ExpressionDsFlagEnum.Float.getType().equalsIgnoreCase(dsEval.getDsFlagType());
        if ("3".equalsIgnoreCase(dsInfo.getDatasetType())) {
            if (isFloat) {
                tips = ResManager.loadKDString((String)"\u591a\u503c\u4e0d\u652f\u6301\u6d6e\u52a8\u5c55\u793a\u3002", (String)"ExpressionDSHelper_20", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(tips);
            }
        } else if (!"2".equalsIgnoreCase(dsInfo.getDatasetType()) && isFloat) {
            tips = ResManager.loadKDString((String)"\u5355\u503c\u4e0d\u652f\u6301\u6d6e\u52a8\u5c55\u793a\u3002", (String)"ExpressionDSHelper_21", (String)"epm-far-business", (Object[])new Object[0]);
            return ResultInfo.fail(tips);
        }
        return ResultInfo.success();
    }

    private static ResultInfoEx<DatasetCalcInfo> getDataInfo(ExpressionInput input, ExpressionDSEval dsEval) {
        String tips = "";
        if (StringUtils.isEmpty((String)dsEval.getDsNumber())) {
            tips = ResManager.loadKDString((String)"\u6570\u636e\u96c6\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"ExpressionDSHelper_2", (String)"epm-far-business", (Object[])new Object[0]);
            return ResultInfoEx.fail(tips);
        }
        return ExpressionDSHelper.getDatasetDto(input.getCacheStartKey(), input.getDmModelId(), dsEval.getDsNumber());
    }
}

