/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.ds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.expression.dto.DataSetBaseVo;
import kd.epm.far.business.common.expression.dto.calc.DataSetCaclColumn;
import kd.epm.far.business.common.expression.dto.calc.DataSetCaclMutilValue;
import kd.epm.far.business.common.expression.dto.calc.DatasetCalcInfo;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.util.ResultInfoEx;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.lock.LockKeyFactory;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class ExpressionDSHelper {
    private static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(ExpressionDSHelper.class);

    public static List<DataSetBaseVo> getDatasets(Long dmModelId) {
        QFilter qfilter = new QFilter("discmodel.id", "=", (Object)dmModelId);
        qfilter.and("scope", "=", (Object)"1");
        qfilter.and("status", "=", (Object)"1");
        Map dys = BusinessDataServiceHelper.loadFromCache((String)"fidm_dataset", (String)"id,number,name,type,scope,chapterid", (QFilter[])new QFilter[]{qfilter}, (String)"number");
        ArrayList<DataSetBaseVo> list = new ArrayList<DataSetBaseVo>(dys.size());
        for (DynamicObject dy : dys.values()) {
            DataSetBaseVo dataSetBaseVo = new DataSetBaseVo();
            dataSetBaseVo.setId(dy.getString("id"));
            dataSetBaseVo.setNumber(dy.getString("number"));
            dataSetBaseVo.setName(dy.getString("name"));
            dataSetBaseVo.setType(dy.getString("type"));
            dataSetBaseVo.setScope(dy.getString("scope"));
            dataSetBaseVo.setChapterId(dy.getString("chapterid"));
            list.add(dataSetBaseVo);
        }
        return list;
    }

    private static DynamicObject getDatasetCalcInfo(Long dmModelId, String number) {
        DynamicObject ds = null;
        if (StringUtils.isEmpty((String)number)) {
            return ds;
        }
        QFilter qfilter = new QFilter("discmodel.id", "=", (Object)dmModelId);
        qfilter.and("number", "=", (Object)number);
        qfilter.and("scope", "=", (Object)"1");
        qfilter.and("status", "=", (Object)"1");
        ds = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_dataset", (String)"id,numer,name,type", (QFilter[])new QFilter[]{qfilter});
        if (ds == null) {
            QFilter qfilter2 = new QFilter("discmodel.id", "=", (Object)dmModelId);
            qfilter2.and("number", "=", (Object)number);
            qfilter2.and("scope", "=", (Object)"2");
            qfilter2.and("status", "=", (Object)"1");
            ds = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_dataset", (String)"id,numer,name,type", (QFilter[])new QFilter[]{qfilter2});
        }
        if (ds == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return ds;
    }

    private static DynamicObject getDatasetCalcInfoById(Long id) {
        DynamicObject ds = null;
        if (!LongUtil.isvalidLong((Object)id)) {
            return ds;
        }
        QFilter qfilter = new QFilter("id", "=", (Object)id);
        ds = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_dataset", (String)"id,numer,name,type", (QFilter[])new QFilter[]{qfilter});
        if (ds == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return ds;
    }

    private static DynamicObject getDatasetCalcInfoEx(Long datasetId) {
        QFilter qfilter = new QFilter("dataset", "=", (Object)datasetId);
        DynamicObject ds = BusinessDataServiceHelper.loadSingleFromCache((String)"fidm_dataset_single", (String)"expression,value,defvalue", (QFilter[])new QFilter[]{qfilter});
        if (ds == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return ds;
    }

    private static Collection<DynamicObject> getDatasetMutilValues(Long datasetId) {
        QFilter qfilter = new QFilter("dataset", "=", (Object)datasetId);
        Map ds = BusinessDataServiceHelper.loadFromCache((String)"fidm_dataset_multivalue", (String)"id,number,name,formulatype", (QFilter[])new QFilter[]{qfilter}, (String)"desq");
        return ds.values();
    }

    private static List<Map<String, Object>> getDatasetColums(Long dmModelId, Long datasetId) {
        try {
            List<Map<String, Object>> columnList = DatasetFilterHelper.invokeDatasetFilterColumn(dmModelId, datasetId);
            columnList.forEach(m -> m.put("id", m.get("number").toString()));
            return columnList;
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception dsEx) {
            logger.error((Throwable)dsEx);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5217\u89e3\u6790\u5931\u8d25\u3002", (String)"DisclosureServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static ResultInfoEx<DatasetCalcInfo> getDatasetDto(String cacheStartKey, Long dmModelId, String number) {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(cacheStartKey);
        cacheKey.append(CacheKey.AppendString);
        cacheKey.append(dmModelId);
        cacheKey.append("_dsinfo_");
        cacheKey.append(number.toLowerCase(Locale.ENGLISH));
        String cacheKeyStr = cacheKey.toString();
        ResultInfoEx resultInfoEx = (ResultInfoEx)LockKeyFactory.getLocalLock().getOrLoad(cacheKeyStr, () -> ExpressionDSHelper.getDatasetDtoByNumber(cacheKeyStr, dmModelId, number));
        return resultInfoEx;
    }

    private static ResultInfoEx<DatasetCalcInfo> getDatasetDtoByNumber(String cacheKeyStr, Long dmModelId, String number) {
        ResultInfoEx resultInfoEx = (ResultInfoEx)GlobalCacheServiceHelper.getCommonCache().getOrLoad(cacheKeyStr, () -> {
            try {
                DynamicObject dsDy = ExpressionDSHelper.getDatasetCalcInfo(dmModelId, number);
                DatasetCalcInfo ds = ExpressionDSHelper.getDatasetDto(dmModelId, dsDy);
                return ResultInfoEx.success(ds);
            }
            catch (KDBizException kdBizException) {
                return ResultInfoEx.fail(kdBizException.getMessage());
            }
            catch (Exception ex) {
                logger.error("dm getdatasetinfo error", (Throwable)ex);
                return ResultInfoEx.fail(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u83b7\u53d6\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExpressionDSHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
        });
        return resultInfoEx;
    }

    public static ResultInfoEx<DatasetCalcInfo> getDatasetDtoById(Long dmModelId, Long id) {
        ResultInfoEx resultInfoEx = (ResultInfoEx)ThreadCache.get((Object)(CacheKey.PreviewPrefixString + dmModelId + id), () -> {
            try {
                DynamicObject dsDy = ExpressionDSHelper.getDatasetCalcInfoById(id);
                DatasetCalcInfo ds = ExpressionDSHelper.getDatasetDto(dmModelId, dsDy);
                return ResultInfoEx.success(ds);
            }
            catch (KDBizException kdBizException) {
                return ResultInfoEx.fail(kdBizException.getMessage());
            }
            catch (Exception ex) {
                logger.error("dm getdatasetinfo error", (Throwable)ex);
                return ResultInfoEx.fail(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u83b7\u53d6\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExpressionDSHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
        });
        return resultInfoEx;
    }

    private static DatasetCalcInfo getDatasetDto(Long dmModelId, DynamicObject dsDy) {
        DynamicObject dsExDy;
        String fmoneyStr;
        Long dataSrcId = dmModelId;
        String dataSrcType = DataSrcTypeEnum.CURRENT_MODEL.getType();
        QFilter qFilter = new QFilter("dataset", "=", (Object)dsDy.getLong("id"));
        DynamicObject dataSetSingleEntity = QueryServiceHelper.queryOne((String)"fidm_dataset_single", (String)"datasrctype,datasrcid", (QFilter[])qFilter.toArray());
        if (dataSetSingleEntity != null) {
            dataSrcId = dataSetSingleEntity.getLong("datasrcid");
            dataSrcType = dataSetSingleEntity.getString("datasrctype");
        }
        DatasetCalcInfo ds = new DatasetCalcInfo();
        ds.setDatasetId(dsDy.getLong("id"));
        ds.setDatasetName(dsDy.getString("name"));
        ds.setDatasetNumber(dsDy.getString("number"));
        ds.setDatasetType(dsDy.getString("type"));
        ds.setDataSrcId(dataSrcId);
        ds.setDataSrcType(dataSrcType);
        String datasetType = dsDy.getString("type");
        Long datasetId = dsDy.getLong("id");
        if (("1".equalsIgnoreCase(datasetType) || "2".equalsIgnoreCase(datasetType)) && StringUtils.isNotEmpty((String)(fmoneyStr = (dsExDy = ExpressionDSHelper.getDatasetCalcInfoEx(datasetId)).getString("value")))) {
            ArrayList<String> fmoneySet = new ArrayList<String>(5);
            for (String item : fmoneyStr.split(",")) {
                if (item == null || !StringUtils.isNotEmpty((String)item.trim())) continue;
                fmoneySet.add(item.trim());
            }
            ds.setMoneySet(fmoneySet);
        }
        if ("2".equalsIgnoreCase(datasetType)) {
            List<Map<String, Object>> colunmMapList = ExpressionDSHelper.getDatasetColums(dmModelId, datasetId);
            ArrayList<DataSetCaclColumn> columnList = new ArrayList<DataSetCaclColumn>(colunmMapList.size());
            for (Map<String, Object> columnMap : colunmMapList) {
                DataSetCaclColumn column = new DataSetCaclColumn();
                column.setId(columnMap.get("number").toString());
                column.setNumber(columnMap.get("number").toString());
                column.setName(columnMap.get("name").toString());
                column.setType(columnMap.get("type").toString());
                column.setCol_type(columnMap.get("col_type").toString());
                columnList.add(column);
            }
            ds.setColumns(columnList);
        } else if ("3".equalsIgnoreCase(datasetType)) {
            Collection<DynamicObject> mutilValues = ExpressionDSHelper.getDatasetMutilValues(datasetId);
            ArrayList<DataSetCaclMutilValue> mutilValueList = new ArrayList<DataSetCaclMutilValue>(mutilValues.size());
            for (DynamicObject mutilValueDy : mutilValues) {
                DataSetCaclMutilValue mutilValue = new DataSetCaclMutilValue();
                mutilValue.setId(mutilValueDy.get("number").toString());
                mutilValue.setNumber(mutilValueDy.get("number").toString());
                mutilValue.setName(mutilValueDy.get("name").toString());
                mutilValue.setType(mutilValueDy.get("formulatype").toString());
                mutilValueList.add(mutilValue);
            }
            ds.setMutilValues(mutilValueList);
        }
        return ds;
    }

    public static DataSetCaclColumn getColum(ModelStrategyEx modelStrategyEx, DatasetCalcInfo dsInfo, String columnName) {
        DimensionInfo dimensionInfo;
        if (columnName == null || StringUtils.isEmpty((String)columnName.trim())) {
            return null;
        }
        String columnsNumber = columnName.trim();
        DataSetCaclColumn column = dsInfo.getColumns().stream().filter(m -> columnsNumber.equalsIgnoreCase(m.getNumber())).findFirst().orElse(null);
        if (column == null && modelStrategyEx != null && (dimensionInfo = (DimensionInfo)modelStrategyEx.getDim().getDimList().stream().filter(m -> columnsNumber.equalsIgnoreCase(m.getShortNumber())).findFirst().orElse(null)) != null) {
            column = dsInfo.getColumns().stream().filter(m -> dimensionInfo.getNumber().equalsIgnoreCase(m.getNumber())).findFirst().orElse(null);
        }
        return column;
    }

    public static ModelStrategyEx getModelStrategyEx(DatasetCalcInfo dsInfo) {
        ModelStrategyEx modelStrategyEx = null;
        DataSrcTypeEnum datasetType = DataSrcTypeEnum.getByType(dsInfo.getDataSrcType());
        switch (datasetType) {
            case MERGE_MODEL: 
            case COMPONENT: 
            case CM_TEMPLATE: 
            case RPT_MODEL: {
                modelStrategyEx = new ModelStrategyEx(dsInfo.getDataSrcId(), DisModelTypeEnum.CM.getType());
                break;
            }
            case EB_MODEL: {
                modelStrategyEx = new ModelStrategyEx(dsInfo.getDataSrcId(), DisModelTypeEnum.EB.getType());
                break;
            }
            case ISC_METADATA: {
                modelStrategyEx = null;
                break;
            }
            case BCM_ISC_METADATA: {
                modelStrategyEx = null;
                break;
            }
            case CURRENT_MODEL: {
                modelStrategyEx = new ModelStrategyEx(dsInfo.getDataSrcId());
                break;
            }
            default: {
                modelStrategyEx = null;
            }
        }
        return modelStrategyEx;
    }
}

