/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.ds;

import java.util.ArrayList;
import java.util.List;
import kd.epm.far.business.common.expression.base.AbstractExpressionEval;
import kd.epm.far.business.common.expression.base.ExpressionDsFlagEnum;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionHelper;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.common.expression.dto.eval.ExpressionTextEval;
import kd.epm.far.business.fidm.util.TypeUtils;

public class ExpressionDSSplitBindHelper {
    public static List<AbstractExpressionEval> split(String source) {
        ArrayList<AbstractExpressionEval> list = new ArrayList<AbstractExpressionEval>(10);
        if (source == null || source.length() == 0) {
            return list;
        }
        boolean isGetFuncBegin = false;
        StringBuilder funNameStr = new StringBuilder();
        StringBuilder dsParamStr = new StringBuilder();
        StringBuilder textStr = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (!isGetFuncBegin) {
                if (Character.isDigit(c) || Character.isLetter(c)) {
                    funNameStr.append(c);
                    continue;
                }
                if (c == '(' && ExpressionDSSplitBindHelper.isDsFuncName(funNameStr.toString())) {
                    isGetFuncBegin = true;
                    if (textStr != null && textStr.length() > 0) {
                        list.add(new ExpressionTextEval(textStr.toString()));
                    }
                    dsParamStr = new StringBuilder("(");
                    textStr = new StringBuilder();
                    continue;
                }
                textStr.append((CharSequence)funNameStr);
                textStr.append(c);
                funNameStr = new StringBuilder();
                continue;
            }
            dsParamStr.append(c);
            if (c != ')') continue;
            list.add(ExpressionDSSplitBindHelper.createDSEntity(source, funNameStr.toString(), dsParamStr.toString()));
            isGetFuncBegin = false;
            funNameStr = new StringBuilder();
            dsParamStr = new StringBuilder();
            textStr = new StringBuilder();
        }
        if (textStr.length() > 0 || funNameStr.length() > 0 || dsParamStr.length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append((CharSequence)textStr);
            sb.append((CharSequence)funNameStr);
            sb.append((CharSequence)dsParamStr);
            list.add(new ExpressionTextEval(sb.toString()));
        }
        return list;
    }

    private static boolean isDsFuncName(String funNameStr) {
        ExpressionDsFlagEnum expressionDsFlagEnum = ExpressionDsFlagEnum.getByFuncName(funNameStr);
        return expressionDsFlagEnum != null;
    }

    private static ExpressionDSEval createDSEntity(String source, String funName, String paramsStr) {
        ExpressionDSEval funcEval = new ExpressionDSEval();
        funcEval.setDsFlagType(ExpressionDsFlagEnum.getByFuncNameEx(funName).getType());
        funcEval.setSource(source);
        if (paramsStr != null) {
            String[] arary = (paramsStr = paramsStr.trim()).split("\"");
            if (arary.length > 1) {
                funcEval.setDsNumber(arary[1].trim());
            }
            if (arary.length > 3) {
                List<String> columns = TypeUtils.splitString(arary[3].trim(), ",");
                funcEval.setMoneySet(columns);
            }
            if (arary.length > 5) {
                funcEval.setConditions(ExpressionConditionHelper.splitDSCondition(arary[5]));
            }
        }
        return funcEval;
    }
}

