/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.ds;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.expression.base.AbstractExpressionEval;
import kd.epm.far.business.common.expression.base.ExpressionDsFlagEnum;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionHelper;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.common.expression.dto.eval.ExpressionTextEval;
import kd.epm.far.business.fidm.util.TypeUtils;

public class ExpressionDSSplitDefaultTextHelper {
    public static List<AbstractExpressionEval> split(String source) {
        ArrayList<AbstractExpressionEval> list = new ArrayList<AbstractExpressionEval>(10);
        if (source == null || source.length() == 0) {
            return list;
        }
        StringBuilder dsFlagStr = new StringBuilder();
        boolean isDSFlagBegin = false;
        StringBuilder dsNameStr = new StringBuilder();
        boolean isGetDSParamsBegin = false;
        StringBuilder dsParamStr = new StringBuilder();
        StringBuilder textStr = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (!isDSFlagBegin) {
                if (c == '#' || c == '$' || c == '*' || c == '[') {
                    dsFlagStr.append(c);
                    ExpressionDsFlagEnum flagEnum = null;
                    boolean isContain = false;
                    if (c == '$' && i > 0 && source.charAt(i - 1) == '#') {
                        flagEnum = ExpressionDsFlagEnum.Normal;
                    } else if (c == '$' && i > 0 && source.charAt(i - 1) == '*' && i > 1 && source.charAt(i - 2) == '#') {
                        flagEnum = ExpressionDsFlagEnum.Float;
                    } else if (c == '[' && i > 0 && source.charAt(i - 1) == '#') {
                        flagEnum = ExpressionDsFlagEnum.Normal;
                        isContain = true;
                    } else if (c == '[' && i > 0 && source.charAt(i - 1) == '*' && i > 1 && source.charAt(i - 2) == '#') {
                        flagEnum = ExpressionDsFlagEnum.Float;
                        isContain = true;
                    }
                    if (flagEnum != null) {
                        isDSFlagBegin = true;
                        isGetDSParamsBegin = false;
                        if (isContain) {
                            --i;
                            dsFlagStr.deleteCharAt(dsFlagStr.length() - 1);
                        }
                        if (textStr != null && textStr.length() > 0) {
                            list.add(new ExpressionTextEval(textStr.toString()));
                        }
                        dsNameStr = new StringBuilder();
                        dsParamStr = new StringBuilder();
                        textStr = new StringBuilder();
                        continue;
                    }
                    if (dsFlagStr.length() <= 2) continue;
                    textStr.append((CharSequence)dsFlagStr);
                    dsFlagStr = new StringBuilder();
                    continue;
                }
                textStr.append((CharSequence)dsFlagStr);
                textStr.append(c);
                dsFlagStr = new StringBuilder();
                continue;
            }
            if (!isGetDSParamsBegin) {
                if (Character.isDigit(c) || Character.isLetter(c) || c == '.' || c == '_' || c == '-') {
                    dsNameStr.append(c);
                    continue;
                }
                if (c == '[') {
                    isGetDSParamsBegin = true;
                    dsParamStr = new StringBuilder("[");
                    continue;
                }
                if (dsNameStr.length() > 0) {
                    list.add(ExpressionDSSplitDefaultTextHelper.createDSEntity(source, dsFlagStr.toString(), dsNameStr.toString()));
                }
                dsNameStr = new StringBuilder();
                dsFlagStr = new StringBuilder();
                isDSFlagBegin = false;
                continue;
            }
            dsParamStr.append(c);
            if (c != ']') continue;
            if (ExpressionDSSplitDefaultTextHelper.checkDsParam(dsParamStr)) {
                list.add(ExpressionDSSplitDefaultTextHelper.createDSEntity(source, dsFlagStr.toString(), dsNameStr.toString(), dsParamStr.toString()));
            } else {
                StringBuilder text = new StringBuilder();
                text.append((CharSequence)dsFlagStr);
                text.append((CharSequence)dsNameStr);
                text.append((CharSequence)dsParamStr);
                list.add(new ExpressionTextEval(text.toString()));
            }
            dsFlagStr = new StringBuilder();
            dsNameStr = new StringBuilder();
            isDSFlagBegin = false;
            isGetDSParamsBegin = false;
            dsParamStr = new StringBuilder();
            textStr = new StringBuilder();
        }
        if (textStr != null && textStr.length() > 0) {
            list.add(new ExpressionTextEval(textStr.toString()));
        }
        if (dsNameStr != null && dsNameStr.length() > 0) {
            if (dsParamStr != null && dsParamStr.length() > 0) {
                if (ExpressionDSSplitDefaultTextHelper.checkDsParam(dsParamStr)) {
                    list.add(ExpressionDSSplitDefaultTextHelper.createDSEntity(source, dsFlagStr.toString(), dsNameStr.toString(), dsParamStr.toString()));
                } else {
                    StringBuilder text = new StringBuilder();
                    text.append((CharSequence)dsFlagStr);
                    text.append((CharSequence)dsNameStr);
                    text.append((CharSequence)dsParamStr);
                    list.add(new ExpressionTextEval(text.toString()));
                }
            } else {
                list.add(ExpressionDSSplitDefaultTextHelper.createDSEntity(source, dsFlagStr.toString(), dsNameStr.toString()));
            }
        }
        return list;
    }

    public static boolean checkDsParam(StringBuilder dsParamStr) {
        if (dsParamStr == null || dsParamStr.length() == 0) {
            return true;
        }
        int startIndex = dsParamStr.indexOf("[");
        int endIndex = dsParamStr.lastIndexOf("]");
        if (startIndex >= 0 && endIndex < 0) {
            return false;
        }
        if (startIndex < 0 && endIndex >= 0) {
            return false;
        }
        if (startIndex != dsParamStr.lastIndexOf("[")) {
            return false;
        }
        return endIndex == dsParamStr.indexOf("]");
    }

    private static ExpressionDSEval createDSEntity(String source, String flag, String dsNumber) {
        ExpressionDsFlagEnum flagEnum = ExpressionDsFlagEnum.Normal;
        if (flag.contains("*")) {
            flagEnum = ExpressionDsFlagEnum.Float;
        }
        ExpressionDSEval funcEval = new ExpressionDSEval();
        funcEval.setDsFlagType(flagEnum.getType());
        funcEval.setDsNumber(dsNumber);
        funcEval.setSource(source);
        if (StringUtils.isEmpty((String)dsNumber)) {
            funcEval.setDefault(true);
        } else {
            funcEval.setDefault(false);
        }
        return funcEval;
    }

    private static ExpressionDSEval createDSEntity(String source, String flag, String dsNumber, String paramsStr) {
        ExpressionDsFlagEnum flagEnum = ExpressionDsFlagEnum.Normal;
        if (flag.contains("*")) {
            flagEnum = ExpressionDsFlagEnum.Float;
        }
        ExpressionDSEval funcEval = new ExpressionDSEval();
        funcEval.setDsFlagType(flagEnum.getType());
        funcEval.setDsNumber(dsNumber);
        funcEval.setSource(source);
        if (StringUtils.isEmpty((String)dsNumber)) {
            funcEval.setDefault(true);
        } else {
            funcEval.setDefault(false);
        }
        if (paramsStr != null) {
            String[] arary = (paramsStr = paramsStr.trim().replace("[", "").replace("]", "")).split("\"");
            if (arary.length >= 2 && arary.length < 4) {
                String firsStr = arary[1].trim();
                if (firsStr.contains(".")) {
                    funcEval.setConditions(ExpressionConditionHelper.splitDSCondition(firsStr));
                } else {
                    List<String> columns = TypeUtils.splitString(firsStr, ",");
                    funcEval.setMoneySet(columns);
                }
            } else if (arary.length >= 4) {
                String firsStr = arary[1].trim();
                String secStr = arary[3].trim();
                List<String> columns = TypeUtils.splitString(firsStr, ",");
                funcEval.setMoneySet(columns);
                funcEval.setConditions(ExpressionConditionHelper.splitDSCondition(secStr));
            }
        }
        return funcEval;
    }
}

