/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.ds;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.epm.far.business.common.expression.base.AbstractExpressionEval;
import kd.epm.far.business.common.expression.base.ExpressionTypeEnum;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSSplitBindHelper;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSSplitDefaultTextHelper;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSSplitTextHelper;
import kd.epm.far.business.common.expression.calculate.func.ExpressionFuncSplitFlagHelper;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;

public class ExpressionDSSplitHelper {
    public static List<AbstractExpressionEval> split(String source) {
        ArrayList<AbstractExpressionEval> list = new ArrayList<AbstractExpressionEval>(10);
        if (source == null || source.length() == 0) {
            return list;
        }
        if (ExpressionFuncSplitFlagHelper.containExpressionFlag(source)) {
            List<AbstractExpressionEval> evalList = ExpressionDSSplitBindHelper.split(source);
            if (evalList.size() > 0) {
                list.addAll(evalList);
            }
        } else {
            List<AbstractExpressionEval> evalList = ExpressionDSSplitTextHelper.split(source);
            if (evalList.size() > 0) {
                list.addAll(evalList);
            }
        }
        return list;
    }

    public static List<AbstractExpressionEval> splitDefault(String source) {
        ArrayList<AbstractExpressionEval> list = new ArrayList<AbstractExpressionEval>(10);
        if (source == null || source.length() == 0) {
            return list;
        }
        List<AbstractExpressionEval> evalList = ExpressionDSSplitDefaultTextHelper.split(source);
        if (evalList.size() > 0) {
            list.addAll(evalList);
        }
        return list;
    }

    public static List<AbstractExpressionEval> splitALL(String source) {
        List<AbstractExpressionEval> dsList = ExpressionDSSplitHelper.split(source);
        boolean isContainDs = ExpressionDSSplitHelper.isContainDs(dsList);
        if (!isContainDs) {
            dsList = ExpressionDSSplitHelper.splitDefault(source);
        }
        return dsList;
    }

    public static boolean isContainDs(List<AbstractExpressionEval> list) {
        AbstractExpressionEval find = list.stream().filter(m -> ExpressionTypeEnum.Ds.getType().equalsIgnoreCase(m.getType())).findFirst().orElse(null);
        return find != null;
    }

    public static int getDsSize(List<AbstractExpressionEval> list) {
        List finds = list.stream().filter(m -> ExpressionTypeEnum.Ds.getType().equalsIgnoreCase(m.getType())).collect(Collectors.toList());
        return finds.size();
    }

    public static ExpressionDSEval getDsFirst(List<AbstractExpressionEval> list) {
        List dsList = list.stream().filter(m -> ExpressionTypeEnum.Ds.getType().equalsIgnoreCase(m.getType())).collect(Collectors.toList());
        for (AbstractExpressionEval eval : dsList) {
            if (!(eval instanceof ExpressionDSEval)) continue;
            ExpressionDSEval dsEval = (ExpressionDSEval)eval;
            return dsEval;
        }
        return null;
    }
}

