/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.ds;

import java.util.ArrayList;
import java.util.List;
import kd.epm.far.business.common.expression.base.AbstractExpressionEval;
import kd.epm.far.business.common.expression.base.ExpressionDsFlagEnum;
import kd.epm.far.business.common.expression.calculate.condition.ExpressionConditionHelper;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.common.expression.dto.eval.ExpressionTextEval;
import kd.epm.far.business.fidm.util.TypeUtils;

public class ExpressionDSSplitTextHelper {
    public static List<AbstractExpressionEval> split(String source) {
        ArrayList<AbstractExpressionEval> list = new ArrayList<AbstractExpressionEval>(10);
        if (source == null || source.length() == 0) {
            return list;
        }
        StringBuilder dsFlagStr = new StringBuilder();
        boolean isDSFlagBegin = false;
        StringBuilder dsNameStr = new StringBuilder();
        boolean isGetDSParamsBegin = false;
        StringBuilder dsParamStr = new StringBuilder();
        StringBuilder textStr = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (!isDSFlagBegin) {
                if (c == '#' || c == '$' || c == '*') {
                    ExpressionDsFlagEnum flagEnum;
                    dsFlagStr.append(c);
                    if (c != '$' || (flagEnum = ExpressionDsFlagEnum.getByFlag(dsFlagStr.toString())) == null) continue;
                    isDSFlagBegin = true;
                    isGetDSParamsBegin = false;
                    if (textStr != null && textStr.length() > 0) {
                        list.add(new ExpressionTextEval(textStr.toString()));
                    }
                    dsNameStr = new StringBuilder();
                    dsParamStr = new StringBuilder();
                    textStr = new StringBuilder();
                    continue;
                }
                textStr.append((CharSequence)dsFlagStr);
                textStr.append(c);
                dsFlagStr = new StringBuilder();
                continue;
            }
            if (!isGetDSParamsBegin) {
                if (Character.isDigit(c) || Character.isLetter(c) || c == '.' || c == '_' || c == '-') {
                    dsNameStr.append(c);
                    continue;
                }
                if (c == '[') {
                    isGetDSParamsBegin = true;
                    dsParamStr = new StringBuilder("[");
                    continue;
                }
                if (dsNameStr.length() > 0) {
                    list.add(ExpressionDSSplitTextHelper.createDSEntity(source, dsFlagStr.toString(), dsNameStr.toString()));
                }
                dsNameStr = new StringBuilder();
                dsFlagStr = new StringBuilder();
                isDSFlagBegin = false;
                continue;
            }
            dsParamStr.append(c);
            if (c != ']') continue;
            if (ExpressionDSSplitTextHelper.checkDsParam(dsParamStr)) {
                list.add(ExpressionDSSplitTextHelper.createDSEntity(source, dsFlagStr.toString(), dsNameStr.toString(), dsParamStr.toString()));
            } else {
                StringBuilder text = new StringBuilder();
                text.append((CharSequence)dsFlagStr);
                text.append((CharSequence)dsNameStr);
                text.append((CharSequence)dsParamStr);
                list.add(new ExpressionTextEval(text.toString()));
            }
            dsFlagStr = new StringBuilder();
            dsNameStr = new StringBuilder();
            isDSFlagBegin = false;
            isGetDSParamsBegin = false;
            dsParamStr = new StringBuilder();
            textStr = new StringBuilder();
        }
        if (textStr != null && textStr.length() > 0) {
            list.add(new ExpressionTextEval(textStr.toString()));
        }
        if (dsNameStr != null && dsNameStr.length() > 0) {
            if (dsParamStr != null && dsParamStr.length() > 0) {
                if (ExpressionDSSplitTextHelper.checkDsParam(dsParamStr)) {
                    list.add(ExpressionDSSplitTextHelper.createDSEntity(source, dsFlagStr.toString(), dsNameStr.toString(), dsParamStr.toString()));
                } else {
                    StringBuilder text = new StringBuilder();
                    text.append((CharSequence)dsFlagStr);
                    text.append((CharSequence)dsNameStr);
                    text.append((CharSequence)dsParamStr);
                    list.add(new ExpressionTextEval(text.toString()));
                }
            } else {
                list.add(ExpressionDSSplitTextHelper.createDSEntity(source, dsFlagStr.toString(), dsNameStr.toString()));
            }
        }
        return list;
    }

    public static boolean checkDsParam(StringBuilder dsParamStr) {
        if (dsParamStr == null || dsParamStr.length() == 0) {
            return true;
        }
        int startIndex = dsParamStr.indexOf("[");
        int endIndex = dsParamStr.lastIndexOf("]");
        if (startIndex >= 0 && endIndex < 0) {
            return false;
        }
        if (startIndex < 0 && endIndex >= 0) {
            return false;
        }
        if (startIndex != dsParamStr.lastIndexOf("[")) {
            return false;
        }
        return endIndex == dsParamStr.indexOf("]");
    }

    private static ExpressionDSEval createDSEntity(String source, String flag, String dsNumber) {
        ExpressionDSEval funcEval = new ExpressionDSEval();
        funcEval.setDsFlagType(ExpressionDsFlagEnum.getByFlagEx(flag).getType());
        funcEval.setDsNumber(dsNumber);
        funcEval.setSource(source);
        return funcEval;
    }

    private static ExpressionDSEval createDSEntity(String source, String flag, String dsNumber, String paramsStr) {
        ExpressionDSEval funcEval = new ExpressionDSEval();
        funcEval.setDsFlagType(ExpressionDsFlagEnum.getByFlagEx(flag).getType());
        funcEval.setDsNumber(dsNumber);
        funcEval.setSource(source);
        if (paramsStr != null) {
            String[] arary = (paramsStr = paramsStr.trim()).split("\"");
            if (arary.length >= 2) {
                List<String> columns = TypeUtils.splitString(arary[1].trim(), ",");
                funcEval.setMoneySet(columns);
            }
            if (arary.length >= 4) {
                funcEval.setConditions(ExpressionConditionHelper.splitDSCondition(arary[3]));
            }
        }
        return funcEval;
    }
}

