/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.ds;

import kd.epm.far.business.common.expression.base.ExpressionDsFlagEnum;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSCondition;

public class ExpressionDSTextHelper {
    public static String getText(ExpressionDSEval source) {
        if (source == null) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        text.append(ExpressionDSTextHelper.getDsFlag(source.getDsFlagType()));
        text.append(source.getDsNumber());
        text.append("[");
        text.append("\"");
        text.append(ExpressionDSTextHelper.getMoneySet(source));
        text.append("\"");
        text.append(",");
        text.append("\"");
        text.append(ExpressionDSTextHelper.getCondition(source));
        text.append("\"");
        text.append("]");
        return text.toString();
    }

    private static String getDsFlag(String dsFlagType) {
        ExpressionDsFlagEnum dsFlagEnum = ExpressionDsFlagEnum.getByType(dsFlagType);
        if (dsFlagEnum == null) {
            dsFlagEnum = ExpressionDsFlagEnum.Normal;
        }
        return dsFlagEnum.getFlag();
    }

    private static String getMoneySet(ExpressionDSEval source) {
        if (source.getMoneySet() == null || source.getMoneySet().size() == 0) {
            return "";
        }
        return source.getMoneySet().get(0);
    }

    private static String getCondition(ExpressionDSEval source) {
        if (source.getConditions() == null || source.getConditions().size() == 0) {
            return "";
        }
        StringBuilder conditionText = new StringBuilder();
        for (int i = 0; i < source.getConditions().size(); ++i) {
            ExpressionDSCondition condition = source.getConditions().get(i);
            if (i != 0 && !conditionText.substring(conditionText.length() - 1, conditionText.length()).equalsIgnoreCase(",")) {
                conditionText.append(",");
            }
            conditionText.append(condition.getSource());
        }
        return conditionText.toString();
    }
}

