/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.ds;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.expression.base.AbstractCalculate;
import kd.epm.far.business.common.expression.base.ExpressionUtils;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSHelper;
import kd.epm.far.business.common.expression.dto.ExpressionInput;
import kd.epm.far.business.common.expression.dto.calc.DataSetCaclColumn;
import kd.epm.far.business.common.expression.dto.calc.DatasetCalcInfo;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.fidm.util.TypeUtils;

public class ExpressionMutilLineCalculate
extends AbstractCalculate {
    protected ExpressionInput input;
    protected DatasetCalcInfo dsInfo;
    protected ExpressionDSEval dsEval;

    public ExpressionMutilLineCalculate(ExpressionInput input, DatasetCalcInfo dsInfo, ExpressionDSEval dsEval, Object sourceData) {
        this.input = input;
        this.dsEval = dsEval;
        this.dsInfo = dsInfo;
        this.sourceData = sourceData;
        this.moneyKeys = this.dsInfo.getColumns().stream().filter(m -> "2".equalsIgnoreCase(m.getCol_type())).map(m -> m.getNumber()).collect(Collectors.toSet());
        this.init();
        this.check();
    }

    private void check() {
        String tips = "";
        if (!(this.multiSourceData instanceof List)) {
            tips = ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6570\u636e\u96c6\u8ba1\u7b97\u7ed3\u679c\u3002", (String)"ExpressionDSHelper_14", (String)"epm-far-business", (Object[])new Object[0]);
            ExpressionUtils.setErrorResult(this.dsEval, tips);
            return;
        }
    }

    public Object getSum() {
        BigDecimal result = new BigDecimal(0);
        if (this.sourceData == null) {
            return result;
        }
        List list = (List)this.sourceData;
        if (list.size() == 0) {
            return result;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.input.getDmModelId());
        DataSetCaclColumn column = ExpressionDSHelper.getColum(modelStrategyEx, this.dsInfo, this.dsEval.getMoneySet().get(0));
        if (column == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\"%1$s\"\u4e0d\u5b58\u5728\u3002", (String)"ExpressionDSHelper_3", (String)"epm-far-business", (Object[])new Object[0]), this.dsEval.getMoneySet().get(0)));
        }
        String fmoney = this.getDataSetColumnName(column.getNumber());
        boolean isExistMoney = "2".equalsIgnoreCase(column.getCol_type());
        DataSet dataSet = this.getDataSet();
        dataSet = this.filter(this.input, this.dsEval, this.dsInfo, dataSet);
        if (isExistMoney) {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                BigDecimal val = row.getBigDecimal(fmoney);
                result = result.add(TypeUtils.convertToDecimal(val));
            }
            return result;
        }
        int index = 0;
        String resultStr = "";
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String val = row.getString(fmoney);
            if (val == null) {
                val = "";
            }
            val = val.trim();
            if (index == 0) {
                resultStr = val;
            } else if (!resultStr.equalsIgnoreCase(val)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u4e0d\u76f8\u540c\u6210\u5458\u3002", (String)"ExpressionDSHelper_22", (String)"epm-far-business", (Object[])new Object[0]));
            }
            ++index;
        }
        return resultStr;
    }

    public List<Map<String, Object>> getMultiRow() {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.input.getDmModelId());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(2);
        LinkedHashMap<String, DataSetCaclColumn> columnConvertMap = new LinkedHashMap<String, DataSetCaclColumn>(10);
        String[] soucreSums = this.dsEval.getMoneySet().toArray(new String[0]);
        boolean isAll = false;
        for (String oldSum : soucreSums) {
            if ("*".equalsIgnoreCase(oldSum)) {
                isAll = true;
                break;
            }
            DataSetCaclColumn column = ExpressionDSHelper.getColum(modelStrategyEx, this.dsInfo, oldSum);
            String newSum = this.getDataSetColumnName(column.getNumber());
            if (column == null || !StringUtils.isNotEmpty((String)newSum)) continue;
            columnConvertMap.put(newSum, column);
        }
        if (isAll) {
            columnConvertMap.clear();
            for (DataSetCaclColumn column : this.dsInfo.getColumns()) {
                String newSum = this.getDataSetColumnName(column.getNumber());
                columnConvertMap.put(newSum, column);
            }
        }
        DataSet dataSet = this.getDataSet();
        dataSet = this.filter(this.input, this.dsEval, this.dsInfo, dataSet);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            LinkedHashMap<String, Object> itemMap = new LinkedHashMap<String, Object>(columnConvertMap.size());
            for (Map.Entry newColumn : columnConvertMap.entrySet()) {
                DataSetCaclColumn column = (DataSetCaclColumn)newColumn.getValue();
                if ("2".equalsIgnoreCase(column.getCol_type())) {
                    BigDecimal val = row.getBigDecimal((String)newColumn.getKey());
                    itemMap.put(column.getNumber(), TypeUtils.convertToDecimal(val));
                    continue;
                }
                itemMap.put(column.getNumber(), row.getString((String)newColumn.getKey()));
            }
            list.add(itemMap);
        }
        return list;
    }
}

