/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.expression.calculate.func;

import java.math.BigDecimal;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.expression.base.AbstractExpressionEval;
import kd.epm.far.business.common.expression.base.ExpressionUtils;
import kd.epm.far.business.common.expression.calculate.func.ExpressionFuncSplitFlagHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExpressionFuncCalcHelper {
    private static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(ExpressionFuncCalcHelper.class);

    public static boolean calc(AbstractExpressionEval dsEval) {
        String expressionLast;
        CellValue cellVal;
        boolean isNeedCalc;
        String tips = "";
        if (dsEval == null) {
            return false;
        }
        if (dsEval.getChilds().size() == 0) {
            ExpressionUtils.setSourceResult(dsEval);
            return true;
        }
        if (dsEval.getChilds().size() == 1) {
            ExpressionUtils.setSourceResult(dsEval, dsEval.getChilds().get(0));
            return true;
        }
        boolean bl = isNeedCalc = ExpressionUtils.containDs(dsEval) && ExpressionFuncSplitFlagHelper.containExpressionFlag(dsEval.getSource());
        if (dsEval.getChilds().size() > 0 && isNeedCalc && ExpressionUtils.containFloatDs(dsEval)) {
            tips = ResManager.loadKDString((String)"\u6d6e\u52a8\u7ed1\u5b9a\u516c\u5f0f\u5355\u5143\u683c\u5185\u4e0d\u652f\u6301\u5b58\u5728\u5176\u4ed6\u5185\u5bb9\u3002", (String)"ExpressionDSHelper_10", (String)"epm-far-business", (Object[])new Object[0]);
            ExpressionUtils.setErrorResult(dsEval, tips);
            return true;
        }
        StringBuilder expressionStr = new StringBuilder();
        for (AbstractExpressionEval expressionEval : dsEval.getChilds()) {
            expressionStr.append(expressionEval.getResultStr());
        }
        StringBuilder expressionResult = new StringBuilder(expressionStr);
        if (isNeedCalc && (cellVal = ExpressionFuncCalcHelper.calculate(expressionLast = ExpressionFuncSplitFlagHelper.replaceExpressionFlag(expressionStr.toString()))) != null) {
            if (cellVal.getCellType() == CellType.NUMERIC) {
                BigDecimal cellResultE = TypeUtils.convertValueToDecimal(String.valueOf(cellVal.getNumberValue()));
                if (String.valueOf(cellVal.getNumberValue()).toLowerCase().contains("e")) {
                    ExpressionUtils.setSuccessResult(dsEval, cellResultE, cellResultE.toPlainString());
                    return true;
                }
                ExpressionUtils.setSuccessResult(dsEval, cellResultE, ExpressionFuncCalcHelper.getNumberValue(expressionLast, String.valueOf(cellVal.getNumberValue())));
                return true;
            }
            if (cellVal.getCellType() != CellType.ERROR) {
                ExpressionUtils.setSuccessResult(dsEval, cellVal.getStringValue());
                return true;
            }
        }
        ExpressionUtils.setSuccessResult(dsEval, expressionResult.toString());
        return true;
    }

    private static String getNumberValue(String expression, String numberValue) {
        if (expression == null) {
            return numberValue;
        }
        if (expression.toUpperCase(Locale.ENGLISH).contains("ROUND")) {
            return numberValue;
        }
        if (numberValue.endsWith(".0")) {
            return numberValue.substring(0, numberValue.length() - 2);
        }
        return numberValue;
    }

    private static CellValue calculate(String expression) {
        XSSFCell expressioncell;
        XSSFRow expressionRow;
        if (StringUtils.isEmpty((String)expression)) {
            return null;
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("calulate");
        XSSFRow row = sheet.getRow(0);
        if (row == null) {
            row = sheet.createRow(0);
        }
        if ((expressionRow = sheet.getRow(1)) == null) {
            expressionRow = sheet.createRow(1);
        }
        if ((expressioncell = expressionRow.getCell(1)) == null) {
            expressioncell = row.createCell(1, CellType.FORMULA);
        }
        String realExpresstion = expression;
        try {
            expressioncell.setCellFormula(realExpresstion);
        }
        catch (Exception ex) {
            logger.error("dm calculate poi setCellFormula error", (Throwable)ex);
            return null;
        }
        try {
            CellValue cellVal = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator().evaluate((Cell)expressioncell);
            return cellVal;
        }
        catch (Exception ex) {
            logger.error("dm calculate poi evaluate error", (Throwable)ex);
            return null;
        }
    }
}

