/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.MultiBaseEditElement;
import kd.epm.far.business.common.control.TextEditElement;
import kd.epm.far.business.common.util.StringLengthUtil;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.util.ObjectSerialUtil;

public class ElementHelper {
    public static MultiBaseEditElement createMultiBaseEditElement(String name, String sign, String entity) {
        MultiBaseEditElement baseEdit = new MultiBaseEditElement(name, sign, entity);
        baseEdit.setFuzzySearch(false);
        baseEdit.setBtnFontClass("kdfont kdfont-zidingyi");
        ElementHelper.buildF7StyleWithInput(baseEdit, false);
        baseEdit.setWidth(new LocaleString("5%"));
        return baseEdit;
    }

    public static Element addBaseEditElement(Area paramPanel, String shortNumber, boolean isCur, Map<String, Map<String, String>> allDimMap, IPageCache pageCache, String cacheKey) {
        Map<String, String> dimMap = allDimMap.get(shortNumber);
        if (dimMap == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ElementHelper_0", (String)"epm-far-business", (Object[])new Object[0]), shortNumber));
        }
        String s = pageCache.get(cacheKey);
        if (s == null) {
            Element baseEditElement = isCur ? ElementHelper.createBaseEditElement(dimMap.get("name") + "(" + shortNumber + ")", dimMap.get("number"), dimMap.get("membermodel")) : ElementHelper.createMultiBaseEditElement(dimMap.get("name") + "(" + shortNumber + ")", dimMap.get("number"), dimMap.get("membermodel"));
            paramPanel.addElement(baseEditElement);
            HashMap<String, String> dimensionNumberMap = new HashMap<String, String>(16);
            dimensionNumberMap.put(dimMap.get("number"), shortNumber);
            pageCache.put(cacheKey, ElementHelper.toByteSerialized(dimensionNumberMap));
            return baseEditElement;
        }
        Map dimensionNumberMap = (Map)ElementHelper.deSerializedBytes(s);
        if (dimensionNumberMap == null || dimensionNumberMap.isEmpty()) {
            return null;
        }
        if (dimensionNumberMap.containsKey(dimMap.get("number"))) {
            return null;
        }
        Element baseEditElement = isCur ? ElementHelper.createBaseEditElement(dimMap.get("name") + "(" + shortNumber + ")", dimMap.get("number"), dimMap.get("membermodel")) : ElementHelper.createMultiBaseEditElement(dimMap.get("name") + "(" + shortNumber + ")", dimMap.get("number"), dimMap.get("membermodel"));
        paramPanel.addElement(baseEditElement);
        dimensionNumberMap.put(dimMap.get("number"), shortNumber);
        pageCache.put(cacheKey, ElementHelper.toByteSerialized(dimensionNumberMap));
        return baseEditElement;
    }

    private static <T> T deSerializedBytes(String serial) {
        return (T)(serial == null ? null : ObjectSerialUtil.deSerializedBytes((String)serial));
    }

    private static BaseEditElement createBaseEditElement(String name, String sign, String entity) {
        name = StringLengthUtil.cropNameString(name, 20);
        BaseEditElement baseEdit = new BaseEditElement(name, sign, entity);
        ElementHelper.buildF7StyleWithInput(baseEdit, false);
        baseEdit.setWidth(new LocaleString("5%"));
        return baseEdit;
    }

    private static String toByteSerialized(Object t) {
        return ObjectSerialUtil.toByteSerialized((Object)t);
    }

    public static void buildF7Style(Element F7) {
        ElementHelper.buildF7StyleWithInput(F7, true);
    }

    public static void buildF7StyleWithInput(Element F7, boolean mustInput) {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("10px");
        mg.setBottom("30px");
        mg.setRight("0");
        mg.setLeft("20px");
        sl.setMargin(mg);
        String name = F7.getName();
        int labelLength = (name.length() + 1) * 12;
        if (labelLength > 80) {
            labelLength = 80;
        }
        F7.setLabelWidth(new LocaleString(labelLength + "px"));
        F7.setHeight(new LocaleString("40px"));
        F7.setStyle(sl);
        F7.setWidth(new LocaleString("15%"));
        F7.setFontSize(12);
        F7.setFieldTextAlign("left");
        F7.setLabelDirection("v");
        F7.setMustInput(mustInput);
    }

    public static int getTextLength(String text) {
        return (int)((double)TypeUtils.countChineseChars(text) * 6.5) + 12;
    }

    public static void buildPivotF7Style(Element F7) {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("5px");
        mg.setBottom("5px");
        mg.setRight("0");
        mg.setLeft("20px");
        sl.setMargin(mg);
        String name = F7.getName();
        int labelLength = (name.length() + 1) * 12;
        if (labelLength > 80) {
            labelLength = 80;
        }
        F7.setLabelWidth(new LocaleString(labelLength + "px"));
        F7.setHeight(new LocaleString("30px"));
        F7.setStyle(sl);
        F7.setWidth(new LocaleString("15%"));
        F7.setFontSize(12);
        F7.setFieldTextAlign("left");
        F7.setLabelDirection("h");
        F7.setMustInput(true);
    }

    public static void buildF7StyleList(Element F7) {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("10px");
        mg.setBottom("10px");
        mg.setRight("40px");
        mg.setLeft("5px");
        sl.setMargin(mg);
        String name = F7.getName();
        String LabelLength = ElementHelper.getTextLength(name) + "px";
        F7.setLabelWidth(new LocaleString(LabelLength));
        F7.setHeight(new LocaleString("28px"));
        F7.setStyle(sl);
        F7.setWidth(new LocaleString("280px"));
        F7.setFontSize(12);
        F7.setFieldTextAlign("left");
    }

    public static void buildF7StyleListForMutil(TextEditElement F7) {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("10px");
        mg.setBottom("10px");
        mg.setRight("40px");
        mg.setLeft("5px");
        sl.setMargin(mg);
        String name = F7.getName();
        String LabelLength = ElementHelper.getTextLength(name) + "px";
        F7.setLabelWidth(new LocaleString(LabelLength));
        F7.setHeight(new LocaleString("28px"));
        F7.setStyle(sl);
        F7.setWidth(new LocaleString("280px"));
        F7.setFontSize(12);
        F7.setFieldTextAlign("left");
    }

    public static void buildF7StyleForGenrate(TextEditElement F7, int index) {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("20px");
        mg.setBottom("20px");
        if (index % 3 != 0) {
            mg.setRight("60px");
        } else {
            mg.setRight("0px");
        }
        mg.setLeft("0");
        sl.setMargin(mg);
        String name = F7.getName();
        String LabelLength = ElementHelper.getTextLength(name) + "px";
        F7.setLabelWidth(new LocaleString(LabelLength));
        F7.setHeight(new LocaleString("40px"));
        F7.setStyle(sl);
        F7.setWidth(new LocaleString("210px"));
        F7.setFontSize(12);
        F7.setFieldTextAlign("left");
        F7.setMustInput(true);
    }

    public static void buildF7StyleForGenrate(BaseEditElement F7, int index) {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("20px");
        mg.setBottom("20px");
        if (index % 3 != 0) {
            mg.setRight("60px");
        } else {
            mg.setRight("0px");
        }
        mg.setLeft("0");
        sl.setMargin(mg);
        String name = F7.getName();
        String LabelLength = ElementHelper.getTextLength(name) + "px";
        F7.setLabelWidth(new LocaleString(LabelLength));
        F7.setHeight(new LocaleString("40px"));
        F7.setStyle(sl);
        F7.setWidth(new LocaleString("210px"));
        F7.setFontSize(12);
        F7.setFieldTextAlign("left");
        F7.setMustInput(true);
    }

    public static void buildF7StyleForPreview(BaseEditElement F7, int index) {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("20px");
        mg.setBottom("20px");
        if (index % 2 != 0) {
            mg.setRight("60px");
        } else {
            mg.setRight("0px");
        }
        mg.setLeft("0");
        sl.setMargin(mg);
        String name = F7.getName();
        String LabelLength = (name.length() + 1) * 12 + "px";
        F7.setLabelWidth(new LocaleString(LabelLength));
        F7.setHeight(new LocaleString("40px"));
        F7.setStyle(sl);
        F7.setWidth(new LocaleString("210px"));
        F7.setFontSize(12);
        F7.setFieldTextAlign("left");
        F7.setLabelDirection("v");
        F7.setMustInput(true);
    }
}

