/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.util.TypeUtils;

public class DimensionUtils {
    public static DimensionInfo getDimByNumber(List<DimensionInfo> dimList, String dimNumber) {
        if (dimList == null || dimList.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)dimNumber)) {
            return null;
        }
        DimensionInfo find = dimList.stream().filter(m -> dimNumber.equalsIgnoreCase(m.getNumber())).findFirst().orElse(null);
        return find;
    }

    public static DimensionInfo getDimByEntity(List<DimensionInfo> dimList, String entityNumber) {
        if (dimList == null || dimList.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)entityNumber)) {
            return null;
        }
        DimensionInfo find = dimList.stream().filter(m -> entityNumber.equalsIgnoreCase(m.getEntityName())).findFirst().orElse(null);
        return find;
    }

    public static DimensionInfo getDimById(List<DimensionInfo> dimList, Long dimId) {
        if (dimList == null || dimList.size() == 0) {
            return null;
        }
        DimensionInfo find = dimList.stream().filter(m -> m.getId().equals(dimId)).findFirst().orElse(null);
        return find;
    }

    public static List<Map<String, Object>> dimConvertToMap(List<DimensionInfo> dimList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dimList.size());
        for (DimensionInfo item : dimList) {
            result.add(DimensionUtils.dimConvertToMap(item));
        }
        return result;
    }

    public static Map<String, Object> dimConvertToMap(DimensionInfo dim) {
        if (dim == null) {
            return null;
        }
        HashMap<String, Object> item = new HashMap<String, Object>(16);
        item.put("id", dim.getId().toString());
        item.put("number", dim.getNumber());
        item.put("shortNumber", dim.getShortNumber());
        item.put("name", dim.getName());
        item.put("entityName", dim.getEntityName());
        return item;
    }

    public static DimMemberInfo convertToMemberInfo(DynamicObject memberDy) {
        if (memberDy == null) {
            return null;
        }
        DimMemberInfo memberInfo = new DimMemberInfo();
        memberInfo.setId(memberDy.getLong("id"));
        memberInfo.setName(memberDy.getString("name"));
        memberInfo.setNumber(memberDy.getString("number"));
        return memberInfo;
    }

    public static DimMemberInfo convertToMemberInfo(Map memberDy) {
        if (memberDy == null) {
            return null;
        }
        DimMemberInfo memberInfo = new DimMemberInfo();
        memberInfo.setId(TypeUtils.getMapValueLong(memberDy, "id"));
        memberInfo.setName(TypeUtils.getMapValueString(memberDy, "name"));
        memberInfo.setNumber(TypeUtils.getMapValueString(memberDy, "number"));
        return memberInfo;
    }

    public static List<Map<String, Object>> dimMemberConvertToMap(List<DimMemberInfo> members) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(members.size());
        for (DimMemberInfo member : members) {
            result.add(DimensionUtils.dimMemberConvertToMap(member));
        }
        return result;
    }

    public static Map<String, Object> dimMemberConvertToMap(DimMemberInfo member) {
        if (member == null) {
            return null;
        }
        HashMap<String, Object> item = new HashMap<String, Object>(16);
        item.put("id", member.getId().toString());
        item.put("number", member.getNumber());
        item.put("name", member.getName());
        return item;
    }
}

