/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.common.perm.FarFunPermissionHelper;
import kd.epm.far.business.far.utils.MyAnalysisService;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.template.TemplateCatalogHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class DiscModelService {
    public static Map<Long, DynamicObject> getDiscModelStatus(Object[] primaryKeyValues) {
        DynamicObject[] dos;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", (Object)primaryKeyValues);
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(primaryKeyValues.length);
        for (DynamicObject object : dos = (DynamicObject[])QueryServiceHelper.query((String)"fidm_model", (String)"id,name,number,status", (QFilter[])qfBuilder.toArray()).toArray((Object[])new DynamicObject[0])) {
            result.put(object.getLong("id"), object);
        }
        return result;
    }

    public static void updateDiscModelStatus(String isEnable, Object[] primaryKeyValues) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", (Object)primaryKeyValues);
        qfBuilder.add("status", "!=", (Object)isEnable);
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"fidm_model", (String)"id,nuber,name,status,modifier,modifytime", (QFilter[])qfBuilder.toArray());
        Arrays.stream(dos).forEach(p -> {
            p.set("status", (Object)isEnable);
            p.set("modifier", (Object)RequestContext.get().getCurrUserId());
            p.set("modifytime", (Object)TimeServiceHelper.now());
        });
        SaveServiceHelper.save((DynamicObject[])dos);
    }

    public static void createPrepareData(Long dmModelId, String appId) {
        if (!LongUtil.isvalidLong((Object)dmModelId)) {
            return;
        }
        ModuleServiceHelper.addCatalogRoot(dmModelId, "1");
        ModuleServiceHelper.addCatalogRoot(dmModelId, "2");
        if (ApplicationTypeEnum.FAR.getAppnum().equals(appId)) {
            FarFunPermissionHelper.addFarAdminPermission(dmModelId, RequestContext.get().getCurrUserId());
            TemplateCatalogHelper.addCatalogRoot(dmModelId, DiscTemplateCatalogTypeEnum.FAR_CATALOG);
            MyAnalysisService.createMyAnalysisCatalogRoot(dmModelId);
        } else {
            FarFunPermissionHelper.addFidmAdminPermission(dmModelId, RequestContext.get().getCurrUserId());
            TemplateCatalogHelper.addCatalogRoot(dmModelId, DiscTemplateCatalogTypeEnum.TMPL_CATALOG);
            DisclosureChapterHelper.getAndCreateChapterCatalogRoot(dmModelId);
        }
    }
}

