/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.model.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.bcm.BCMMemberHelper;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dto.BCMMember;
import kd.epm.far.business.bcm.dto.BcmPermService;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.adapter.AbstractAdapter;
import kd.epm.far.business.common.model.adapter.DimensionAdapter;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimMemberRange;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.eb.EBDimensionHelper;
import kd.epm.far.business.far.DimDefaultValueHelper;
import kd.epm.far.business.far.model.DimDefaultValueVo;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class DimMemberAdapter
extends AbstractAdapter {
    private Long modelId;
    private DisModelTypeEnum modelTypeEnum;
    private DimensionAdapter dimensionAdapter;

    public DimMemberAdapter(Long modelId, DisModelTypeEnum modelTypeEnum, DimensionAdapter dimensionAdapter) {
        this.modelId = modelId;
        this.modelTypeEnum = modelTypeEnum;
        this.dimensionAdapter = dimensionAdapter;
    }

    public DimMemberInfo findMemberByNumber(String dimNumber, String memberNumber) {
        return this.findMemberByNumber(dimNumber, memberNumber, true);
    }

    public DimMemberInfo findMemberByNumber(String dimNumber, String memberNumber, boolean isShowKdBizException) {
        if (!LongUtil.isvalidLong((Object)this.modelId)) {
            return null;
        }
        DimMemberInfo memberInfo = null;
        try {
            if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(this.modelTypeEnum.getType())) {
                memberInfo = EBDimensionHelper.findMemberByNumber(this.modelId, dimNumber, memberNumber);
            } else {
                String modelNumber = BCMDataReader.findModelNumberById(this.modelId);
                BCMMember bcmMember = BCMMsServiceHelper.findMemberByNumber(modelNumber, dimNumber, memberNumber);
                if (bcmMember == null || !LongUtil.isvalidLong((Object)bcmMember.getMemberId())) {
                    return null;
                }
                memberInfo = new DimMemberInfo();
                memberInfo.setId(bcmMember.getMemberId());
                memberInfo.setNumber(bcmMember.getNumber());
                memberInfo.setName(bcmMember.getName());
            }
        }
        catch (KDBizException kdBizException) {
            if (isShowKdBizException) {
                throw kdBizException;
            }
            return null;
        }
        return memberInfo;
    }

    public DimMemberInfo findMemberById(String entityNumber, Long memberId) {
        return this.findMemberById(entityNumber, memberId, true);
    }

    public DimMemberInfo findMemberById(String entityNumber, Long memberId, boolean isShowKdBizException) {
        if (!LongUtil.isvalidLong((Object)this.modelId)) {
            return null;
        }
        DimMemberInfo memberInfo = null;
        try {
            if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(this.modelTypeEnum.getType())) {
                memberInfo = EBDimensionHelper.getDimMemberById(this.modelId, entityNumber, memberId);
            } else {
                BCMMember bcmMember = BCMMsServiceHelper.findMemberById(this.modelId, entityNumber, memberId);
                if (bcmMember == null || !LongUtil.isvalidLong((Object)bcmMember.getMemberId())) {
                    return null;
                }
                memberInfo = new DimMemberInfo();
                memberInfo.setId(bcmMember.getMemberId());
                memberInfo.setNumber(bcmMember.getNumber());
                memberInfo.setName(bcmMember.getName());
            }
        }
        catch (KDBizException kdBizException) {
            if (isShowKdBizException) {
                throw kdBizException;
            }
            return null;
        }
        return memberInfo;
    }

    public List<DimMemberInfo> getMemberIdsByNumber(DimensionInfo dimension, List<String> memberNumbers) {
        ArrayList<DimMemberInfo> memberInfos = new ArrayList<DimMemberInfo>(1);
        if (dimension == null || memberNumbers == null || memberNumbers.size() == 0) {
            return memberInfos;
        }
        QFBuilder qf = new QFBuilder("number", "in", memberNumbers);
        qf.and("dimension", "=", (Object)dimension.getId());
        qf.and("model", "=", (Object)this.modelId);
        DynamicObjectCollection allmembers = QueryServiceHelper.query((String)dimension.getEntityName(), (String)"id,number,name,longnumber", (QFilter[])qf.toArray());
        memberInfos = new ArrayList(allmembers.size());
        for (DynamicObject item : allmembers) {
            DimMemberInfo memberInfo = new DimMemberInfo();
            memberInfo.setId(item.getLong("id"));
            memberInfo.setNumber(item.getString("number"));
            memberInfo.setName(item.getString("name"));
            memberInfos.add(memberInfo);
        }
        return memberInfos;
    }

    public List<DimMemberRange> getMemberRanges(DimensionInfo dim, List<DimMemberInfo> sourceMembers) {
        ArrayList<DimMemberRange> memberRanges = new ArrayList(100);
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(this.modelTypeEnum.getType())) {
            for (DimMemberInfo source : sourceMembers) {
                DimMemberRange range = new DimMemberRange();
                range.setSource(source);
                range.setMemberInfos(Collections.singletonList(source));
                memberRanges.add(range);
            }
        } else {
            memberRanges = BCMMemberHelper.getMemberRangeDetails(this.modelId, dim, sourceMembers);
        }
        return memberRanges;
    }

    public DimMemberRange getMemberRange(DimensionInfo dim, DimMemberInfo source) {
        List<Object> memberRanges = new ArrayList(100);
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(this.modelTypeEnum.getType())) {
            DimMemberRange range = new DimMemberRange();
            range.setSource(source);
            range.setMemberInfos(Collections.singletonList(source));
            memberRanges.add(range);
        } else {
            memberRanges = BCMMemberHelper.getMemberRangeDetails(this.modelId, dim, Collections.singletonList(source));
        }
        return memberRanges.size() == 0 ? null : (DimMemberRange)memberRanges.get(0);
    }

    public String getRangeName(DimMemberInfo memberInfo) {
        if (memberInfo == null) {
            return "";
        }
        String name = memberInfo.getName();
        if (name == null) {
            name = "";
        }
        if (memberInfo.getRange() == RangeEnum.VALUE_10.getValue()) {
            return name;
        }
        String tips = ResManager.loadKDString((String)"\u7684", (String)"ModelStrategyEx_5", (String)"epm-far-business", (Object[])new Object[0]);
        RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)memberInfo.getRange());
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(tips);
        sb.append(rangeEnum.getName());
        return sb.toString();
    }

    public QFilter getPerm(String columName, Long dimsionId) {
        QFilter qFilter;
        if (DisModelTypeEnum.isCM(this.modelTypeEnum.getType()) && (qFilter = (QFilter)ThreadCache.get((Object)(CacheKey.BasePrefixString + this.modelId + dimsionId + "getPerm"), () -> {
            if (BCMDataReader.isAdmin(this.modelId)) {
                return null;
            }
            BcmPermService bcmPermService = new BcmPermService(this.modelId, dimsionId);
            return bcmPermService.getPermQFilter(columName);
        })) != null) {
            return new QFilter(columName, qFilter.getCP(), qFilter.getValue());
        }
        return null;
    }

    public List<DimensionInfo> getDefaultMembers(String defaultDataSet) {
        if (defaultDataSet == null) {
            defaultDataSet = "";
        }
        List<DimensionInfo> dimList = this.dimensionAdapter.getDimList();
        for (DimensionInfo dimensionInfo : dimList) {
            DimMemberInfo memberInfo;
            DimDefaultValueVo vo = DimDefaultValueHelper.getDefaultValue(dimensionInfo.getShortNumber(), this.modelId, this.modelTypeEnum, defaultDataSet);
            if (vo == null || (memberInfo = this.findMemberByNumber(dimensionInfo.getNumber(), vo.getDefaultValue(), false)) == null) continue;
            dimensionInfo.getMembers().add(memberInfo);
        }
        return dimList;
    }

    public List<DimMemberInfo> getMemberList(DimensionInfo dimension, String keyword, int top) {
        ArrayList<DimMemberInfo> memberInfos = new ArrayList<DimMemberInfo>(1);
        QFBuilder qf = new QFBuilder("model", "=", (Object)this.modelId);
        qf.and("dimension", "=", (Object)dimension.getId());
        String string = keyword = keyword == null ? "" : keyword.trim();
        if (StringUtils.isNotEmpty((String)keyword)) {
            keyword = "%" + keyword + "%";
            qf.and("number", "like", (Object)keyword);
        }
        DynamicObjectCollection allmembers = QueryServiceHelper.query((String)dimension.getEntityName(), (String)"id,number,name,longnumber", (QFilter[])qf.toArray(), (String)"number", (int)top);
        memberInfos = new ArrayList(allmembers.size());
        for (DynamicObject item : allmembers) {
            DimMemberInfo memberInfo = new DimMemberInfo();
            memberInfo.setId(item.getLong("id"));
            memberInfo.setNumber(item.getString("number"));
            memberInfo.setName(item.getString("name"));
            memberInfos.add(memberInfo);
        }
        return memberInfos;
    }
}

