/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.model.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.BCMDimensionHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.adapter.AbstractAdapter;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.eb.EBDimensionHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.common.common.cache.CacheKey;

public class DimensionAdapter
extends AbstractAdapter {
    private Long modelId;
    private DisModelTypeEnum modelTypeEnum;
    private String dimEntityName;

    public DimensionAdapter(Long modelId, DisModelTypeEnum modelTypeEnum) {
        this.modelId = modelId;
        this.modelTypeEnum = modelTypeEnum;
        this.dimEntityName = this.getDimEntity();
    }

    public final String getDimEntity() {
        String dimEntity = "bcm_dimension";
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(this.modelTypeEnum.getType())) {
            dimEntity = "epm_dimension";
        }
        return dimEntity;
    }

    public List<DimensionInfo> getDimList() {
        return this.getDimList(true);
    }

    public List<DimensionInfo> getDimList(boolean needCopy) {
        List allDim = (List)ThreadCache.get((Object)(CacheKey.BasePrefixString + this.modelId + "DMDimensionList"), () -> {
            QFilter dimFilter = new QFilter("model", "=", (Object)this.modelId);
            String selectField = "id,name,number,shortnumber,dseq,membermodel";
            DynamicObject[] dimDseq = BusinessDataServiceHelper.loadFromCache((String)this.dimEntityName, (String)selectField, (QFilter[])dimFilter.toArray(), (String)"dseq").values().toArray(new DynamicObject[0]);
            ArrayList<DimensionInfo> list = new ArrayList<DimensionInfo>(16);
            for (DynamicObject dim : dimDseq) {
                String dimNum = dim.getString("number");
                DimensionInfo item = new DimensionInfo();
                item.setId(dim.getLong("id"));
                item.setNumber(dimNum);
                item.setShortNumber(dim.getString("shortnumber"));
                item.setName(dim.getString("name"));
                item.setEntityName(dim.getString("membermodel"));
                item.setDseq(dim.getInt("dseq"));
                list.add(item);
            }
            return list;
        });
        if (needCopy) {
            return DisclosureJsonHelper.copyList(allDim, DimensionInfo.class);
        }
        return allDim;
    }

    @Deprecated
    public Map<Object, DynamicObject> getDimMap() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.modelId);
        Map bcmDims = BusinessDataServiceHelper.loadFromCache((String)this.dimEntityName, (String)"id, number, name, membermodel, issysdimension", (QFilter[])qFilter.toArray(), (String)"dseq");
        return bcmDims;
    }

    public Map<Integer, String> getDimSortKey() {
        LinkedHashMap<Integer, String> desqList = new LinkedHashMap<Integer, String>(16);
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(this.modelTypeEnum.getType())) {
            desqList.putAll(EBDimensionHelper.getDimSortKey(this.modelId));
        } else {
            desqList.putAll(BCMDimensionHelper.getDimSortKey(this.modelId));
        }
        return desqList;
    }

    @Deprecated
    public Map<String, Set<Long>> getDimDataMap(List<String> filterDimIdList) {
        List<DimensionInfo> dimList = this.getDimList();
        HashMap<String, Set<Long>> dimMap = new HashMap<String, Set<Long>>(16);
        for (DimensionInfo dimInfo : dimList) {
            if (filterDimIdList != null && filterDimIdList.size() > 0 && !filterDimIdList.contains(dimInfo.getId().toString())) continue;
            String dimKey = dimInfo.getId() + "/" + dimInfo.getNumber().toLowerCase() + "/" + dimInfo.getName() + "/" + dimInfo.getEntityName() + "/" + dimInfo.getShortNumber();
            HashSet allMemberIds = new HashSet(1);
            if (dimMap.get(dimKey) == null) {
                dimMap.put(dimKey, allMemberIds);
                continue;
            }
            Set hasMemberIds = (Set)dimMap.get(dimKey);
            hasMemberIds.addAll(allMemberIds);
        }
        if (filterDimIdList != null && filterDimIdList.size() > 0) {
            LinkedHashMap<String, Set<Long>> dimOrderMap = new LinkedHashMap<String, Set<Long>>(16);
            for (String id : filterDimIdList) {
                String findKey = dimMap.keySet().stream().filter(x -> x.split("/")[0].equals(id)).findAny().orElse(null);
                if (StringUtils.isEmpty((String)findKey)) continue;
                dimOrderMap.put(findKey, (Set<Long>)dimMap.get(findKey));
            }
            dimMap = dimOrderMap;
        }
        return dimMap;
    }

    public List<DimensionInfo> getDimDataByIds(List<String> filterDimIdList) {
        List<DimensionInfo> dimList = this.getDimList();
        if (filterDimIdList != null && filterDimIdList.size() > 0) {
            ArrayList<DimensionInfo> newDimList = new ArrayList<DimensionInfo>(dimList.size());
            for (String id : filterDimIdList) {
                DimensionInfo findKey = dimList.stream().filter(x -> x.getId().toString().equalsIgnoreCase(id)).findAny().orElse(null);
                if (findKey == null) continue;
                newDimList.add(findKey);
            }
            dimList = newDimList;
        }
        return dimList;
    }
}

