/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.model.adapter;

import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.adapter.AbstractAdapter;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.eb.EBDataReader;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.util.LongUtil;

public class ModelAdapter
extends AbstractAdapter {
    private ModelInfo modelInfo;

    public ModelAdapter(Long dmModelId) {
        this.modelInfo = this.getModelInfo(dmModelId);
    }

    private ModelInfo getModelInfo(Long dmModelId) {
        if (!LongUtil.isvalidLong((Object)dmModelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62ab\u9732\u4f53\u7cfbid\u65e0\u6548\u3002", (String)"ModelStrategyEx_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ModelInfo modelEx = (ModelInfo)ThreadCache.get((Object)(CacheKey.BasePrefixString + dmModelId + "DMModelInfo"), () -> {
            DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)dmModelId, (String)"fidm_model", (String)"id,number,name,modeltype,model,status,apptype");
            if (dy == null) {
                return null;
            }
            ModelInfo model = new ModelInfo();
            model.setId(dy.getLong("id"));
            model.setNumber(dy.getString("number"));
            model.setName(dy.getString("name"));
            model.setModelType(dy.getString("modeltype"));
            model.setModelId(dy.getLong("model.id"));
            model.setStatus(dy.getBoolean("status"));
            model.setAppType(dy.getInt("apptype"));
            return model;
        });
        if (modelEx == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62ab\u9732\u4f53\u7cfb\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ModelStrategyEx_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return modelEx;
    }

    public ModelInfo getModelInfo() {
        return this.modelInfo;
    }

    public static ModelInfo getModelInfo(Long dmModelId, boolean showKDBizException) {
        try {
            ModelAdapter adapter = new ModelAdapter(dmModelId);
            return adapter.getModelInfo();
        }
        catch (KDBizException kdBizException) {
            if (showKDBizException) {
                throw kdBizException;
            }
            return null;
        }
    }

    public ResultInfo checkModel() {
        DynamicObject model;
        if (this.modelInfo == null) {
            return ResultInfo.success();
        }
        boolean isExist = false;
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(this.modelInfo.getModelType())) {
            model = EBDataReader.getModel(this.modelInfo.getModelId(), false);
            isExist = model != null;
        } else {
            model = BCMDataReader.getModel(this.modelInfo.getModelId(), false);
            boolean bl = isExist = model != null;
        }
        if (!isExist) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u7684\u6765\u6e90\u4f53\u7cfb\u5df2\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ModelHelper_1", (String)"epm-far-business", (Object[])new Object[0]);
            return ResultInfo.fail(msg);
        }
        return ResultInfo.success();
    }
}

