/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.module;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.enums.ComeFromEnum;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleConvert;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleEntity;
import kd.epm.far.business.common.module.middle.base.IMiddleModuleService;
import kd.epm.far.business.common.module.middle.base.MiddleModuleInput;
import kd.epm.far.business.common.module.middle.base.MiddleModuleResult;
import kd.epm.far.business.epmclient.module.EpmModuleMiddleService;
import kd.epm.far.business.epmclient.module.dto.BaseModule;
import kd.epm.far.business.far.module.middle.base.AnalysisModuleMiddleService;
import kd.epm.far.business.fidm.module.middle.base.DiscModuleMiddleService;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class ModuleMiddleHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, ModuleMiddleHelper.class);

    public static IMiddleModuleService getService(ModuleConvertEnum convertEnum) {
        IMiddleModuleService<JSONObject> iBaseModuleService = null;
        if (convertEnum == ModuleConvertEnum.Fidm) {
            iBaseModuleService = new DiscModuleMiddleService();
        } else if (convertEnum == ModuleConvertEnum.Far) {
            iBaseModuleService = new AnalysisModuleMiddleService();
        } else if (convertEnum == ModuleConvertEnum.EpmClient) {
            iBaseModuleService = new EpmModuleMiddleService();
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u9886\u57df\u8f6c\u6362\u670d\u52a1\u4e0d\u5b58\u5728\u6216\u672a\u6ce8\u518c\u3002", (String)"ModuleMiddleHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return iBaseModuleService;
    }

    private static ModuleConvertEnum getModuleConvertEnum(Long moduleId) {
        Object moduleConvertEnum = null;
        DynamicObject moduleDy = QueryServiceHelper.queryOne((String)"fidm_modulerepository", (String)"id,scope,comefrom", (QFilter[])new QFilter("id", "=", (Object)moduleId).toArray());
        if (moduleDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u4e0d\u5b58\u5728", (String)"DisclosureServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return ModuleMiddleHelper.comefromToModuleConvertType(ComeFromEnum.getComeFromByType(moduleDy.getString("comefrom")));
    }

    public static MiddleModuleResult convertToThird(Long dmModelId, Long moduleId, ModuleConvertEnum end, boolean propertyCheck) {
        MiddleModuleInput input = new MiddleModuleInput();
        try {
            input.setSourceModule(dmModelId);
            input.setDmModelId(dmModelId);
            input.setEnd(end);
            input.setPropertyCheck(propertyCheck);
            if (!LongUtil.isvalidLong((Object)dmModelId) || moduleId == null || end == null) {
                return ModuleMiddleHelper.fail(input, ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u6709\u8bef\u3002", (String)"ModuleMiddleHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
            }
            ModuleConvertEnum begin = ModuleMiddleHelper.getModuleConvertEnum(moduleId);
            input.setBegin(begin);
            IMiddleModuleService beginSerivce = ModuleMiddleHelper.getService(input.getBegin());
            input.setSourceModule(beginSerivce.getModule(dmModelId, moduleId));
            return ModuleMiddleHelper.convertToThird(input, false);
        }
        catch (KDBizException kdEx) {
            return ModuleMiddleHelper.fail(input, kdEx.getMessage());
        }
        catch (Exception ex) {
            String msg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u65e5\u5fd7\u3002", (String)"ModuleMiddleHelper_3", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(msg, (Throwable)ex);
            return ModuleMiddleHelper.fail(input, msg);
        }
    }

    public static MiddleModuleResult convertToThird(MiddleModuleInput input, boolean canSameConvert) {
        if (!LongUtil.isvalidLong((Object)input.getDmModelId()) || input.getSourceModule() == null || input.getBegin() == null || input.getEnd() == null) {
            return ModuleMiddleHelper.fail(input, ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u6709\u8bef\u3002", (String)"ModuleMiddleHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ArrayList<String> tips = new ArrayList<String>(100);
        if (input.getBegin() == input.getEnd() && !canSameConvert) {
            return ModuleMiddleHelper.success(input, input.getSourceModule(), tips);
        }
        try {
            IMiddleModuleService beginSerivce = ModuleMiddleHelper.getService(input.getBegin());
            IMiddleModuleEntity middle = null;
            if (input.getSourceModule() instanceof IMiddleModuleEntity) {
                middle = (IMiddleModuleEntity)input.getSourceModule();
            } else {
                Class beginConvertClass = beginSerivce.getClassByModule(input.getSourceModule());
                middle = ModuleMiddleHelper.toMiddle(beginConvertClass, input, tips);
            }
            Object resultEntity = null;
            if (input.getEnd().getEntityClass().equals(IMiddleModuleEntity.class)) {
                resultEntity = middle;
            } else {
                IMiddleModuleService endSerivce = ModuleMiddleHelper.getService(input.getEnd());
                Class endConvertClass = endSerivce.getClassByMiddle(middle);
                resultEntity = ModuleMiddleHelper.toModule(endConvertClass, input, middle, tips);
            }
            return ModuleMiddleHelper.success(input, resultEntity, tips);
        }
        catch (KDBizException kdEx) {
            return ModuleMiddleHelper.fail(input, kdEx.getMessage());
        }
        catch (Exception ex) {
            String msg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\u65e5\u5fd7\u3002", (String)"ModuleMiddleHelper_3", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(msg, (Throwable)ex);
            return ModuleMiddleHelper.fail(input, msg);
        }
    }

    private static IMiddleModuleEntity toMiddle(Class moduleClass, MiddleModuleInput input, List<String> tips) {
        try {
            if (moduleClass == null) {
                return null;
            }
            IMiddleModuleConvert iBaseModuleConvert = null;
            try {
                iBaseModuleConvert = (IMiddleModuleConvert)moduleClass.newInstance();
            }
            catch (Exception ex) {
                logger.error("dm toMiddle createmodule fail", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u4ef6\u8f6c\u5316\u5668\u5931\u8d25\uff08\u8f6c\u4e2d\u95f4\u7ec4\u4ef6\u5b9e\u4f53\uff09!", (String)"ModuleMiddleHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
            }
            IMiddleModuleEntity IShareModuleEntity = (IMiddleModuleEntity)iBaseModuleConvert.toMiddle(input, input.getSourceModule());
            if (iBaseModuleConvert.getTips() != null) {
                tips.addAll(iBaseModuleConvert.getTips());
            }
            return IShareModuleEntity;
        }
        catch (KDBizException bizEx) {
            throw bizEx;
        }
        catch (Exception ex) {
            logger.error("dm toMiddle fail", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u4ef6\u8f6c\u5316\u5931\u8d25\uff08\u8f6c\u4e2d\u95f4\u7ec4\u4ef6\u5b9e\u4f53\uff09!", (String)"ModuleMiddleHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    private static Object toModule(Class moduleClass, MiddleModuleInput input, IMiddleModuleEntity middle, List<String> tips) {
        try {
            if (moduleClass == null) {
                return null;
            }
            IMiddleModuleConvert iBaseModuleConvert = null;
            try {
                iBaseModuleConvert = (IMiddleModuleConvert)moduleClass.newInstance();
            }
            catch (Exception ex) {
                logger.error("dm toMiddle createmodule fail", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u4ef6\u8f6c\u5316\u5668\u5931\u8d25\uff08\u8f6c\u9886\u57df\u7ec4\u4ef6\u5b9e\u4f53\uff09!", (String)"ModuleMiddleHelper_6", (String)"epm-far-business", (Object[])new Object[0]));
            }
            Object module = iBaseModuleConvert.toModule(input, middle);
            if (iBaseModuleConvert.getTips() != null) {
                tips.addAll(iBaseModuleConvert.getTips());
            }
            return module;
        }
        catch (KDBizException bizEx) {
            throw bizEx;
        }
        catch (Exception ex) {
            logger.error("dm toMiddle fail", (Throwable)ex);
            return null;
        }
    }

    private static MiddleModuleResult fail(MiddleModuleInput input, String msg) {
        ArrayList<String> tips = new ArrayList<String>(10);
        tips.add(msg);
        MiddleModuleResult result = new MiddleModuleResult();
        result.setSuccess(false);
        result.setTips(tips);
        result.setInput(input);
        return result;
    }

    private static MiddleModuleResult success(MiddleModuleInput input, Object resultEntity, List<String> tips) {
        MiddleModuleResult<Object> result = new MiddleModuleResult<Object>();
        result.setSuccess(true);
        result.setTips(tips);
        result.setInput(input);
        result.setResult(resultEntity);
        return result;
    }

    public static ModuleConvertEnum comefromToModuleConvertType(ComeFromEnum comeFrom) {
        switch (comeFrom) {
            case CM: 
            case FIDM: {
                return ModuleConvertEnum.Fidm;
            }
            case FAR: {
                return ModuleConvertEnum.Far;
            }
            case EPMC: {
                return ModuleConvertEnum.EpmClient;
            }
        }
        return ModuleConvertEnum.Fidm;
    }

    public static enum ModuleConvertEnum {
        Fidm(1, JSONObject.class),
        Far(2, JSONObject.class),
        EpmClient(3, BaseModule.class);

        int type = 1;
        Class entityClass;

        private ModuleConvertEnum(int type, Class entityClass) {
            this.type = type;
            this.entityClass = entityClass;
        }

        public Class getEntityClass() {
            return this.entityClass;
        }
    }
}

