/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.module;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.org.model.EnableEnum;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.module.ModuleMiddleHelper;
import kd.epm.far.business.common.module.dto.Module;
import kd.epm.far.business.common.module.dto.ModuleCatalog;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.epmclient.EpmModuleServiceHelper;
import kd.epm.far.business.far.enums.ModuleEnum;
import kd.epm.far.business.fidm.module.DisclosureModuleHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class ModuleServiceHelper {
    public static final String[] CATALOG_TYPE_VALUE = new String[]{"1", "2"};
    public static final List<String> FIDMCOMBOITEM = Arrays.asList("3", "8", "2", "6", "12", "13", "5", "4", "7", "14");
    public static final List<String> FARCOMBOITEM = Arrays.asList("62", "63", "64", "65", "66", "67", "68", "69", "73", "74");
    public static final int WORD = 1;
    public static final String FIDMMODEL = "fidmmodel";
    private static final String ENTITY_NAME_MODULE = "fidm_modulerepository";
    private static final String CATALOG_ENTITY_NAME = "fidm_modulecatalog";
    private static final int ANALYSIS = 16;
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ModuleServiceHelper.class);

    public static DynamicObject addCatalogRoot(Long dmModelId, String catalogtype) {
        QFilter mqFilter = new QFilter("model", "=", (Object)dmModelId);
        QFilter catalogFilter = new QFilter("catalogtype", "in", (Object)catalogtype);
        QFilter nqFilter = new QFilter("number", "=", (Object)"root");
        DynamicObject cate = QueryServiceHelper.queryOne((String)CATALOG_ENTITY_NAME, (String)"id,model,number,longnumber,name,isleaf,catalogtype,status,enable", (QFilter[])new QFilter[]{mqFilter, catalogFilter, nqFilter});
        if (cate == null) {
            DynamicObject catalog = BusinessDataServiceHelper.newDynamicObject((String)CATALOG_ENTITY_NAME);
            catalog.set("model", (Object)dmModelId);
            catalog.set("number", (Object)"root");
            catalog.set("longnumber", (Object)"root");
            catalog.set("name", (Object)ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u7c7b", (String)"ModuleRepositoryListPlugin_0", (String)"epm-far-business", (Object[])new Object[0]));
            catalog.set("isleaf", (Object)Boolean.TRUE);
            catalog.set("catalogtype", (Object)catalogtype);
            catalog.set("status", (Object)"C");
            catalog.set("enable", (Object)"1");
            SaveServiceHelper.save((IDataEntityType)catalog.getDynamicObjectType(), (Object[])new Object[]{catalog});
            return catalog;
        }
        return cate;
    }

    public static boolean isExsistMoudleNumber(Long modelId, String moudelNumber, String bizAppid) {
        return QueryServiceHelper.exists((String)ENTITY_NAME_MODULE, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)moudelNumber).and("template", "=", (Object)0)});
    }

    public static List<Map<String, Object>> getModuleList(Long dmModelId) {
        return ModuleServiceHelper.getModuleList(dmModelId, "2");
    }

    public static List<Map<String, Object>> getModuleList(Long dmModelId, String catalogtype) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String catalogFields = "id,name,number,parent,catalogtype";
        QFBuilder catalogBuilder = new QFBuilder("model", "=", (Object)dmModelId);
        ModuleServiceHelper.addPermClassFilter(CATALOG_ENTITY_NAME, catalogBuilder, dmModelId, catalogtype);
        DynamicObjectCollection catalogs = QueryServiceHelper.query((String)CATALOG_ENTITY_NAME, (String)catalogFields, (QFilter[])catalogBuilder.toArray(), (String)"level,sequence");
        if (CollectionUtils.isEmpty((Collection)catalogs)) {
            return result;
        }
        for (DynamicObject catalogDy : catalogs) {
            HashMap<String, String> catalog = new HashMap<String, String>(6);
            catalog.put("id", catalogDy.getString("id"));
            if ("0".equals(catalogDy.getString("parent"))) {
                catalog.put("name", ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u7c7b", (String)"AbstractModuleTreePlugin_6", (String)"epm-far-business", (Object[])new Object[0]));
            } else {
                catalog.put("name", catalogDy.getString("name"));
            }
            catalog.put("number", catalogDy.getString("number"));
            catalog.put("parent", catalogDy.getString("parent"));
            catalog.put("type", "");
            catalog.put("moduleType", "0");
            if ("root".equals(catalogDy.getString("number")) && "2".equals(catalogDy.getString("catalogtype"))) continue;
            result.add(catalog);
        }
        String moduleFields = "id,name,number,catalog.id,type";
        QFBuilder moduleBuilder = new QFBuilder("model", "=", (Object)dmModelId).add("status", "=", (Object)"1");
        moduleBuilder.add("scope", "=", (Object)catalogtype);
        moduleBuilder.add("catalog.id", "!=", (Object)0L);
        ModuleServiceHelper.addPermClassFilter(ENTITY_NAME_MODULE, moduleBuilder, dmModelId, catalogtype);
        DynamicObjectCollection modules = QueryServiceHelper.query((String)ENTITY_NAME_MODULE, (String)moduleFields, (QFilter[])moduleBuilder.toArray());
        for (DynamicObject moduleDy : modules) {
            HashMap<String, String> module = new HashMap<String, String>(6);
            module.put("id", moduleDy.getString("id"));
            module.put("name", moduleDy.getString("name"));
            module.put("number", moduleDy.getString("number"));
            module.put("parent", moduleDy.getString("catalog.id"));
            module.put("type", moduleDy.getString("type"));
            module.put("moduleType", "1");
            result.add(module);
        }
        return result;
    }

    public static Map<String, Object> getModule(Long dmModelId, Long moduleId) {
        String moduleFields = "id,name,number,catalog.id,type,properties";
        QFBuilder moduleBuilder = new QFBuilder("id", "=", (Object)moduleId);
        DynamicObject moduleDy = QueryServiceHelper.queryOne((String)ENTITY_NAME_MODULE, (String)moduleFields, (QFilter[])moduleBuilder.toArray());
        HashMap<String, String> module = null;
        if (Objects.nonNull(moduleDy)) {
            module = new HashMap<String, String>(6);
            module.put("id", moduleDy.getString("id"));
            module.put("name", moduleDy.getString("name"));
            module.put("number", moduleDy.getString("number"));
            module.put("parent", moduleDy.getString("catalog.id"));
            module.put("type", moduleDy.getString("type"));
            module.put("properties", moduleDy.getString("properties"));
        }
        return module;
    }

    private static void addPermClassFilter(String entityName, QFBuilder qFilter, Long dmModelId, String scope) {
        ArrayList noPermIds = new ArrayList();
        Long userId = RequestContext.get().getCurrUserId();
        noPermIds.addAll(PermClassEntityHelper.getDiscPermissionMap(entityName, dmModelId, userId, "2".equals(scope) ? ApplicationTypeEnum.FAR.getAppnum() : ApplicationTypeEnum.FIDM.getAppnum()).get((Object)"1"));
        qFilter.add(new QFilter("id", "not in", noPermIds));
    }

    public static String getModuleApplyType(String type) {
        int applytype = 0;
        if (kd.epm.far.business.common.enums.ModuleEnum.containsType(type).booleanValue() || FARCOMBOITEM.contains(type)) {
            ++applytype;
        }
        if (ModuleEnum.containsType(type).booleanValue() || FIDMCOMBOITEM.contains(type)) {
            applytype += 16;
        }
        return String.valueOf(applytype);
    }

    public static String getModuleTypeByNumber(String number, String bizAppid) {
        String type = "";
        if (AppCatalogTypeEnum.FAR_CATALOG.getType().equals(AppCatalogTypeEnum.getCatalogByAppId(bizAppid).getType())) {
            ModuleEnum farModuleEnum = ModuleEnum.getModuleByNumber(number);
            type = farModuleEnum.getType();
        } else if (AppCatalogTypeEnum.FIDM_CATALOG.getType().equals(AppCatalogTypeEnum.getCatalogByAppId(bizAppid).getType())) {
            kd.epm.far.business.common.enums.ModuleEnum fidmModuleEnum = kd.epm.far.business.common.enums.ModuleEnum.getModuleByNumber(number);
            type = fidmModuleEnum.getType();
        }
        return type;
    }

    public static String getDisplayApplyType(String applyType) {
        String binaryValue = Integer.toBinaryString(Integer.parseInt(applyType));
        HashMap<Integer, String> nameValueMap = new HashMap<Integer, String>(16);
        nameValueMap.put(0, "WORD");
        nameValueMap.put(1, "PPT");
        nameValueMap.put(2, "PDF");
        nameValueMap.put(3, "XML");
        nameValueMap.put(4, ResManager.loadKDString((String)"\u5206\u6790", (String)"ModuleRepositoryListPlugin_27", (String)"epm-far-business", (Object[])new Object[0]));
        StringBuilder applyTypeName = new StringBuilder();
        String[] binaryValueSplit = binaryValue.split("");
        for (int i = binaryValue.length() - 1; i >= 0; --i) {
            if (!binaryValueSplit[i].equals("1")) continue;
            applyTypeName.append((String)nameValueMap.get(binaryValue.length() - i - 1));
            applyTypeName.append(";");
        }
        String result = "";
        if (!StringUtils.isEmpty((String)applyTypeName.toString())) {
            result = applyTypeName.substring(0, applyTypeName.length() - 1);
        }
        return result;
    }

    public static List<Module> getModulesForChapter(long modelId, long chapterId) {
        HashMap<Long, Integer> moduleIds = new HashMap<Long, Integer>(6);
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        for (DynamicObject entry : chapter.getDynamicObjectCollection("entryentity")) {
            moduleIds.put(entry.getLong("module_id"), entry.getInt("seq"));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("id", "in", moduleIds.keySet()));
        DynamicObjectCollection moduleDatas = QueryServiceHelper.query((String)ENTITY_NAME_MODULE, (String)"id,number,name,type,datasetid.id,properties,comefrom", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<Module> modules = new ArrayList<Module>(moduleDatas.size());
        for (DynamicObject dy : moduleDatas) {
            Module module = new Module();
            module.setId(dy.getLong("id"));
            module.setNumber(dy.getString("number"));
            module.setName(dy.getString("name"));
            module.setType(dy.getString("type"));
            module.setComeFrom(dy.getString("comefrom"));
            module.setDataSetId(dy.getLong("datasetid.id"));
            module.setProperties(dy.getString("properties"));
            if (moduleIds.containsKey(dy.getLong("id"))) {
                module.setSeq((Integer)moduleIds.get(dy.getLong("id")));
            }
            String properties = EpmModuleServiceHelper.convertToEpmModuleProperties(modelId, dy.getLong("id"), chapter.getString("comefrom"), dy.getString("properties"));
            module.setProperties(properties);
            modules.add(module);
        }
        return modules;
    }

    public static List<ModuleCatalog> getCatalogs(long modelId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("status", "=", (Object)StatusEnum.Checked.toString()));
        qFilters.add(new QFilter("enable", "=", (Object)EnableEnum.Enable.toString()));
        DynamicObjectCollection catalogDatas = QueryServiceHelper.query((String)CATALOG_ENTITY_NAME, (String)"id,number,name,longnumber,sequence,level,isleaf,parent.id", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<ModuleCatalog> catalogs = new ArrayList<ModuleCatalog>(catalogDatas.size());
        for (DynamicObject dy : catalogDatas) {
            ModuleCatalog catalog = new ModuleCatalog();
            catalog.setId(dy.getLong("id"));
            catalog.setNumber(dy.getString("number"));
            catalog.setName(dy.getString("name"));
            catalog.setLongNumber(dy.getString("longnumber"));
            catalog.setLevel(dy.getInt("level"));
            catalog.setIsLeaf(dy.getBoolean("isleaf"));
            catalog.setDseq(dy.getInt("sequence"));
            catalog.setParentId(dy.getLong("parent.id"));
            catalogs.add(catalog);
        }
        return catalogs;
    }

    public static List<Module> getModulesForRepository(long modelId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("template", "=", (Object)0L));
        qFilters.add(new QFilter("catalog", ">", (Object)0L));
        qFilters.add(PermissionHelper.getReadAndWritePermFilter(modelId, ENTITY_NAME_MODULE));
        DynamicObjectCollection moduleDatas = QueryServiceHelper.query((String)ENTITY_NAME_MODULE, (String)"id,number,name,catalog.id,type,status,scope,permclass.id,description,copyfrom,comefrom,datasetid.id,creator.name,createtime,modifier.name,modifytime,applytype", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<Module> modules = new ArrayList<Module>(moduleDatas.size());
        for (DynamicObject dy : moduleDatas) {
            int applyType = 0;
            if (StringUtils.isNotEmpty((String)dy.getString("applytype"))) {
                applyType = Integer.parseInt(dy.getString("applytype"));
            }
            if ((applyType & 1) <= 0) continue;
            Module module = ModuleServiceHelper.convertToEpmModel(modelId, dy, null);
            modules.add(module);
        }
        return modules;
    }

    public static Module getModule(long modelId, long moduleId, Map<String, Long> dimMembers) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("id", "=", (Object)moduleId));
        DynamicObject dyModule = QueryServiceHelper.queryOne((String)ENTITY_NAME_MODULE, (String)"id,number,name,catalog.id,type,status,scope,permclass.id,description,copyfrom,comefrom,datasetid.id,creator.name,createtime,modifier.name,modifytime,template.id,properties,charttemplatedata", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dyModule == null) {
            return null;
        }
        String properties = dyModule.getString("properties");
        Module module = ModuleServiceHelper.convertToEpmModel(modelId, dyModule, dimMembers);
        if (kd.epm.far.business.common.enums.ModuleEnum.REPORT_SECTION.getType().equals(module.getType()) || kd.epm.far.business.common.enums.ModuleEnum.EB_REPORT_SECTION.getType().equals(module.getType())) {
            List<DimensionInfo> filterDims = DisclosureModuleHelper.getPreviewVars(modelId, JSON.parseObject((String)properties));
            HashMap<Long, Long> preViewDims = new HashMap<Long, Long>(filterDims.size());
            for (DimensionInfo dim : filterDims) {
                preViewDims.put(dim.getId(), dim.getMembers().isEmpty() ? Long.valueOf(0L) : dim.getMembers().get(0).getId());
            }
            module.setPreViewDims(preViewDims);
        }
        return module;
    }

    private static Module convertToEpmModel(long modelId, DynamicObject dy, Map<String, Long> dimMembers) {
        Module module = new Module();
        module.setId(dy.getLong("id"));
        module.setNumber(dy.getString("number"));
        module.setName(dy.getString("name"));
        module.setCatalogId(dy.getLong("catalog.id"));
        module.setType(dy.getString("type"));
        module.setTypeNumber(kd.epm.far.business.common.enums.ModuleEnum.getModuleByType(dy.getString("type")).getNumber());
        module.setStatus(dy.getBoolean("status"));
        module.setScope(dy.getString("scope").trim());
        module.setPermClassId(dy.getLong("permclass.id"));
        module.setDescription(dy.getString("description"));
        module.setCopyFrom(dy.getLong("copyfrom"));
        module.setComeFrom(dy.getString("comefrom"));
        module.setDataSetId(dy.getLong("datasetid.id"));
        module.setCreator(dy.getString("creator.name"));
        module.setCreateTime(dy.getDate("createtime"));
        module.setModifier(dy.getString("modifier.name"));
        module.setModifyTime(dy.getDate("modifytime"));
        if (dy.containsProperty("template.id")) {
            module.setTemplateId(dy.getLong("template.id"));
        }
        if (dy.containsProperty("properties")) {
            module.setProperties(dy.getString("properties"));
        }
        if (dy.containsProperty("charttemplatedata")) {
            module.setChartTemplateData(dy.getString("charttemplatedata"));
        }
        EpmModuleServiceHelper.setModuleFileByte(modelId, module, dimMembers);
        String properties = EpmModuleServiceHelper.convertToEpmModuleProperties(modelId, module.getId(), module.getComeFrom(), module.getProperties());
        module.setProperties(properties);
        return module;
    }

    public static ResultInfo setModuleStatus(long modelId, long moduleId, boolean enable) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("id", "=", (Object)moduleId));
        if (!PermissionHelper.hasWritePerm(modelId, ENTITY_NAME_MODULE, moduleId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u4ef6\u7684\u5199\u6743\u9650\u3002", (String)"ModuleServiceHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME_MODULE, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dy == null) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"ModuleServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        dy.set("status", (Object)(enable ? "1" : "0"));
        dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dy.set("modifytime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
        return ResultInfo.success(moduleId);
    }

    public static ResultInfo deleteModule(long modelId, long moduleId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("id", "=", (Object)moduleId));
        if (!PermissionHelper.hasWritePerm(modelId, ENTITY_NAME_MODULE, moduleId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u4ef6\u7684\u5199\u6743\u9650\u3002", (String)"ModuleServiceHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_NAME_MODULE, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dy == null) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"ModuleServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if ("1".equals(dy.getString("status"))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664\u3002", (String)"ModuleServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        PlatUtil.executeWithTXNew(tx -> {
            DeleteServiceHelper.delete((String)ENTITY_NAME_MODULE, (QFilter[])qFilters.toArray(new QFilter[0]));
            PermissionHelper.savePermClassEntity(modelId, moduleId, ENTITY_NAME_MODULE, 0L, OperationStatus.EDIT);
        });
        return ResultInfo.success(moduleId);
    }

    public static ResultInfo checkModule(long modelId, String number, String name, long catalogId, String description, String moduleJson) {
        if (StringUtils.isEmpty((String)number)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModuleServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!FarNumberRule.checkModuleNumber(number)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ModuleServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        boolean existsModuleNumber = ModuleServiceHelper.isExsistMoudleNumber(modelId, number, AppCatalogTypeEnum.FIDM_CATALOG.getAppId());
        if (existsModuleNumber) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d\u3002", (String)"ModuleServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)name)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModuleServiceHelper_6", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (catalogId == 0L) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5e93\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ModuleServiceHelper_7", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)moduleJson)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u7ec4\u4ef6\u3002", (String)"ModuleServiceHelper_8", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (number.length() > 50) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7ec4\u4ef6\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"ModuleServiceHelper_10", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (name.length() > 50) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7ec4\u4ef6\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"ModuleServiceHelper_11", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)description) && description.length() > 500) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u7ec4\u4ef6\u63cf\u8ff0\u8bf4\u660e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500\u3002", (String)"ModuleServiceHelper_12", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return ResultInfo.success();
    }

    public static ModuleMiddleHelper.ModuleConvertEnum saveWordTypeToModuleConvertType(OpenWordEnum saveWordType) {
        switch (saveWordType) {
            case WEBOFFICE: 
            case WPS: 
            case WPSPLUGIN: 
            case WEB: {
                return ModuleMiddleHelper.ModuleConvertEnum.Fidm;
            }
            case EPMCLIENT: {
                return ModuleMiddleHelper.ModuleConvertEnum.EpmClient;
            }
        }
        return ModuleMiddleHelper.ModuleConvertEnum.Fidm;
    }

    public static String getFidmModuleType(String type) {
        ModuleEnum farType = ModuleEnum.getModuleByNumber(type);
        switch (farType) {
            case Analysis_DATA_POINT: {
                return kd.epm.far.business.common.enums.ModuleEnum.VAR.getType();
            }
            case Analysis_BAR_CHART_BAR: {
                return kd.epm.far.business.common.enums.ModuleEnum.STACKED_COLUMNAR.getType();
            }
            case Analysis_PIE_CHART_PIE: {
                return kd.epm.far.business.common.enums.ModuleEnum.PIE.getType();
            }
            case Analysis_BAR_CHART_STACK_BAR_CHART: {
                return kd.epm.far.business.common.enums.ModuleEnum.STACKED_BAR.getType();
            }
            case Analysis_BAR_CHART_AREATA_BAR_CHART: {
                return kd.epm.far.business.common.enums.ModuleEnum.CLUSTERED_BAR.getType();
            }
            case Analysis_BAR_CHART_BAR_AREATA: {
                return kd.epm.far.business.common.enums.ModuleEnum.CLUSTERED_COLUMNAR.getType();
            }
            case Analysis_LINE_CHART_POLYLINE: {
                return kd.epm.far.business.common.enums.ModuleEnum.LINE.getType();
            }
            case Analysis_PIE_CHART_DOUGHNUT: {
                return kd.epm.far.business.common.enums.ModuleEnum.DOUGHNUT.getType();
            }
            case Analysis_LINE_CHART_STACK_SQUARE: {
                return kd.epm.far.business.common.enums.ModuleEnum.AREA.getType();
            }
            case Analysis_BAR_CHART_BAR_POLYLINE_STACK: {
                return kd.epm.far.business.common.enums.ModuleEnum.LINE_STACKED_COLUMNAR.getType();
            }
            case Analysis_BAR_CHART_BAR_POLYLINE_AREATA: {
                return kd.epm.far.business.common.enums.ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType();
            }
            case Analysis_COMPONENT_TABLE: {
                return kd.epm.far.business.common.enums.ModuleEnum.TABLE.getType();
            }
        }
        return type;
    }

    public static String converToModuleName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return "";
        }
        if (name.trim().length() > 50) {
            return name.trim().substring(0, 50);
        }
        return name.trim();
    }
}

