/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.module.middle.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.dto.DatasetVarAndDim;
import kd.epm.far.business.common.dataset.filter.DatasetFilterHelper;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetColumnNode;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetDimParamNode;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetFilterItemNode;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetFormulaNode;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetNode;
import kd.epm.far.business.common.module.middle.node.dataset.DatasetVarParamNode;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;

public class DatasetNodeHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, DatasetNodeHelper.class);

    public static DatasetNode resetDatasetNode(Long dmModelId, Long chapterId, DatasetNode sourceNode, List<String> strTips) {
        String msg = "";
        if (sourceNode == null) {
            return null;
        }
        DatasetNode newDataSet = null;
        try {
            Object find;
            Long datasetId = LongUtil.toLong((Object)sourceNode.id);
            if (sourceNode.varParams == null) {
                sourceNode.varParams = new ArrayList<DatasetVarParamNode>(100);
            }
            newDataSet = DatasetNodeHelper.createDataSourceNode(dmModelId, chapterId, datasetId);
            if (newDataSet.varParams != null) {
                for (DatasetVarParamNode varParam : newDataSet.varParams) {
                    find = sourceNode.varParams.stream().filter(m -> Objects.equals(m.number, varParam.number)).findAny().orElse(null);
                    if (find == null || !StringUtils.isNotEmpty((String)((DatasetVarParamNode)find).modifyvalue)) continue;
                    varParam.modifyvalue = ((DatasetVarParamNode)find).modifyvalue;
                }
            }
            if (newDataSet.dimParams != null) {
                for (DatasetDimParamNode dimParam : newDataSet.dimParams) {
                    find = sourceNode.dimParams.stream().filter(m -> Objects.equals(m.number, dimParam.number)).findAny().orElse(null);
                    if (find == null) continue;
                    if (((DatasetDimParamNode)find).member != null) {
                        dimParam.member = ((DatasetDimParamNode)find).member;
                        dimParam.dislapyText = ((DatasetDimParamNode)find).member.name;
                    }
                    if (!DatasetDimParamNode.IsDimEnum.Mutil.getType().equalsIgnoreCase(dimParam.isDim) || ((DatasetDimParamNode)find).members == null || ((DatasetDimParamNode)find).members.size() <= 0) continue;
                    dimParam.member = new DatasetDimParamNode.DimParamMember();
                    dimParam.members = ((DatasetDimParamNode)find).members;
                    dimParam.dislapyText = String.join((CharSequence)",", dimParam.members.stream().map(m -> m.name).collect(Collectors.toList()));
                }
            }
            if (!DatasetNodeHelper.checkDatasetChange(sourceNode.detail, newDataSet.detail)) {
                msg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u7684\u6570\u636e\u96c6\uff0c\u516c\u5f0f\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"ModuleMiddleHelper_0", (String)"epm-far-business", (Object[])new Object[0]);
                strTips.add(msg);
            }
            newDataSet.datesetFilterItems = DisclosureJsonHelper.copyList(sourceNode.datesetFilterItems, DatasetFilterItemNode.class);
            newDataSet.datesetFilterItemsStr = sourceNode.datesetFilterItemsStr;
            if (sourceNode.formula != null) {
                DatasetFormulaNode formulaNode = new DatasetFormulaNode();
                formulaNode.id = sourceNode.formula.id;
                formulaNode.number = sourceNode.formula.number;
                formulaNode.name = sourceNode.formula.name;
                newDataSet.formula = formulaNode;
            }
        }
        catch (KDBizException kdEx) {
            throw new KDBizException(kdEx.getMessage());
        }
        catch (Exception ex) {
            logger.error("resetDatasetNode fail:" + ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5237\u65b0\u5931\u8d25\u3002", (String)"ModuleMiddleHelper_15", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return newDataSet;
    }

    public static DatasetNode createDataSourceNode(Long dmModelId, Long chapterId, Long datasetId) {
        DatasetDimParamNode dimParam;
        DimensionInfo findDim;
        DynamicObject dataset = DatasetDataReader.getDataSet(datasetId, false);
        if (dataset == null) {
            return null;
        }
        String type = dataset.getString("type");
        DatasetExpressionHelper.checkExpression(dmModelId, datasetId);
        List<Object> columnList = new ArrayList(100);
        if ("2".equals(type)) {
            columnList = DatasetNodeHelper.getColumns(dmModelId, datasetId);
        }
        List<DimensionInfo> dimList = new ModelStrategyEx(dmModelId).getDim().getDimList();
        DatasetVarAndDim varAndDimResult = DatasetServiceHelper.getVarAndDimVar(dmModelId, datasetId, chapterId, false);
        List<Map<String, Object>> varSourceList = varAndDimResult.getVariableList();
        List<String> shortNumberList = varAndDimResult.getCurShortNumberList();
        List<String> cursShortNumberList = varAndDimResult.getCursShortNumberList();
        ArrayList<DatasetVarParamNode> varParams = new ArrayList<DatasetVarParamNode>(varSourceList.size());
        for (Map<String, Object> map : varSourceList) {
            boolean isAdd = true;
            DatasetVarParamNode varParamNode = new DatasetVarParamNode();
            varParamNode.name = TypeUtils.convertToString(map.get("name"));
            varParamNode.number = TypeUtils.convertToString(map.get("number"));
            varParamNode.valuetype = TypeUtils.convertToString(map.get("valuetype"));
            varParamNode.disc_dim = TypeUtils.convertToString(map.get("disc_dim"));
            varParamNode.defaultvalueid = TypeUtils.convertToString(map.get("defaultvalueid"));
            varParamNode.defaultvalue = TypeUtils.convertToString(map.get("defaultvalue"));
            varParamNode.dimmembertype = TypeUtils.convertToString(map.get("dimmembertype"));
            varParamNode.modifyvalue = null;
            if (DmVariableTypeEnum.DIM.getIndex().equalsIgnoreCase(varParamNode.valuetype)) {
                String disc_dim = varParamNode.disc_dim;
                DimensionInfo findDim2 = dimList.stream().filter(m -> m.getId().toString().equals(disc_dim)).findAny().orElse(null);
                if (findDim2 != null) {
                    DatasetVarParamNode.Dim dim = new DatasetVarParamNode.Dim();
                    dim.id = findDim2.getId().toString();
                    dim.name = findDim2.getName();
                    dim.number = findDim2.getNumber();
                    dim.shortNumber = findDim2.getShortNumber();
                    dim.entityName = findDim2.getEntityName();
                    varParamNode.dim = dim;
                } else {
                    isAdd = false;
                }
            }
            ArrayList<DatasetVarParamNode.Entryentity> entryentity = new ArrayList<DatasetVarParamNode.Entryentity>(100);
            if (Objects.nonNull(map.get("entryentity"))) {
                for (DynamicObject entry : (DynamicObjectCollection)map.get("entryentity")) {
                    DatasetVarParamNode.Entryentity item = new DatasetVarParamNode.Entryentity();
                    item.id = entry.getString("id");
                    item.enum_number = new LocaleString(entry.getString("enum_number")).getLocaleValue();
                    item.enum_name = new LocaleString(entry.getString("enum_name")).getLocaleValue();
                    entryentity.add(item);
                }
                varParamNode.entryentity = entryentity;
            }
            if (!isAdd) continue;
            varParams.add(varParamNode);
        }
        ArrayList<DatasetDimParamNode> dimParams = new ArrayList<DatasetDimParamNode>(100);
        for (String shortNumber : shortNumberList) {
            findDim = dimList.stream().filter(m -> m.getShortNumber().equals(shortNumber)).findAny().orElse(null);
            if (findDim == null) continue;
            dimParam = new DatasetDimParamNode();
            dimParam.id = findDim.getId().toString();
            dimParam.number = findDim.getNumber();
            dimParam.name = findDim.getName();
            dimParam.shortNumber = findDim.getShortNumber();
            dimParam.entityName = findDim.getEntityName();
            dimParam.member = new DatasetDimParamNode.DimParamMember();
            dimParam.isDim = DatasetDimParamNode.IsDimEnum.Single.getType();
            dimParam.dislapyText = "";
            dimParams.add(dimParam);
        }
        for (String shortNumber : cursShortNumberList) {
            findDim = dimList.stream().filter(m -> m.getShortNumber().equals(shortNumber)).findAny().orElse(null);
            if (findDim == null) continue;
            dimParam = new DatasetDimParamNode();
            dimParam.id = findDim.getId().toString();
            dimParam.number = findDim.getNumber();
            dimParam.name = findDim.getName();
            dimParam.shortNumber = findDim.getShortNumber();
            dimParam.entityName = findDim.getEntityName();
            dimParam.member = new DatasetDimParamNode.DimParamMember();
            dimParam.members = new ArrayList<DatasetDimParamNode.DimParamMember>(1);
            dimParam.isDim = DatasetDimParamNode.IsDimEnum.Mutil.getType();
            dimParam.dislapyText = "";
            dimParams.add(dimParam);
        }
        DatasetNode datasetNode = new DatasetNode();
        datasetNode.id = dataset.getString("id");
        datasetNode.name = dataset.getString("name");
        datasetNode.number = dataset.getString("number");
        datasetNode.type = type;
        datasetNode.dataSrcType = dataset.getString("discmodel.modelsourcetype");
        datasetNode.detail = columnList;
        datasetNode.datesetFilterItems = new ArrayList<DatasetFilterItemNode>(100);
        datasetNode.datesetFilterItemsStr = "";
        datasetNode.dimParams = dimParams;
        datasetNode.varParams = varParams;
        return datasetNode;
    }

    private static List<DatasetColumnNode> getColumns(Long dmModelId, Long datasetId) {
        List<DatasetColumnNode> columns = new ArrayList<DatasetColumnNode>(100);
        try {
            List<Map<String, Object>> columnList = DatasetFilterHelper.invokeDatasetFilterColumn(dmModelId, datasetId);
            columnList.forEach(m -> m.put("id", m.get("number").toString()));
            if (columnList.size() > 0) {
                columns = JSONArray.parseArray((String)JSON.toJSONString(columnList), DatasetColumnNode.class);
            }
        }
        catch (Exception dsEx) {
            logger.error((Throwable)dsEx);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5217\u89e3\u6790\u5931\u8d25\u3002", (String)"DisclosureServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return columns;
    }

    private static boolean checkDatasetChange(List<DatasetColumnNode> oldColumns, List<DatasetColumnNode> newColumns) {
        DatasetColumnNode find;
        if (oldColumns == null || newColumns == null) {
            return false;
        }
        for (DatasetColumnNode oldColumn : oldColumns) {
            find = newColumns.stream().filter(m -> Objects.equals(m.number, oldColumn.number)).findAny().orElse(null);
            if (find != null) continue;
            return false;
        }
        for (DatasetColumnNode newColumn : newColumns) {
            find = oldColumns.stream().filter(m -> Objects.equals(m.number, newColumn.number)).findAny().orElse(null);
            if (find != null) continue;
            return false;
        }
        return true;
    }
}

