/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.mutex;

import java.io.IOException;
import java.util.Map;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;

public class MutexServiceHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean request(String id, String entityKey, String opKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.require(id, "op_" + opKey, entityKey, opKey, true);
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean release(String id, String entityKey, String operationKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.release(id, entityKey, operationKey);
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getLockInfo(String id, String entityKey, String opKey) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            Map map = dataMutex.getLockInfo(id, "op_" + opKey, entityKey);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("accure IOException when closing data mutex!", e);
        }
    }
}

