/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.other;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DisclosureCopyEnum;
import kd.epm.far.business.common.other.dto.CopyFormParam;
import kd.epm.far.business.common.other.dto.CopyFormResult;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.chapter.DisclosureCopyHelper;
import kd.epm.far.business.fidm.template.DisclosureTemplateCopyHelper;

public class GeneralCopyHepler {
    public static void openWindow(IFormView view, IFormPlugin plugin, Long dmModelId, DisclosureCopyEnum copyEnum, Long sourceId, String title) {
        CopyFormParam formParam = new CopyFormParam();
        formParam.setDmModelId(dmModelId);
        formParam.setType(copyEnum.getType());
        formParam.setSoucreId(sourceId);
        GeneralCopyHepler.openWindow(view, plugin, title, formParam);
    }

    public static void openWindow(IFormView view, IFormPlugin plugin, String title, CopyFormParam formParam) {
        String formId = "fidm_data_copy";
        FormShowParameter formShowParameter = DisclosureFormHelper.createFormParam(formParam);
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(view.getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(title);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        view.showForm(formShowParameter);
    }

    public static CopyFormResult copyData(CopyFormParam formParam, String newNumber, String newName) {
        if (formParam == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c!", (String)"DisclosureDataCopy_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)newNumber) || StringUtils.isEmpty((String)newName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u548c\u540d\u79f0\u3002", (String)"DisclosureDataCopy_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ResultInfo resultInfo = FarNumberRule.checkGeneralNumber(newNumber);
        if (!resultInfo.isSuccess().booleanValue()) {
            throw new KDBizException(resultInfo.getMessage());
        }
        CopyFormResult formResult = new CopyFormResult();
        formResult.setInput(formParam);
        String type = formParam.getType();
        Long dmModelId = formParam.getDmModelId();
        Long sourceId = formParam.getSoucreId();
        if (DisclosureCopyEnum.Variable.getType().equals(type)) {
            QFilter qf = new QFilter("model", "=", (Object)dmModelId);
            qf.and("number", "=", (Object)newNumber);
            if (QueryServiceHelper.exists((String)"fidm_disc_variable", (QFilter[])qf.toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DisclosureDataCopy_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
            Long newVarId = DisclosureCopyHelper.copyVariable(sourceId, newNumber, newName);
            formResult.setNewId(newVarId);
        } else if (DisclosureCopyEnum.Template.getType().equals(type)) {
            QFilter qf = new QFilter("model", "=", (Object)dmModelId);
            qf.and("number", "=", (Object)newNumber);
            if (QueryServiceHelper.exists((String)"fidm_template", (QFilter[])qf.toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DisclosureDataCopy_1", (String)"epm-far-business", (Object[])new Object[0]));
            }
            DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"fidm_template");
            if (templateDy != null) {
                Long newTemplateId = DisclosureTemplateCopyHelper.copyTempalte(templateDy, newNumber, newName);
                formResult.setNewId(newTemplateId);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u6b64\u5b9e\u4f53\u590d\u5236\u4e1a\u52a1\u3002", (String)"DisclosureDataCopy_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return formResult;
    }
}

