/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.perm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriter;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.epm.far.business.common.business.export.ExportUtil;
import kd.epm.far.business.common.business.export.strategy.IExport;
import kd.epm.far.common.common.util.QFBuilder;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class FIDMAuthExportStrategy
implements IExport {
    private static final String ID = "id";
    private final String exportPrefix = ResManager.loadKDString((String)"\u5f15\u51fa\u6570\u636e_", (String)"ExportExecute_0", (String)"epm-far-business", (Object[])new Object[0]);

    @Override
    public String export(String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        String selectFiled;
        DynamicObject[] authDatas;
        Long modelId = (Long)outputParams.get("modelId");
        DynamicObject dy = QueryServiceHelper.queryOne((String)"fidm_model", (String)"number", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)modelId)});
        QFBuilder filter = new QFBuilder("fidmmodel", "=", (Object)modelId);
        filter.add(new QFilter("authclass.app", "=", (Object)String.valueOf(outputParams.get("app"))));
        Object idList = outputParams.get("idList");
        if (Objects.nonNull(idList)) {
            filter.add(ID, "in", idList);
        }
        if ((authDatas = BusinessDataServiceHelper.load((String)entityName, (String)(selectFiled = "users,username,usertype,authclass,data_auth"), (QFilter[])filter.toArray(), (String)ID)) == null || authDatas.length == 0) {
            return null;
        }
        LinkedHashMap<String, String> showSteptypeNameMap = new LinkedHashMap<String, String>();
        ArrayList exportMapList = new ArrayList(10);
        for (DynamicObject authData : authDatas) {
            LinkedHashMap<String, Object> authDataMap = new LinkedHashMap<String, Object>();
            authDataMap.put("model_number", dy.get("number"));
            authDataMap.put("users", authData.get("users"));
            authDataMap.put("username", authData.get("username"));
            authDataMap.put("usertype", authData.get("usertype"));
            authDataMap.put("data_auth", authData.get("data_auth"));
            authDataMap.put("auth", authData.get("authclass.number"));
            exportMapList.add(authDataMap);
        }
        SXSSFWorkbook wb = new SXSSFWorkbook(50000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        ExportSheetStyle style = new ExportSheetStyle(wb);
        String json = SerializationUtils.toJsonString(exportMapList);
        JSONArray billArr = JSON.parseArray((String)json);
        int rowIndex = 3;
        String fileName = ExportUtil.genFullFileName(importTemplateId, entityName, this.exportPrefix);
        ExportWriterFormat format = ExportUtil.getAuthExportWriterFormatAndWriteHead(wb, sheet, style, routeAppId, formId, importTemplateId, entityName, showSteptypeNameMap);
        for (int i = 0; i < billArr.size(); ++i) {
            JSONObject bill = billArr.getJSONObject(i);
            ExportWriter.writeData((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)style, (JSONObject)bill, (int)(rowIndex + i + 1), (ExportWriterFormat)format, (boolean)false, (String)fileName, (boolean)false);
        }
        return ExportUtil.writeFile(wb, fileName);
    }

    @Override
    public String export(MainEntityType mainEntityType, String routeAppId, long importTemplateId, String formId, String entityName, Map<String, Object> outputParams) throws IOException {
        return null;
    }
}

