/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.perm;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.ModelStatusEnum;
import kd.epm.far.common.common.util.QFBuilder;
import org.apache.commons.collections.CollectionUtils;

public class FarFunPermissionHelper {
    public static final Map<ApplicationTypeEnum, String> APP2ADMINROLEID = ImmutableMap.of((Object)ApplicationTypeEnum.CM, (Object)"3=NR/T2I93RU", (Object)ApplicationTypeEnum.RPT, (Object)"3ACVTHN6T4DQ", (Object)ApplicationTypeEnum.FAR, (Object)"3ACVQ9=T0JR3", (Object)ApplicationTypeEnum.FIDM, (Object)"3ACV=1/D72Q7", (Object)ApplicationTypeEnum.DI, (Object)"3=NR/T2I93RU");
    private static final String DIM_DM_MODEL = "DIM_DM_MODEL";
    private static final String FIDM_MODEL = "fidm_model";
    private static final String DIM_TYPE = "dimtype";
    private static final String ID = "id";
    private static final String STATUS = "status";
    private static final String REPORT_TYPE = "ReportType";
    private static final String USERLD = "user.id";
    public static boolean ISNEWPLATFORM = false;
    public static String USERFIELD = "user.id";
    private static ThreadLocal<Map<String, Set<Long>>> modelRoleLocal = ThreadLocal.withInitial(HashMap::new);

    public static void addAllRootPermByUser(Long modelId, Long userId, ApplicationTypeEnum app, String permType) {
        ImmutableMap assignInfo = ImmutableMap.of((Object)userId, (Object)Lists.newArrayList((Object[])new Long[]{modelId}));
        FarFunPermissionHelper.adminRoleAssignUserOrg((Map<Long, List<Long>>)assignInfo, app, permType, Boolean.TRUE);
    }

    public static void adminRoleAssignUserOrg(Map<Long, List<Long>> assignInfo, ApplicationTypeEnum app, String permType, boolean ifAdd) {
        PermissionServiceHelper.roleAssignUserOrg((String)APP2ADMINROLEID.get(app), (String)permType, assignInfo, null, (boolean)ifAdd);
        if (ApplicationTypeEnum.CM == app) {
            FarFunPermissionHelper.adminRoleAssignUserOrg(assignInfo, ApplicationTypeEnum.RPT, permType, Boolean.TRUE);
        }
    }

    public static void dmDeletePermByModelId(Long modelId, String apptype) {
        List allColuns = DB.getColumnNames((DBRoute)DBRoute.basedata, (String)"t_perm_userpermdetail");
        String appid = "2IFNVZ0SS0W4";
        if (ApplicationTypeEnum.FAR.getAppnum().equals(apptype)) {
            appid = "2K++OWYYMS5J";
        }
        if (allColuns.contains("fdimid") || allColuns.contains("FDIMID")) {
            String deleteSQL = "delete from t_perm_userpermdetail where fdimid =" + modelId + " and fbizappid = '" + appid + "'";
            DB.execute((DBRoute)DBRoute.basedata, (String)deleteSQL);
        } else {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("org", "=", (Object)modelId));
            qfBuilder.add(new QFilter(DIM_TYPE, "=", (Object)DIM_DM_MODEL).or(new QFilter(DIM_TYPE, "=", (Object)FIDM_MODEL)));
            String selectField = ID;
            DynamicObject userPerm = QueryServiceHelper.queryOne((String)"perm_userperm", (String)selectField, (QFilter[])qfBuilder.toArray());
            if (Objects.isNull(userPerm)) {
                return;
            }
            String permId = userPerm.getString(ID);
            String deleSQL = "delete from t_perm_userpermdetail where fid ='" + permId + "' and fbizappid = '" + appid + "'";
            DB.execute((DBRoute)DBRoute.basedata, (String)deleSQL);
        }
    }

    public static int delDmPermUserRoleByModelId(Long modelId, String bizAppId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)modelId);
        QFilter dimtypeFilter = new QFilter(DIM_TYPE, "=", (Object)FIDM_MODEL);
        QFilter bizFilter = new QFilter("role.bizdomain", "=", (Object)bizAppId);
        QFilter[] qFilters = new QFilter[]{orgFilter, dimtypeFilter, bizFilter};
        return DeleteServiceHelper.delete((String)"perm_userrole", (QFilter[])qFilters);
    }

    public static int delDmPermUserByModelId(Long modelId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)modelId);
        QFilter dimtypeFilter = new QFilter(DIM_TYPE, "=", (Object)DIM_DM_MODEL).or(DIM_TYPE, "=", (Object)FIDM_MODEL);
        QFilter[] qFilters = new QFilter[]{orgFilter, dimtypeFilter};
        return DeleteServiceHelper.delete((String)"perm_userperm", (QFilter[])qFilters);
    }

    public static Set<Long> getAllHasPermModel(QFilter[] filters) {
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"perm_userperm", (String)"org", (QFilter[])filters);
        HashSet sets = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
        if (Objects.nonNull(dynamicObjectCollection) && dynamicObjectCollection.size() > 0) {
            for (DynamicObject dy : dynamicObjectCollection) {
                Long orgId = dy.getLong("org");
                sets.add(orgId);
            }
        }
        return sets;
    }

    private static QFilter[] getEntityQF(String entity, ApplicationTypeEnum application, String[] permType) {
        entity = FarFunPermissionHelper.getConnectPermEntity(entity);
        QFilter filter = new QFilter(USERFIELD, "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter filter2 = new QFilter("entryentity.entitytype", "=", (Object)entity);
        QFilter permTypeFilter = new QFilter(DIM_TYPE, "in", (Object)permType);
        Set<Long> set = FarFunPermissionHelper.getAllHasPermModel(new QFilter[]{filter, filter2, permTypeFilter});
        QFilter filter1 = new QFilter(ID, "in", set);
        return new QFilter[]{filter1};
    }

    private static QFilter getEntityQF(String entity) {
        entity = FarFunPermissionHelper.getConnectPermEntity(entity);
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        QFilter filter = new QFilter(USERFIELD, "=", (Object)currentUserId);
        QFilter filter2 = new QFilter("entryentity.entitytype", "=", (Object)entity);
        if ("bcm_card_myvalue".equals(entity) || "report_card_myvalue".equals(entity) || "report_card_financialdata".equals(entity)) {
            filter = new QFilter(USERLD, "=", (Object)currentUserId);
            filter2 = new QFilter("1", "=", (Object)1);
        }
        Set<Long> set = FarFunPermissionHelper.getAllHasPermModel(new QFilter[]{filter, filter2});
        QFilter filter1 = new QFilter(ID, "in", set);
        filter1.and(STATUS, "=", (Object)ModelStatusEnum.AUDIT.getValue());
        return filter1;
    }

    @Deprecated
    public static Set<Long> getEffectiveByPermModel(String entity, ApplicationTypeEnum application) {
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)FIDM_MODEL, (String)ID, (QFilter[])FarFunPermissionHelper.getEntityQF(entity, application, new String[]{FIDM_MODEL, DIM_DM_MODEL}));
        return dynamicObjectCollection.stream().map(e -> e.getLong(ID)).collect(Collectors.toSet());
    }

    @Deprecated
    public static Set<Long> getRoleModel(long userId, String perType, ApplicationTypeEnum application, String entityNum, String permItemId) {
        return FarFunPermissionHelper.getFuncAuthModel(userId, perType, application, entityNum, permItemId, Boolean.TRUE, Boolean.FALSE);
    }

    @Deprecated
    public static Set<Long> getRoleModel(long UserID, String perType, ApplicationTypeEnum application) {
        return FarFunPermissionHelper.getRoleModel(UserID, perType, application, null, null);
    }

    public static Set<Long> getFuncAuthModel(long userId, String perType, ApplicationTypeEnum application, String entityNum, String permItemId, boolean isOldDiffFilter, boolean isRPTAndIncludeCMModel) {
        if (Objects.nonNull(entityNum)) {
            entityNum = FarFunPermissionHelper.getConnectPermEntity(entityNum);
        }
        QFBuilder qcf = new QFBuilder(STATUS, "=", (Object)ModelStatusEnum.AUDIT.getValue());
        HasPermDimObjResult perResult = Objects.isNull(entityNum) || Objects.equals("bcm_card_myvalue", entityNum) || Objects.equals("report_card_myvalue", entityNum) || Objects.equals("report_card_financialdata", entityNum) ? PermissionServiceHelper.getUserHasPermDimObjs((long)userId, (String)perType) : PermissionServiceHelper.getHasPermDimObjs((long)userId, (String)AppMetadataCache.getAppInfo((String)application.getAppnum()).getId(), (String)entityNum, (String)permItemId);
        boolean isOldVer = isOldDiffFilter && perResult.hasAllDimObjPerm() || !isOldDiffFilter && !isRPTAndIncludeCMModel;
        StringBuilder append = new StringBuilder().append(userId).append(perType).append(application.getName());
        if (!isOldVer) {
            append.append("#getFuncAuthModel");
        }
        String key = append.toString();
        Map<String, Set<Long>> map = modelRoleLocal.get();
        if (map.containsKey(key)) {
            return map.get(key);
        }
        if (!perResult.hasAllDimObjPerm()) {
            qcf.and(new QFilter(ID, "in", (Object)perResult.getHasPermDimObjs()));
        }
        String entity = "bcm_model";
        switch (application) {
            case RPT: {
                qcf.and(isOldVer ? FarFunPermissionHelper.getRptAdminModelQFilter() : FarFunPermissionHelper.getAllRptAdminModelQFilter());
                break;
            }
            case FIDM: {
                entity = FIDM_MODEL;
                break;
            }
            case DI: {
                qcf.and(new QFilter("reporttype", "=", (Object)ApplicationTypeEnum.CM.index));
                break;
            }
            default: {
                qcf.and(new QFilter(REPORT_TYPE, "=", (Object)application.index));
            }
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entity, (String)ID, (QFilter[])qcf.toArray());
        Set<Long> publicModelIds = CollectionUtils.isEmpty((Collection)dynamicObjectCollection) ? Collections.EMPTY_SET : dynamicObjectCollection.stream().map(t -> t.getLong(ID)).collect(Collectors.toSet());
        map.put(key, publicModelIds);
        return publicModelIds;
    }

    public static QFilter getRptAdminModelQFilter() {
        return new QFilter(REPORT_TYPE, "in", Arrays.asList(ApplicationTypeEnum.RPT.getOIndex(), ApplicationTypeEnum.PUB.getOIndex()));
    }

    public static QFilter getAllRptAdminModelQFilter() {
        return new QFilter(REPORT_TYPE, "in", Arrays.asList(ApplicationTypeEnum.RPT.getOIndex(), ApplicationTypeEnum.PUB.getOIndex(), ApplicationTypeEnum.CM.getOIndex()));
    }

    private static String getConnectPermEntity(String entity) {
        String newentity = entity;
        switch (entity) {
            case "bcm_datacollectlog_list": {
                newentity = "bcm_datacollection";
                break;
            }
            case "bcm_tpl_treelist": {
                newentity = "bcm_cslscheme";
                break;
            }
            case "bcm_unionperm": {
                newentity = "bcm_auth";
                break;
            }
        }
        return newentity;
    }

    public static void addFidmAdminPermission(Long modelId, Long userId) {
        FarFunPermissionHelper.addAllRootPermByUser(modelId, userId, ApplicationTypeEnum.FIDM, FIDM_MODEL);
    }

    public static void addFarAdminPermission(Long modelId, Long userId) {
        FarFunPermissionHelper.addAllRootPermByUser(modelId, userId, ApplicationTypeEnum.FAR, FIDM_MODEL);
    }

    public static String getAppID(String apptype) {
        String appid = "2IFNVZ0SS0W4";
        if (ApplicationTypeEnum.FAR.getAppnum().equals(apptype)) {
            appid = "2K++OWYYMS5J";
        }
        return appid;
    }

    static {
        StringBuilder existSql = new StringBuilder();
        existSql.append("SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 't_perm_userpermdetail' AND KSQL_COL_NAME IN ('fuserid')");
        ISNEWPLATFORM = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)existSql.toString(), (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
        if (ISNEWPLATFORM) {
            USERFIELD = "entryentity.userfield";
        }
    }
}

