/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.perm;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.perm.dto.FunctionPermItem;
import kd.epm.far.business.common.perm.dto.PermissionClass;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class PermissionHelper {
    public static List<PermissionClass> getPermissionClasses(long modelId, String number, List<Long> ids) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("fidmmodel", "=", (Object)modelId));
        qFilters.add(new QFilter("app", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getAppId()));
        if (StringUtils.isNotEmpty((String)number)) {
            qFilters.add(new QFilter("number", "like", (Object)("%" + number + "%")));
        }
        if (ids != null && !ids.isEmpty()) {
            qFilters.add(new QFilter("id", "in", ids));
        }
        DynamicObjectCollection perms = QueryServiceHelper.query((String)"bcm_permissionclass", (String)"id,number,remark,modifier.name,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]));
        Set<Object> hasRightIds = new HashSet();
        boolean adminUserBol = MemberPermHelper.isDiscModelAdmin(modelId, "fidm");
        if (!adminUserBol) {
            hasRightIds = PermClassEntityHelper.getWriteDataPermission(Long.toString(modelId), "fidmmodel", ApplicationTypeEnum.FIDM.getAppnum());
        }
        ArrayList<PermissionClass> list = new ArrayList<PermissionClass>(perms.size());
        for (DynamicObject perm : perms) {
            PermissionClass p = new PermissionClass();
            p.setId(perm.getLong("id"));
            p.setNumber(perm.getString("number"));
            p.setRemark(perm.getString("remark"));
            p.setModifier(perm.getString("modifier.name"));
            p.setModifyTime(perm.getDate("modifytime"));
            if (adminUserBol) {
                p.setHasRight(true);
            } else {
                p.setHasRight(hasRightIds.contains(p.getId()));
            }
            list.add(p);
        }
        return list;
    }

    public static List<FunctionPermItem> getFunctionNoPermissions(long modelId) {
        boolean isAdmin = MemberPermHelper.isDiscModelAdmin(modelId, "fidm");
        if (isAdmin) {
            return new ArrayList<FunctionPermItem>(0);
        }
        ArrayList<FunctionPermItem> hasNoPermItems = new ArrayList<FunctionPermItem>(6);
        PermissionHelper.getFunctionPermItems().forEach(item -> {
            if (!PermissionHelper.checkFunctionPermission(modelId, item.getEntityNumber(), item.getItemNumber())) {
                item.setHasPerm(false);
                hasNoPermItems.add((FunctionPermItem)item);
            }
        });
        return hasNoPermItems;
    }

    public static boolean checkFunctionPermission(long modelId, String entityNumber, String permItem) {
        if (modelId == 0L || StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)permItem)) {
            return false;
        }
        boolean isModelManager = MemberPermHelper.isDiscModelAdmin(modelId, ApplicationTypeEnum.FIDM.getAppnum());
        if (isModelManager) {
            return true;
        }
        String appId = ApplicationTypeEnum.FIDM.getAppnum();
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.checkPermission((long)userId, (String)"fidm_model", (long)modelId, (String)appId, (String)entityNumber, (String)permItem) == 1;
    }

    private static List<FunctionPermItem> getFunctionPermItems() {
        ArrayList<FunctionPermItem> items = new ArrayList<FunctionPermItem>(6);
        items.add(new FunctionPermItem("fidm_templatelist", "47150e89000000ac"));
        items.add(new FunctionPermItem("fidm_templatelist", "47156aff000000ac"));
        items.add(new FunctionPermItem("fidm_templatelist", "1=DS4UJ=H4CX"));
        items.add(new FunctionPermItem("fidm_templatelist", "4715e1f1000000ac"));
        items.add(new FunctionPermItem("fidm_templatelist", "4730fc9f000020ae"));
        items.add(new FunctionPermItem("fidm_templatelist", "4730fc5d000000ac"));
        items.add(new FunctionPermItem("fidm_templatelist", "47160c2b000000ac"));
        items.add(new FunctionPermItem("fidm_templatelist", "2N37YASZMO0K"));
        items.add(new FunctionPermItem("fidm_templatelist", "3M0ELI1UPWOB"));
        items.add(new FunctionPermItem("fidm_templatelist", "3M0ENNT7J+93"));
        items.add(new FunctionPermItem("fidm_templatelist", "3M0EPBLB+D/Z"));
        items.add(new FunctionPermItem("fidm_templatelist", "3M0EQH+F0XQ5"));
        items.add(new FunctionPermItem("fidm_myreportlist", "47150e89000000ac"));
        items.add(new FunctionPermItem("fidm_myreportlist", "2R3S=C4SM5IS"));
        items.add(new FunctionPermItem("fidm_myreportlist", "0AQ3YJ2LET+U"));
        items.add(new FunctionPermItem("fidm_myreportlist", "4715e1f1000000ac"));
        items.add(new FunctionPermItem("fidm_myreportlist", "804f6478000000ac"));
        items.add(new FunctionPermItem("fidm_myreportlist", "4730fc9f000000ae"));
        items.add(new FunctionPermItem("fidm_myreportlist", "47162f66000000ac"));
        items.add(new FunctionPermItem("fidm_myreportlist", "47165e8e000000ac"));
        items.add(new FunctionPermItem("fidm_myreportlist", "/=N=NAA4+3V2"));
        items.add(new FunctionPermItem("fidm_myreportlist", "/=N=Y++CAOOZ"));
        items.add(new FunctionPermItem("fidm_myreportlist", "2N37YASZMO0K"));
        items.add(new FunctionPermItem("fidm_myreportlist", "2N39FB04/VF3"));
        items.add(new FunctionPermItem("fidm_myreportlist", "2R609B5J9YU/"));
        items.add(new FunctionPermItem("fidm_myreportlist", "2N6Q4FDWO2UB"));
        items.add(new FunctionPermItem("fidm_myreportlist", "2N6Q7NTRD19R"));
        items.add(new FunctionPermItem("fidm_myreportlist", "3M0J0S6/CURB"));
        items.add(new FunctionPermItem("fidm_webdesign", "0=KX5+QVF5+R"));
        items.add(new FunctionPermItem("fidm_webdesign", "804f6478000000ac"));
        items.add(new FunctionPermItem("fidm_webdesign", "4730fc9f000000ae"));
        items.add(new FunctionPermItem("fidm_webdesign", "4730fc5d000000ac"));
        items.add(new FunctionPermItem("fidm_webdesign", "47160c2b000000ac"));
        items.add(new FunctionPermItem("fidm_webdesign", "3M0=JW7HW5IO"));
        items.add(new FunctionPermItem("fidm_webdesign", "1=DS4UJ=H4CX"));
        items.add(new FunctionPermItem("fidm_webdesign", "41N30J3IQ7V8"));
        items.add(new FunctionPermItem("fidm_webdesign", "41N48C4H=C1P"));
        items.add(new FunctionPermItem("fidm_webdesign", "41N3/8L6WDHJ"));
        items.add(new FunctionPermItem("fidm_disc_variable_list", "47150e89000000ac"));
        items.add(new FunctionPermItem("fidm_disc_variable_list", "47156aff000000ac"));
        items.add(new FunctionPermItem("fidm_disc_variable_list", "4715a0df000000ac"));
        items.add(new FunctionPermItem("fidm_disc_variable_list", "4715e1f1000000ac"));
        items.add(new FunctionPermItem("fidm_disc_variable_list", "4730fc9f000020ae"));
        items.add(new FunctionPermItem("fidm_modulerepositorylist", "47150e89000000ac"));
        items.add(new FunctionPermItem("fidm_modulerepositorylist", "0=KX5+QVF5+R"));
        items.add(new FunctionPermItem("fidm_modulerepositorylist", "4715e1f1000000ac"));
        items.add(new FunctionPermItem("fidm_modulerepositorylist", "4730fc5d000000ac"));
        items.add(new FunctionPermItem("fidm_modulerepositorylist", "47160c2b000000ac"));
        items.add(new FunctionPermItem("fidm_modulerepositorylist", "1C8UBNOYX9F0"));
        items.add(new FunctionPermItem("fidm_modulerepositorylist", "3K95+NA+3M23"));
        items.add(new FunctionPermItem("fidm_modulerepositorylist", "3K9529+5A2+3"));
        items.add(new FunctionPermItem("fidm_modulerepositorylist", "3K954=3YIKHR"));
        items.add(new FunctionPermItem("fidm_modulerepositorylist", "3KERC26X4SE6"));
        items.add(new FunctionPermItem("fidm_dataset_list", "47150e89000000ac"));
        items.add(new FunctionPermItem("fidm_dataset_list", "47156aff000000ac"));
        items.add(new FunctionPermItem("fidm_dataset_list", "4715e1f1000000ac"));
        items.add(new FunctionPermItem("fidm_dataset_list", "4730fc5d000000ac"));
        items.add(new FunctionPermItem("fidm_dataset_list", "47160c2b000000ac"));
        items.add(new FunctionPermItem("fidm_dataset_list", "4730fc9f000020ae"));
        items.add(new FunctionPermItem("fidm_dataset_list", "1C8UBNOYX9F0"));
        items.add(new FunctionPermItem("fidm_dataset_list", "4715a0df000000ac"));
        items.add(new FunctionPermItem("fidm_chapterepositorylist", "47150e89000000ac"));
        items.add(new FunctionPermItem("fidm_chapterepositorylist", "4715e1f1000000ac"));
        items.add(new FunctionPermItem("fidm_chapterepositorylist", "4730fc5d000000ac"));
        items.add(new FunctionPermItem("fidm_chapterepositorylist", "47160c2b000000ac"));
        items.add(new FunctionPermItem("fidm_chapterepositorylist", "1C8UBNOYX9F0"));
        items.add(new FunctionPermItem("fidm_chapterepositorylist", "0=KX5+QVF5+R"));
        items.add(new FunctionPermItem("fidm_chapterepositorylist", "3M0K+A=8R1F/"));
        items.add(new FunctionPermItem("fidm_chapterepositorylist", "3M0K/DLCIZBJ"));
        items.add(new FunctionPermItem("fidm_chapterepositorylist", "3M0K11LII2ZM"));
        items.add(new FunctionPermItem("fidm_chapterepositorylist", "3M0K2ABKZLT9"));
        return items;
    }

    public static QFilter getReadAndWritePermFilter(long modelId, String entityName) {
        ArrayListMultimap<String, Long> permClassMap;
        List ids;
        boolean isModelManager = MemberPermHelper.isDiscModelAdmin(modelId, ApplicationTypeEnum.FIDM.getAppnum());
        if (!isModelManager && !(ids = (permClassMap = PermClassEntityHelper.getFIDMPermissionMap(entityName, modelId, RequestContext.get().getCurrUserId())).get((Object)DataTypeEnum.NO.getIndex())).isEmpty()) {
            return new QFilter("id", "not in", (Object)ids);
        }
        return new QFilter("1", "=", (Object)1);
    }

    public static QFilter getReadAndWritePermFilterWithAppNum(long modelId, String entityName, String appNum) {
        ArrayListMultimap<String, Long> permClassMap;
        List ids;
        Boolean isModelManager = MemberPermHelper.isDiscModelAdmin(modelId, appNum);
        if (!isModelManager.booleanValue() && !(ids = (permClassMap = PermClassEntityHelper.getDiscPermissionMap(entityName, modelId, RequestContext.get().getCurrUserId(), appNum)).get((Object)DataTypeEnum.NO.getIndex())).isEmpty()) {
            return new QFilter("id", "not in", (Object)ids);
        }
        return new QFilter("1", "=", (Object)1);
    }

    public static QFilter getWritePermFilter(long modelId, String entityName) {
        boolean isModelManager = MemberPermHelper.isDiscModelAdmin(modelId, ApplicationTypeEnum.FIDM.getAppnum());
        if (!isModelManager) {
            List<Long> ids = PermissionHelper.getWritePermData(modelId, entityName);
            if (ids.isEmpty()) {
                return new QFilter("1", "=", (Object)"2");
            }
            return new QFilter("id", "in", ids);
        }
        return new QFilter("1", "=", (Object)1);
    }

    public static List<Long> getWritePermData(long modelId, String entityName) {
        QFBuilder range;
        DynamicObjectCollection permclassCollection;
        ArrayListMultimap<String, Long> permClassMap = PermClassEntityHelper.getFIDMPermissionMap(entityName, modelId, RequestContext.get().getCurrUserId());
        List ids = permClassMap.get((Object)DataTypeEnum.WRITEIN.getIndex());
        String model = "model";
        if (entityName.equals("fidm_dataset")) {
            model = "discmodel";
        }
        if ((permclassCollection = QueryServiceHelper.query((String)"bcm_permclass_entity", (String)"entityid", (QFilter[])(range = new QFBuilder("fidmmodel", "=", (Object)modelId).and("entityname", "=", (Object)entityName).and("permclass", ">", (Object)0)).toArray())).isEmpty()) {
            range = new QFBuilder(model, "=", (Object)modelId);
        } else {
            List permEntityIds = permclassCollection.stream().map(x -> x.getLong("entityid")).collect(Collectors.toList());
            range = new QFBuilder(model, "=", (Object)modelId).and("id", "not in", permEntityIds);
        }
        DynamicObjectCollection defaultIds = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])range.toArray());
        for (DynamicObject id : defaultIds) {
            if (ids.contains(id.getLong("id"))) continue;
            ids.add(id.getLong("id"));
        }
        return ids;
    }

    public static boolean hasWritePerm(long modelId, String entityName, long id) {
        ArrayListMultimap<String, Long> permClassMap = PermClassEntityHelper.getFIDMPermissionMap(entityName, modelId, RequestContext.get().getCurrUserId());
        return !permClassMap.get((Object)DataTypeEnum.NO.getIndex()).contains(id) && !permClassMap.get((Object)DataTypeEnum.READ.getIndex()).contains(id);
    }

    public static String getPermClassNumber(long modelId, long permClassId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("fidmmodel", "=", (Object)modelId));
        qFilters.add(new QFilter("app", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getAppId()));
        qFilters.add(new QFilter("id", "=", (Object)permClassId));
        DynamicObject permclass = QueryServiceHelper.queryOne((String)"bcm_permissionclass", (String)"number", (QFilter[])qFilters.toArray(new QFilter[0]));
        return permclass != null ? permclass.getString("number") : StringUtils.getEmpty();
    }

    public static void savePermClassEntity(long modelId, long entityId, String entityName, long permClassId, OperationStatus status) {
        DynamicObject dyn = PermClassEntityHelper.getDiscPermissionClassEntity(entityName, entityId, modelId, "fidmmodel", ApplicationTypeEnum.FIDM.getAppnum());
        if (permClassId > 0L) {
            if (status != OperationStatus.EDIT || dyn == null) {
                dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                dyn.set("entityname", (Object)entityName);
                dyn.set("fidmmodel", (Object)modelId);
                dyn.set("entityid", (Object)entityId);
            }
            dyn.set("permclass", (Object)permClassId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        } else if (dyn != null) {
            DeleteServiceHelper.delete((IDataEntityType)dyn.getDynamicObjectType(), (Object[])new Object[]{dyn.getPkValue()});
        }
    }

    public static List<Long> getOnlyReadIds(String entityName, Long modelId, String userId, String appType) {
        ArrayList<Long> readOnlyPerms = new ArrayList<Long>();
        readOnlyPerms.addAll(PermClassEntityHelper.getDiscPermissionMap(entityName, modelId, LongUtil.toLong((Object)userId), appType).get((Object)"2"));
        return readOnlyPerms;
    }
}

