/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.perm.permclass;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.MultiLangEnumBridge;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.enums.Permission.UserTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.MD5Utils;
import kd.epm.far.common.common.util.QFBuilder;

public class PermClassEntityHelper {
    public static final String PERM_CLASS = "permclass";
    public static final String FIDMMODL = "fidmmodel";

    public static void setPermClassFilter(BasedataEdit basedataEdit, Object modelId) {
        PermClassEntityHelper.setPermClassFilter(basedataEdit, modelId, "model", "");
    }

    public static void setPermClassFilter(BasedataEdit basedataEdit, Object modelId, String modelSign, String appType) {
        basedataEdit.addBeforeF7SelectListener(v -> {
            boolean adminUserBol;
            QFilter qFilter = new QFilter(modelSign, "=", (Object)LongUtil.toLong((Object)modelId));
            if (StringUtils.equals((CharSequence)FIDMMODL, (CharSequence)modelSign)) {
                qFilter.and(new QFilter("app", "=", (Object)appType));
                adminUserBol = MemberPermHelper.isDiscModelAdmin(LongUtil.toLong((Object)modelId), appType);
            } else {
                adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), modelId.toString());
            }
            if (!adminUserBol) {
                Set<Long> ids = PermClassEntityHelper.getWriteDataPermission(modelId.toString(), modelSign, appType);
                if (CollectionUtils.isEmpty(ids)) {
                    qFilter.and("id", "=", (Object)0);
                } else {
                    qFilter.and("id", "in", ids);
                }
            }
            v.getCustomQFilters().add(qFilter);
        });
    }

    public static void loadPermClass(IDataModel dataModel, Object modelId) {
        DynamicObject dyn;
        if (dataModel.getDataEntity().getPkValue() != null && (dyn = PermClassEntityHelper.getPermissionClassEntity(dataModel, modelId)) != null) {
            dataModel.setValue(PERM_CLASS, dyn.get("permclass.id"));
        }
    }

    public static void savePermClass(String entityName, Long entityId, Long modelId, Long permClass) {
        if (StringUtils.isEmpty((CharSequence)entityName) || entityId == null || entityId <= 0L || permClass == null || permClass <= 0L) {
            return;
        }
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
        dyn.set("entityname", (Object)entityName);
        dyn.set(FIDMMODL, (Object)modelId);
        dyn.set("entityid", (Object)entityId);
        dyn.set(PERM_CLASS, (Object)permClass);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
    }

    public static void savePermClass(IDataModel dataModel, String entityName, Long entityId, Object modelId, OperationStatus status, String modelSign) {
        PermClassEntityHelper.saveDiscPermClass(dataModel, entityName, entityId, modelId, status, modelSign, ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static void saveDiscPermClass(IDataModel dataModel, String entityName, Long entityId, Object modelId, OperationStatus status, String modelSign, String appType) {
        DynamicObject dyn = PermClassEntityHelper.getDiscPermissionClassEntity(entityName, entityId, modelId, modelSign, appType);
        Object perm = dataModel.getValue(PERM_CLASS);
        if (perm != null && !"0".equals(perm.toString())) {
            if (status != OperationStatus.EDIT || dyn == null) {
                dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
                dyn.set("entityname", (Object)entityName);
                dyn.set(modelSign, modelId);
                dyn.set("entityid", (Object)entityId);
            }
            dyn.set(PERM_CLASS, perm);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        } else if (dyn != null) {
            DeleteServiceHelper.delete((IDataEntityType)dyn.getDynamicObjectType(), (Object[])new Object[]{dyn.getPkValue()});
        }
    }

    public static DynamicObject getPermissionClassEntity(IDataModel dataModel, Object modelId) {
        QFBuilder range = new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId)).add("entityid", "=", dataModel.getDataEntity().getPkValue()).and("entityname", "=", (Object)dataModel.getDataEntityType().getName());
        return BusinessDataServiceHelper.loadSingle((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass", (QFilter[])range.toArray());
    }

    public static DynamicObject getDiscPermissionClassEntity(String name, Long entityId, Object modelId, String modelSign, String appType) {
        QFBuilder range = new QFBuilder(modelSign, "=", modelId).add("entityid", "=", (Object)entityId).and("entityname", "=", (Object)name);
        if (!StringUtils.isEmpty((CharSequence)appType)) {
            ArrayList<String> appField = new ArrayList<String>(2);
            appField.add(appType);
            if (!ApplicationTypeEnum.FAR.getAppnum().equals(appType)) {
                appField.add("bcm");
            }
            range.add(new QFilter("permclass.app", "in", appField));
        }
        return BusinessDataServiceHelper.loadSingle((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass", (QFilter[])range.toArray());
    }

    public static void saveDiscPermClass(DynamicObject dyn, String modelSign, String appType) {
        DynamicObject entity = PermClassEntityHelper.getDiscPermissionClassEntity(dyn, modelSign, appType);
        if (dyn.get(PERM_CLASS) == null) {
            if (entity != null) {
                DeleteServiceHelper.delete((IDataEntityType)entity.getDynamicObjectType(), (Object[])new Object[]{entity.getPkValue()});
            }
            return;
        }
        if (entity == null) {
            entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
            entity.set("entityname", (Object)dyn.getDataEntityType().getName());
            if (Objects.nonNull(dyn.get("model")) && dyn.get("model") instanceof Long) {
                entity.set(modelSign, (Object)dyn.getLong("model"));
            } else {
                entity.set(modelSign, (Object)dyn.getLong("model.id"));
            }
            entity.set("entityid", (Object)dyn.getLong("id"));
        }
        entity.set(PERM_CLASS, dyn.get(PERM_CLASS));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
    }

    public static void savePermClass(DynamicObject dyn, String modelSign) {
        PermClassEntityHelper.saveDiscPermClass(dyn, modelSign, ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static Map<Object, DynamicObject> getPermissionClass(Long modelId, String modelSign) {
        QFBuilder range = new QFBuilder(modelSign, "=", (Object)modelId);
        String fields = "id,number,modifier,modifytime,remark";
        return BusinessDataServiceHelper.loadFromCache((String)"bcm_permissionclass", (String)fields, (QFilter[])range.toArray());
    }

    public static Map<Object, DynamicObject> getPermissionClass(Long modelId) {
        return PermClassEntityHelper.getPermissionClass(modelId, "model.id");
    }

    public static DynamicObject[] getPermissionClassByLoad(Long modelId, String modelSign) {
        QFBuilder range = new QFBuilder(modelSign, "=", (Object)modelId);
        String fields = "id,number,modifier,modifytime,remark";
        return BusinessDataServiceHelper.load((String)"bcm_permissionclass", (String)fields, (QFilter[])range.toArray());
    }

    public static DynamicObject getDiscPermissionClassEntity(DynamicObject dyn, String modelSign, String appType) {
        Object model = dyn.get("model");
        if (model instanceof DynamicObject) {
            model = dyn.getDynamicObject("model").getPkValue();
        }
        QFBuilder range = new QFBuilder(modelSign, "=", model);
        range.add("entityname", "=", (Object)dyn.getDataEntityType().getName());
        range.add("entityid", "=", dyn.getPkValue());
        if (!StringUtils.isEmpty((CharSequence)appType)) {
            ArrayList<String> appField = new ArrayList<String>(2);
            appField.add(appType);
            if (!ApplicationTypeEnum.FAR.getAppnum().equals(appType)) {
                appField.add("bcm");
            }
            range.add("permclass.app", "in", appField);
        }
        return BusinessDataServiceHelper.loadSingle((String)"bcm_permclass_entity", (String)"permclass.id,entityname,permclass", (QFilter[])range.toArray());
    }

    public static Set<Long> getWriteDataPermission(String modelId, String modelSign, String appType) {
        String userId = RequestContext.get().getUserId();
        HashSet<String> users = new HashSet<String>();
        QFilter qf = new QFilter("user", "=", (Object)LongUtil.toLong((Object)userId));
        DynamicObjectCollection groupData = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"usergroup.id", (QFilter[])qf.toArray());
        if (groupData != null && groupData.size() != 0) {
            HashSet<String> temp = new HashSet<String>();
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)groupData.get(0)).getDataEntityType().getProperties().get((Object)"usergroup.id");
            groupData.forEach(g -> temp.add(g.getString(dataEntityProperty)));
            users.addAll(PermClassEntityHelper.getRelGroupIds(temp));
        }
        users.add(userId);
        String selectFields = "authclass.id,authclass.number";
        QFilter filter = new QFilter(modelSign, "=", (Object)Long.valueOf(modelId));
        Set<Long> usersIds = PermClassEntityHelper.changeUsersIds(users);
        filter.and(new QFilter("users", "in", usersIds));
        filter.and(new QFilter("data_auth", "=", (Object)DataTypeEnum.WRITEIN.getIndex()));
        if (!StringUtils.isEmpty((CharSequence)appType)) {
            ArrayList<String> appField = new ArrayList<String>(2);
            appField.add(appType);
            if (!ApplicationTypeEnum.FAR.getAppnum().equals(appType)) {
                appField.add("bcm");
            }
            filter.and(new QFilter("authclass.app", "in", appField));
        }
        filter.or(new QFilter("authclass.number", "=", (Object)"Default").and("model", "=", (Object)Long.valueOf(modelId)));
        DynamicObjectCollection authObjectCollection = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])filter.toArray());
        HashSet<Long> authClassList = new HashSet<Long>(16);
        if (authObjectCollection == null || authObjectCollection.size() == 0) {
            return authClassList;
        }
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)authObjectCollection.get(0)).getDataEntityType().getProperties().get((Object)"authclass.id");
        authObjectCollection.forEach(auth -> authClassList.add(auth.getLong(dataEntityProperty)));
        return authClassList;
    }

    private static Set<Long> changeUsersIds(Set<String> users) {
        HashSet<Long> usersIds = new HashSet<Long>();
        try {
            if (!users.isEmpty()) {
                users.forEach(userId -> usersIds.add(LongUtil.toLong((Object)userId)));
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8f6c\u6362\u5f02\u5e38%s", (String)"PermClassEntityHelper_0", (String)"epm-far-business", (Object[])new Object[0]), e.getMessage()));
        }
        return usersIds;
    }

    public static String getDataPermission(String userid, int userType, String PermissionClassId, String modelId, String modelSign) {
        String selectFields = "data_auth";
        QFilter filter = new QFilter(modelSign, "=", (Object)LongUtil.toLong((Object)modelId));
        filter.and(new QFilter("authclass", "=", (Object)LongUtil.toLong((Object)PermissionClassId)));
        filter.and(new QFilter("users", "=", (Object)LongUtil.toLong((Object)userid)));
        filter.and(new QFilter("usertype", "=", (Object)UserTypeEnum.getUserTypeEnumByIndex((int)userType).getName()));
        DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"bcm_auth_info", (String)selectFields, (QFilter[])filter.toArray());
        if (data != null && "1".equals(data.getString("data_auth"))) {
            return "1";
        }
        String select = "usergroup.id";
        QFilter qf = new QFilter("user", "=", (Object)LongUtil.toLong((Object)userid));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)select, (QFilter[])qf.toArray());
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            if (null != data) {
                return data.getString("data_auth");
            }
            return "1";
        }
        HashSet groups = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)dynamicObjectCollection.get(0)).getDataEntityType().getProperties().get((Object)"usergroup.id");
        dynamicObjectCollection.forEach(d -> groups.add(d.getString(dataEntityProperty)));
        Set<String> groupIds = PermClassEntityHelper.getRelGroupIds(groups);
        Set groupIds2Long = groupIds.stream().map(s -> LongUtil.toLong((Object)s)).collect(Collectors.toSet());
        QFilter qfs = new QFilter(modelSign, "=", (Object)LongUtil.toLong((Object)modelId));
        qfs.and(new QFilter("authclass", "=", (Object)LongUtil.toLong((Object)PermissionClassId)));
        qfs.and(new QFilter("users", "in", groupIds2Long));
        qfs.and(new QFilter("usertype", "=", (Object)UserTypeEnum.getUserTypeEnumByIndex((int)0).getName()));
        DynamicObjectCollection authObjectCollection = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])qfs.toArray());
        if (authObjectCollection == null || authObjectCollection.size() == 0) {
            if (null != data) {
                return data.getString("data_auth");
            }
            return "1";
        }
        if (null == data) {
            return Collections.min(authObjectCollection, Comparator.comparingInt(a -> Integer.parseInt(a.getString("data_auth")))).getString("data_auth");
        }
        int user = data.getInt("data_auth");
        int userGroup = Collections.min(authObjectCollection, Comparator.comparingInt(a -> Integer.parseInt(a.getString("data_auth")))).getInt("data_auth");
        return String.valueOf(Integer.min(user, userGroup));
    }

    public static String getDataPermission(String userid, int userType, String PermissionClassId, String modelId) {
        return PermClassEntityHelper.getDataPermission(userid, userType, PermissionClassId, modelId, "model");
    }

    public static Set<String> getRelGroupIds(Set<String> groupData) {
        HashMap<String, Set<String>> userGroupInhRelation = new HashMap<String, Set<String>>(8);
        DynamicObjectCollection authObjectCollection = QueryServiceHelper.query((String)"perm_usrgrp_inh", (String)"parent.id, children.id", null);
        if (authObjectCollection != null && authObjectCollection.size() > 0) {
            for (DynamicObject object : authObjectCollection) {
                String parent = object.getString("parent.id");
                String child = object.getString("children.id");
                String parentId = parent == null ? "8609760E-EF83-4775-A9FF-CCDEC7C0B689" : parent;
                Set childObjects = userGroupInhRelation.computeIfAbsent(parentId, k -> new HashSet());
                if (!Objects.nonNull(child)) continue;
                childObjects.add(child);
                userGroupInhRelation.put(parentId, childObjects);
            }
        }
        HashSet<String> groupIds = new HashSet<String>(16);
        for (String group : groupData) {
            HashSet<String> oneGroups = new HashSet<String>(16);
            oneGroups.add(group);
            PermClassEntityHelper.getParentsGroups(userGroupInhRelation, group, oneGroups);
            if (oneGroups.size() <= 0) continue;
            groupIds.addAll(oneGroups);
        }
        return groupIds;
    }

    private static void getParentsGroups(HashMap<String, Set<String>> userGroupInhRelation, String id, Set<String> oneGroups) {
        userGroupInhRelation.forEach((k, v) -> {
            if (v.contains(id)) {
                oneGroups.add((String)k);
                PermClassEntityHelper.getParentsGroups(userGroupInhRelation, k, oneGroups);
            }
        });
    }

    public static ArrayListMultimap<String, Long> getPermissionMap(String entityName, String modelId, String userId) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        HashMap map = new HashMap(16);
        String fields = "entityid,permclass.id";
        QFBuilder range = new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelId)).and("entityname", "=", (Object)entityName);
        DynamicObjectCollection permclassCollection = QueryServiceHelper.query((String)"bcm_permclass_entity", (String)fields, (QFilter[])range.toArray());
        if (!CollectionUtils.isEmpty((Collection)permclassCollection)) {
            DataEntityPropertyCollection dataEntityPropertyCollection = ((DynamicObject)permclassCollection.get(0)).getDataEntityType().getProperties();
            IDataEntityProperty permclassEntityProperty = (IDataEntityProperty)dataEntityPropertyCollection.get((Object)"permclass.id");
            IDataEntityProperty entityidEntityProperty = (IDataEntityProperty)dataEntityPropertyCollection.get((Object)"entityid");
            permclassCollection.forEach(object -> {
                long classId = object.getLong(permclassEntityProperty);
                if (map.get(classId) == null) {
                    String perm = PermClassEntityHelper.getDataPermission(userId, 1, String.valueOf(classId), modelId);
                    multimap.put((Object)perm, (Object)object.getLong(entityidEntityProperty));
                    map.put(classId, perm);
                } else {
                    String perm = (String)map.get(classId);
                    multimap.put((Object)perm, (Object)object.getLong(entityidEntityProperty));
                }
            });
        }
        return multimap;
    }

    public static ArrayListMultimap<String, Long> getFIDMPermissionMap(String entityName, Long modelId, Long userId) {
        return PermClassEntityHelper.getDiscPermissionMap(entityName, modelId, userId, ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static ArrayListMultimap<String, Long> getFARPermissionMap(String entityName, Long modelId, Long userId) {
        return PermClassEntityHelper.getDiscPermissionMap(entityName, modelId, userId, ApplicationTypeEnum.FAR.getAppnum());
    }

    public static ArrayListMultimap<String, Long> getDiscPermissionMap(String entityName, Long modelId, Long userId, String appType) {
        String fields;
        DynamicObjectCollection permclassCollection;
        boolean isModelManager = MemberPermHelper.isDiscModelAdmin(modelId, appType);
        ArrayListMultimap multimap = ArrayListMultimap.create();
        HashMap map = new HashMap(16);
        QFBuilder range = new QFBuilder(FIDMMODL, "=", (Object)modelId).and("entityname", "=", (Object)entityName);
        if (!(StringUtils.isEmpty((CharSequence)appType) || StringUtils.equals((CharSequence)"fidm_dataset", (CharSequence)entityName) || StringUtils.equals((CharSequence)"fidm_modulerepository", (CharSequence)entityName))) {
            ArrayList<String> appField = new ArrayList<String>(2);
            appField.add(appType);
            if (!ApplicationTypeEnum.FAR.getAppnum().equals(appType)) {
                appField.add("bcm");
            }
            range.add(new QFilter("permclass.app", "in", appField));
        }
        if (!CollectionUtils.isEmpty((Collection)(permclassCollection = QueryServiceHelper.query((String)"bcm_permclass_entity", (String)(fields = "entityid,permclass.id"), (QFilter[])range.toArray())))) {
            DataEntityPropertyCollection dataEntityPropertyCollection = ((DynamicObject)permclassCollection.get(0)).getDataEntityType().getProperties();
            IDataEntityProperty permclassEntityProperty = (IDataEntityProperty)dataEntityPropertyCollection.get((Object)"permclass.id");
            IDataEntityProperty entityidEntityProperty = (IDataEntityProperty)dataEntityPropertyCollection.get((Object)"entityid");
            permclassCollection.forEach(object -> {
                long classId = object.getLong(permclassEntityProperty);
                if (classId == 0L) {
                    map.put(classId, "3");
                }
                if (map.get(classId) == null) {
                    String perm = "3";
                    if (!isModelManager) {
                        perm = PermClassEntityHelper.getDataPermission(String.valueOf(userId), 1, String.valueOf(classId), String.valueOf(modelId), FIDMMODL);
                    }
                    multimap.put((Object)perm, (Object)object.getLong(entityidEntityProperty));
                    map.put(classId, perm);
                } else {
                    String perm = (String)map.get(classId);
                    multimap.put((Object)perm, (Object)object.getLong(entityidEntityProperty));
                }
            });
        }
        return multimap;
    }

    public static String getSingleFIDMPermission(String entityName, Long entityId, Long modelId, Long userId, String modelsign) {
        return PermClassEntityHelper.getSingleDiscPermission(entityName, entityId, modelId, userId, modelsign, ApplicationTypeEnum.FIDM.getAppnum());
    }

    public static String getSingleDiscPermission(String entityName, Long entityId, Long modelId, Long userId, String modelsign, String appType) {
        boolean isModelManager = MemberPermHelper.isDiscModelAdmin(modelId, appType);
        QFBuilder range = new QFBuilder(modelsign, "=", (Object)LongUtil.toLong((Object)modelId)).and("entityname", "=", (Object)entityName).add("entityid", "=", (Object)entityId);
        if (!StringUtils.isEmpty((CharSequence)appType)) {
            ArrayList<String> appField = new ArrayList<String>(2);
            appField.add(appType);
            if (!ApplicationTypeEnum.FAR.getAppnum().equals(appType)) {
                appField.add("bcm");
            }
            range.add(new QFilter("permclass.app", "in", appField));
        }
        String fields = "entityid,permclass.id";
        DynamicObject permclass = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_permclass_entity", (String)fields, (QFilter[])range.toArray());
        long classId = 0L;
        if (permclass != null && !isModelManager) {
            classId = permclass.getLong("permclass.id");
            return PermClassEntityHelper.getDataPermission(String.valueOf(userId), 1, String.valueOf(classId), String.valueOf(modelId), FIDMMODL);
        }
        return "3";
    }

    public static boolean checkDistribute(List<Long> classId, Long modelId, String modelSign) {
        boolean flag = false;
        if (!CollectionUtils.isEmpty(classId)) {
            QFBuilder range = new QFBuilder(modelSign, "=", (Object)modelId);
            range.add("authclass", "in", classId);
            flag = QueryServiceHelper.exists((String)"bcm_auth_info", (QFilter[])range.toArray());
        }
        return flag;
    }

    public static boolean checkIsItReferenced(List<Long> classId, Long modelId, String modelSign) {
        boolean flag = false;
        if (!CollectionUtils.isEmpty(classId)) {
            QFBuilder range = new QFBuilder(modelSign, "=", (Object)modelId);
            range.add(PERM_CLASS, "in", classId);
            flag = QueryServiceHelper.exists((String)"bcm_permclass_entity", (QFilter[])range.toArray());
        }
        return flag;
    }

    public static DynamicObjectCollection queryTotalDimensionPermissionClass(long modelId, String entityName) {
        return (DynamicObjectCollection)ThreadCache.get((Object)(CacheKey.PrefixString + Joiner.on((char)'_').join((Object)modelId, (Object)entityName, new Object[]{"model_entity_perm_class_by_query"})), () -> {
            QFBuilder rangeQf = new QFBuilder("model", "=", (Object)modelId).and("entityname", "=", (Object)entityName);
            return QueryServiceHelper.query((String)"bcm_permclass_entity", (String)"entityid, permclass.id, permclass.number", (QFilter[])rangeQf.toArray());
        });
    }

    public static ArrayListMultimap<String, Long> getPermissionMapBatch(String entityName, String modelId, String userId) {
        DynamicObjectCollection objects = PermClassEntityHelper.queryTotalDimensionPermissionClass(LongUtil.toLong((Object)modelId), entityName);
        if (!CollectionUtils.isEmpty((Collection)objects)) {
            return PermClassEntityHelper.getPermByPermClassList(modelId, userId, (List<DynamicObject>)objects, entityName, "permclass.id");
        }
        return ArrayListMultimap.create();
    }

    private static ArrayListMultimap<String, Long> getPermByPermClassList(String modelId, String userId, List<DynamicObject> permClass, String entityName, String propertyKey) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        if (CollectionUtils.isEmpty(permClass)) {
            return multimap;
        }
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)permClass.get(0).getDataEntityType().getProperties().get((Object)propertyKey);
        List permClassIds = permClass.stream().map(object -> object.getLong(dataEntityProperty)).distinct().collect(Collectors.toList());
        permClassIds.remove(0L);
        if (CollectionUtils.isEmpty(permClassIds)) {
            return multimap;
        }
        String longKey = Joiner.on((char)'_').join((Object)modelId, permClassIds, new Object[]{entityName, "perm_class_db"});
        String key = MD5Utils.stringToMD5((String)longKey);
        return (ArrayListMultimap)ThreadCache.get((Object)(CacheKey.PrefixString + key), () -> PermClassEntityHelper.getPermByPermClassListFromDb(modelId, userId, permClass, permClassIds, (ArrayListMultimap<String, Long>)multimap));
    }

    private static ArrayListMultimap<String, Long> getPermByPermClassListFromDb(String modelId, String userId, List<DynamicObject> permClass, List<Long> permClassIds, ArrayListMultimap<String, Long> multimap) {
        HashMap map = new HashMap(16);
        String selectFields = "data_auth,authclass.id";
        QFilter filter = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        filter.and(new QFilter("authclass", "in", permClassIds));
        filter.and(new QFilter("users", "=", (Object)LongUtil.toLong((Object)userId)));
        filter.and(new QFilter("usertype", "=", (Object)UserTypeEnum.getUserTypeEnumByIndex((int)1).getName()));
        DynamicObjectCollection authInfos = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])filter.toArray());
        Map<Object, Object> authInfoMap = Maps.newHashMapWithExpectedSize((int)authInfos.size());
        if (authInfos != null && authInfos.size() > 0) {
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)authInfos.get(0)).getDataEntityType().getProperties().get((Object)"authclass.id");
            authInfoMap = authInfos.stream().collect(Collectors.groupingBy(e -> e.getLong(dataEntityProperty)));
        }
        String select = "usergroup.id";
        QFilter qf = new QFilter("user", "=", (Object)LongUtil.toLong((Object)userId));
        DynamicObjectCollection groupData = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)select, (QFilter[])qf.toArray());
        HashSet groups = Sets.newHashSetWithExpectedSize((int)groupData.size());
        if (groupData != null && groupData.size() > 0) {
            IDataEntityProperty groupDataProperty = (IDataEntityProperty)((DynamicObject)groupData.get(0)).getDataEntityType().getProperties().get((Object)"usergroup.id");
            groupData.forEach(e -> groups.add(e.getString(groupDataProperty)));
        }
        Set<String> groupIds = PermClassEntityHelper.getRelGroupIds(groups);
        QFilter qfs = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        qfs.and(new QFilter("authclass", "in", permClassIds));
        qfs.and(new QFilter("users", "in", (Object)LongUtil.toLongList(groupIds)));
        qfs.and(new QFilter("usertype", "=", (Object)UserTypeEnum.getUserTypeEnumByIndex((int)0).getName()));
        DynamicObjectCollection groupDataAuth = QueryServiceHelper.query((String)"bcm_auth_info", (String)selectFields, (QFilter[])qfs.toArray());
        Map<Object, Object> groupDataAuthMap = Maps.newHashMapWithExpectedSize((int)groupDataAuth.size());
        if (groupDataAuth != null && groupDataAuth.size() > 0) {
            IDataEntityProperty groupDataAuthProperty = (IDataEntityProperty)((DynamicObject)groupDataAuth.get(0)).getDataEntityType().getProperties().get((Object)"authclass.id");
            groupDataAuthMap = groupDataAuth.stream().collect(Collectors.groupingBy(e -> e.getLong(groupDataAuthProperty)));
        }
        Map<Object, Object> finalAuthInfoMap = authInfoMap;
        HashMap finalGroupDataAuthMap = groupDataAuthMap;
        permClass.forEach(object -> {
            long classId = object.getLong("permclass.id");
            if (map.get(classId) == null) {
                String perm = PermClassEntityHelper.getDataPermissionBatch(userId, 1, classId, modelId, finalAuthInfoMap, groupData, finalGroupDataAuthMap);
                multimap.put((Object)perm, (Object)object.getLong("entityid"));
                map.put(classId, perm);
            } else {
                String perm = (String)map.get(classId);
                multimap.put((Object)perm, (Object)object.getLong("entityid"));
            }
        });
        return multimap;
    }

    public static String getDataPermissionBatch(String userid, int userType, Long PermissionClassId, String modelId, Map<Long, List<DynamicObject>> authInfoMap, DynamicObjectCollection groupData, Map<Long, List<DynamicObject>> groupDataAuthMap) {
        List<DynamicObject> data = authInfoMap.get(PermissionClassId);
        if (data != null && data.size() > 0 && "1".equals(data.get(0).getString("data_auth"))) {
            return "1";
        }
        if (groupData.size() == 0) {
            if (null != data && data.size() > 0) {
                return data.get(0).getString("data_auth");
            }
            return "1";
        }
        List<DynamicObject> groupDataAuth = groupDataAuthMap.get(PermissionClassId);
        if (groupDataAuth == null || groupDataAuth.size() == 0) {
            if (null != data && data.size() > 0) {
                return data.get(0).getString("data_auth");
            }
            return "1";
        }
        if (null == data || data.size() <= 0) {
            return Collections.min(groupDataAuth, Comparator.comparingInt(a -> Integer.parseInt(a.getString("data_auth")))).getString("data_auth");
        }
        int user = data.get(0).getInt("data_auth");
        int userGroup = Collections.min(groupDataAuth, Comparator.comparingInt(a -> Integer.parseInt(a.getString("data_auth")))).getInt("data_auth");
        return String.valueOf(Integer.min(user, userGroup));
    }

    public static enum PermClassEnum {
        READWRITE(new MultiLangEnumBridge("\u8bfb\u5199", "PermClassEntityHelper_1", "epm-far-business"), "3"),
        READONLY(new MultiLangEnumBridge("\u53ea\u8bfb", "PermClassEntityHelper_2", "epm-far-business"), "2"),
        NOPERM(new MultiLangEnumBridge("\u65e0\u6743", "PermClassEntityHelper_3", "epm-far-business"), "1");

        private String name;
        private String value;
        private MultiLangEnumBridge bridge;

        private PermClassEnum(MultiLangEnumBridge bridge, String value) {
            this.bridge = bridge;
            this.value = value;
        }

        public static PermClassEnum getPermTypeByVal(String val) {
            for (PermClassEnum p : PermClassEnum.values()) {
                if (!p.getValue().equals(val)) continue;
                return p;
            }
            throw new RuntimeException("error permEnum value : " + val);
        }

        public String getName() {
            return this.bridge.loadKDString();
        }

        public String getValue() {
            return this.value;
        }
    }
}

