/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.strategy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbDim;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.util.QFBuilder;

public class EBModel
implements IModel {
    Map<String, String> DEFAULT_VALUE = new ImmutableMap.Builder().put((Object)DimTypesEnum.EBVERSION.getShortNumber(), (Object)DimTypesEnum.EBVERSION.getNumber()).put((Object)DimTypesEnum.EBCURRENCY.getShortNumber(), (Object)DimTypesEnum.EBCURRENCY.getNumber()).put((Object)DimTypesEnum.EBAUDITTRIAL.getShortNumber(), (Object)DimTypesEnum.EBAUDITTRIAL.getNumber()).put((Object)DimTypesEnum.EBCHANGETYPE.getShortNumber(), (Object)DimTypesEnum.EBCHANGETYPE.getNumber()).put((Object)DimTypesEnum.EBINTERCOMPANY.getShortNumber(), (Object)DimTypesEnum.EBINTERCOMPANY.getNumber()).put((Object)DimTypesEnum.EBDATATYPE.getShortNumber(), (Object)DimTypesEnum.EBDATATYPE.getNumber()).put((Object)DimTypesEnum.METRIC.getShortNumber(), (Object)DimTypesEnum.METRIC.getNumber()).put((Object)DimTypesEnum.ACCOUNT.getShortNumber(), (Object)DimTypesEnum.ACCOUNT.getNumber()).build();

    @Override
    public String getDimDefaultValue(String shortNumber) {
        return this.DEFAULT_VALUE.getOrDefault(shortNumber, shortNumber);
    }

    @Override
    public boolean isAdmin(Long modelId) {
        Set<Long> limitedModelListByUser = MemberPermHelper.getLimitedModelListByUser(ApplicationTypeEnum.BGMD, false);
        return limitedModelListByUser.contains(modelId);
    }

    @Override
    public boolean isUser(Long modelId) {
        List<DynamicObject> limitedModelListByUser = this.getUseModels();
        Set set = limitedModelListByUser.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        return set.contains(modelId);
    }

    @Override
    public Map<String, String> getDimensionNumber2nameMap(Long modelId, String dataSetNumber) {
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,name,number,shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
        if (Objects.isNull(model)) {
            return Collections.emptyMap();
        }
        List<EbDim> shownumber = EbServiceHelper.getDim(model.getString("shownumber"), dataSetNumber);
        return shownumber.stream().collect(Collectors.toMap(EbDim::getShortNumber, t -> t.getNumber() + ";" + t.getName() + ";" + t.getId()));
    }

    @Override
    public List<DynamicObject> getAdminModels() {
        QFilter qf = MemberPermHelper.getModelPermFilter("id", "epm_modelperm", ApplicationTypeEnum.BGMD);
        return QueryServiceHelper.query((String)"epm_model", (String)"id,name,number,shownumber", (QFilter[])new QFilter[]{qf});
    }

    @Override
    public List<DynamicObject> getUseModels() {
        HasPermDimObjResult perResult = PermissionServiceHelper.getUserHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"epm_model");
        QFBuilder qfBuilder = new QFBuilder();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        if (perResult == null) {
            return result;
        }
        if (!perResult.hasAllDimObjPerm()) {
            qfBuilder.and("id", "in", (Object)perResult.getHasPermDimObjs());
        }
        result = QueryServiceHelper.query((String)"epm_model", (String)"id,name,number,shownumber", (QFilter[])qfBuilder.toArray());
        return result;
    }

    @Override
    public DynamicObject getModel(Long modelId) {
        return this.getModel("epm_model", new QFilter[]{new QFilter("id", "=", (Object)modelId)});
    }

    @Override
    public Long getDimId(Long modelId, String number) {
        return this.getDimId(modelId, "epm_dimension", number);
    }
}

