/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.strategy;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.strategy.CMModel;
import kd.epm.far.business.common.strategy.EBModel;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.RPTModel;

public class ModelStrategy {
    public static IModel getStrategy(DisModelTypeEnum typeEnum) {
        switch (typeEnum) {
            case CM: {
                return new CMModel();
            }
            case RPT: {
                return new RPTModel();
            }
            case EB: {
                return new EBModel();
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u3002", (String)"FarModelStrategy_0", (String)"epm-far-business", (Object[])new Object[0]));
    }

    public static void checkUseModels(Long datasetId, String type) {
        DynamicObject fidmDataset;
        if (StringUtils.isBlank((CharSequence)type) && !Objects.isNull(fidmDataset = QueryServiceHelper.queryOne((String)"fidm_dataset", (String)"id,number,type", (QFilter[])new QFilter("id", "=", (Object)datasetId).toArray()))) {
            type = fidmDataset.getString("type");
        }
        DynamicObject[] datasets = null;
        if ("1".equals(type) || "2".equals(type)) {
            datasets = BusinessDataServiceHelper.load((String)"fidm_dataset_single", (String)"id,datasrctype,datasrcid", (QFilter[])new QFilter("dataset", "=", (Object)datasetId).toArray());
        } else {
            DynamicObject[] multiDatasets = BusinessDataServiceHelper.load((String)"fidm_dataset_multivalue", (String)"single.id", (QFilter[])new QFilter("dataset", "=", (Object)datasetId).and(new QFilter("formulatype", "=", (Object)"1")).toArray());
            Set ids = Arrays.stream(multiDatasets).map(c -> c.getLong("single.id")).collect(Collectors.toSet());
            datasets = BusinessDataServiceHelper.load((String)"fidm_dataset_single", (String)"id,datasrctype,datasrcid", (QFilter[])new QFilter("id", "in", ids).toArray());
        }
        if (Objects.isNull(datasets)) {
            return;
        }
        for (int i = 0; i < datasets.length; ++i) {
            DynamicObject dataset = datasets[i];
            Long modelId = dataset.getLong("datasrcid");
            String dataSrcType = dataset.getString("datasrctype");
            if (DataSrcTypeEnum.ISC_METADATA.getType().equals(dataSrcType) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(dataSrcType) || DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(dataSrcType)) {
                return;
            }
            IModel farModel = ModelStrategy.getStrategy(DisModelTypeEnum.getModelType(dataset.getString("datasrctype"), modelId));
            if (farModel.isUser(modelId)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u6570\u636e\u6765\u6e90\u4f53\u7cfb\u6743\u9650,\u65e0\u6cd5\u64cd\u4f5c\u8be5\u6570\u636e\u96c6\u3002", (String)"IFarModel_02", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }
}

