/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.strategy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.util.QFBuilder;

public class RPTModel
implements IModel {
    @Override
    public String getDimDefaultValue(String shortNumber) {
        return DEFAULT_VALUE.getOrDefault(shortNumber, shortNumber + "None");
    }

    @Override
    public boolean isAdmin(Long modelId) {
        Set<Long> limitedModelListByUser = MemberPermHelper.getLimitedModelListByUser(ApplicationTypeEnum.RPT, false);
        return limitedModelListByUser.contains(modelId);
    }

    @Override
    public boolean isUser(Long modelId) {
        List<DynamicObject> limitedModelListByUser = this.getUseModels();
        Set set = limitedModelListByUser.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        return set.contains(modelId);
    }

    @Override
    public Map<String, String> getDimensionNumber2nameMap(Long modelId, String dataSetNumber) {
        HashMap<String, String> returnMap = new HashMap<String, String>(16);
        BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,shortnumber,name,id", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray()).values().forEach(e -> returnMap.put(e.getString("shortnumber"), e.getString("number") + ";" + e.getString("name") + ";" + e.getString("id")));
        return returnMap;
    }

    @Override
    public List<DynamicObject> getAdminModels() {
        QFilter qf1 = MemberPermHelper.getModelPermFilter("id", "report_modelperm_manager", ApplicationTypeEnum.RPT);
        QFilter qf2 = new QFilter("reporttype", "!=", (Object)ApplicationTypeEnum.CM.index);
        return QueryServiceHelper.query((String)"bcm_model", (String)"id,name,number,shownumber", (QFilter[])new QFilter[]{qf1, qf2});
    }

    @Override
    public List<DynamicObject> getUseModels() {
        HasPermDimObjResult perResult = PermissionServiceHelper.getUserHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"bcm_model");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        if (perResult == null) {
            return result;
        }
        QFBuilder qfBuilder = new QFBuilder();
        if (!perResult.hasAllDimObjPerm()) {
            qfBuilder.and("id", "in", (Object)perResult.getHasPermDimObjs());
        }
        qfBuilder.and("reporttype", "!=", (Object)ApplicationTypeEnum.CM.index);
        result = QueryServiceHelper.query((String)"bcm_model", (String)"id,name,number,shownumber", (QFilter[])qfBuilder.toArray());
        return result;
    }

    @Override
    public DynamicObject getModel(Long modelId) {
        return this.getModel("bcm_model", new QFilter[]{new QFilter("id", "=", (Object)modelId)});
    }

    @Override
    public Long getDimId(Long modelId, String number) {
        return this.getDimId(modelId, "bcm_dimension", number);
    }
}

