/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.thread;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.impl.ThreadPoolImpl;
import kd.bos.util.ConfigurationUtil;
import kd.epm.far.business.common.thread.IRunner;

public class ThreadPoolService {
    private static final Log log = LogFactory.getLog(ThreadPoolService.class);
    private static final String pool_name_expressioncalculate = "fidm_expression_calculate";
    private static final String pool_name_modulecalculate = "fidm_module_calculate";
    private static final String pool_name_chapterpreview = "fidm_chapter_preview";
    private static final String pool_name_reportgeneral = "fidm_report_general";
    private static final int pool_ExpressionCalculate_MaxThread = Integer.getInteger("fidm_expression_calculate_pool_maxthread", 100);
    private static final int pool_ModuleCalculate_MaxThread = Integer.getInteger("fidm_module_calculate_pool_maxthread", 100);
    private static final int pool_ChapterPreview_MaxThread = Integer.getInteger("fidm_chapter_preview_pool_maxthread", 100);
    private static final int pool_ReportGeneral_MaxThread = Integer.getInteger("fidm_report_general_pool_maxthread", 100);
    private static final Map<String, ThreadPoolExecutor> ThreadPoolExecutorHolder = new ConcurrentHashMap<String, ThreadPoolExecutor>(16);
    private static final ThreadPool threadPoolExpressionCaclculate = FIDMThreadPool.access$000("fidm_expression_calculate", pool_ExpressionCalculate_MaxThread, pool_ExpressionCalculate_MaxThread);
    private static final ThreadPool threadPoolModuleCaclculate = FIDMThreadPool.access$000("fidm_module_calculate", pool_ModuleCalculate_MaxThread, pool_ModuleCalculate_MaxThread);
    private static final ThreadPool threadPoolChapterPreview = FIDMThreadPool.access$000("fidm_chapter_preview", pool_ChapterPreview_MaxThread, pool_ChapterPreview_MaxThread);
    private static final ThreadPool threadPoolReportGeneral = FIDMThreadPool.access$000("fidm_report_general", pool_ReportGeneral_MaxThread, pool_ReportGeneral_MaxThread);

    private static void doExecute(ThreadPool threadPool, Runnable runner) {
        threadPool.execute(runner, ThreadPoolService.createRequestContext());
    }

    public static RequestContext createRequestContext() {
        RequestContext copy = RequestContextCreator.createForThreadPool();
        copy.setClient(RequestContext.get().getClient());
        copy.setLoginIP(RequestContext.get().getLoginIP());
        return copy;
    }

    public static void runInExpressionCalculateThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPoolExpressionCaclculate, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--fidm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInModuleCalculateThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPoolModuleCaclculate, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--fidm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInChapterPreviewThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPoolChapterPreview, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--fidm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    public static void runInReportGeneralThread(IRunner runner) {
        ThreadPoolService.doExecute(threadPoolReportGeneral, () -> {
            long start = System.currentTimeMillis();
            runner.doRun();
            log.info(String.format("%s--fidm--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        });
    }

    static {
        ThreadPoolExecutorHolder.forEach((key, value) -> ConfigurationUtil.observeChange((String)(key + "_pool_maxthread"), (key1, newValue) -> {
            Integer newMaxThread = Integer.getInteger(key + "_pool_maxthread");
            if (newMaxThread != null && newMaxThread > 0) {
                value.setCorePoolSize(newMaxThread);
                log.info(String.format("--fidm-- threadPool [%s] set core pool size [%d] successfull.", key, newMaxThread));
            }
        }));
    }

    static class FIDMThreadPool {
        FIDMThreadPool() {
        }

        private static ThreadPool createCachedExecutorService(String poolName, int coreThread, int maxThread) {
            return new ThreadPoolImpl(ThreadLifeCycleManager.wrapExecutorService((ExecutorService)FIDMThreadPool.genThreadPoolExecutor(poolName, coreThread, maxThread)));
        }

        private static ThreadPoolExecutor genThreadPoolExecutor(final String poolName, int coreThread, int maxThread) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThread, maxThread, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private final AtomicInteger atomicInteger = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, poolName + "-" + this.atomicInteger.incrementAndGet());
                }
            });
            executor.allowCoreThreadTimeOut(true);
            ThreadPoolExecutorHolder.put(poolName, executor);
            return executor;
        }

        static /* synthetic */ ThreadPool access$000(String x0, int x1, int x2) {
            return FIDMThreadPool.createCachedExecutorService(x0, x1, x2);
        }
    }
}

