/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.upgrade;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.far.business.common.perm.BcmPermSingleModel;
import kd.epm.far.business.common.perm.FarFunPermissionHelper;
import kd.epm.far.business.common.upgrade.CommonPermItemsUpgradeService;
import kd.epm.far.business.common.upgrade.UpgradeServiceHelper;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import org.apache.commons.lang3.StringUtils;

public abstract class CommonAdminPermUpgradeService
extends CommonPermItemsUpgradeService {
    private static final String FPERMITEMID = "fpermitemid";
    private static final String FENTITYTYPEID = "fentitytypeid";
    private static final String S_SPLIT = String.valueOf('#');
    private static final int SIZE = 1000;
    protected ApplicationTypeEnum app;
    protected String appId;

    protected Map<String, Object> upgradeStart() {
        Map<String, List<String>> map = BcmPermSingleModel.getInstance().getPermbyentity();
        HashMap file = Maps.newHashMapWithExpectedSize((int)1000);
        map.entrySet().forEach(t -> ((List)t.getValue()).forEach(v -> file.put(String.join((CharSequence)S_SPLIT, (CharSequence)t.getKey(), v), Pair.onePair(t.getKey(), (Object)v))));
        Boolean isNewPlatform = UpgradeServiceHelper.isRolePermTableNew();
        String selectSql = isNewPlatform != false ? "select DISTINCT fpermitemid, fentitytypeid from t_perm_rolepermdetial where froleid = ? and fbizappid = ?" : "select DISTINCT fpermitemid, fentitytypeid from t_perm_roleperm prp left join t_perm_rolepermdetial prpd on prp.fid = prpd.fid where prp.froleid = ? and fbizappid = ?";
        Map dbRes = (Map)DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])new Object[]{FarFunPermissionHelper.APP2ADMINROLEID.get(this.app), this.appId}, rs -> {
            HashMap list = Maps.newHashMapWithExpectedSize((int)1000);
            while (rs.next()) {
                String fpermitemid = rs.getString(FPERMITEMID);
                String fentitytypeid = rs.getString(FENTITYTYPEID);
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fpermitemid, fentitytypeid})) continue;
                list.put(String.join((CharSequence)S_SPLIT, fentitytypeid, fpermitemid), Pair.onePair((Object)fentitytypeid, (Object)fpermitemid));
            }
            return list;
        });
        HashMap assignInfo = Maps.newHashMapWithExpectedSize((int)map.size());
        dbRes.entrySet().forEach(t -> {
            if (Objects.isNull(file.get(t.getKey()))) {
                assignInfo.computeIfAbsent(((Pair)t.getValue()).p1, k -> Lists.newArrayListWithExpectedSize((int)16)).add(((Pair)t.getValue()).p2);
            } else {
                file.remove(t.getKey());
            }
        });
        this.addOrRemoveRolePerm(Boolean.FALSE, assignInfo, this.app);
        assignInfo.clear();
        file.entrySet().forEach(t -> assignInfo.computeIfAbsent(((Pair)t.getValue()).p1, k -> Lists.newArrayListWithExpectedSize((int)16)).add(((Pair)t.getValue()).p2));
        this.addOrRemoveRolePerm(Boolean.TRUE, assignInfo, this.app);
        return this.success();
    }

    private void addOrRemoveRolePerm(boolean addOrRemove, Map<String, List<String>> map, ApplicationTypeEnum appPm) {
        ImmutableMap appEntityPermItemMap = ImmutableMap.of((Object)this.appId, map);
        PermissionServiceHelper.roleAssignFuncPerm((String)FarFunPermissionHelper.APP2ADMINROLEID.get(appPm), (Map)appEntityPermItemMap, (boolean)addOrRemove, (StringBuilder)new StringBuilder());
        if (Objects.equals(appPm, ApplicationTypeEnum.CM)) {
            this.addOrRemoveRolePerm(addOrRemove, map, ApplicationTypeEnum.RPT);
        }
    }
}

