/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.upgrade;

import java.text.ParseException;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.upgrade.DatasetSrcUpgradeService;
import kd.epm.far.common.common.log.WatchLogger;

public abstract class CommonDatasetSrcUpgradeService
extends DatasetSrcUpgradeService {
    public static final DBRoute DBROUTE = new DBRoute("bcm");

    public static void upgradeStart(WatchLogger log) {
        log.info("CommonDatasetSrcUpgradeService - start");
        try (TXHandle tx = TX.required();){
            try {
                log.info("CommonDatasetSrcUpgradeService - TXHandle");
                CommonDatasetSrcUpgradeService.upgradeDatasetSrc();
                log.info("CommonDatasetSrcUpgradeService - end");
            }
            catch (Exception e) {
                tx.markRollback();
                log.error(String.format("CommonDatasetSrcUpgradeService - upgrade: %s", e.getMessage()));
            }
        }
    }

    public static void upgradeDatasetSrc() throws ParseException {
        DataSrcTypeEnum[] dataSrcTypeEnums;
        for (DataSrcTypeEnum dataSrc : dataSrcTypeEnums = DataSrcTypeEnum.values()) {
            String sql = "update t_fidm_ds t1 set fdatasrctype = ? where t1.fid in (SELECT fdatasetid from t_fidm_ds_single t2 where t2.fdatasrctype = ?)";
            try {
                DB.execute((DBRoute)DBROUTE, (String)sql, (Object[])new Object[]{dataSrc.getType(), dataSrc.getType()});
            }
            catch (Exception e) {
                throw new KDBizException(String.format("sql is\uff1a%1$s\uff0cfailure result is\uff1a%2$s", sql, e.getMessage()));
            }
        }
    }
}

