/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.thread.ThreadPoolService;
import kd.epm.far.business.common.upgrade.ThematicAnalysisUpgradeService;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.DateTimeUtils;

public abstract class CommonThematicAnalysisUpgradeService
extends ThematicAnalysisUpgradeService {
    public static final String FID = "fid";
    public static final String FNUMBER = "fnumber";
    public static final String FNAME = "fname";
    public static final String FCREATORID = "fcreatorid";
    public static final String FSTATUS = "fstatus";
    public static final String FMODIFIERID = "fmodifierid";
    public static final String FENABLE = "fenable";
    public static final String FCREATETIME = "fcreatetime";
    public static final String FMODIFYTIME = "fmodifytime";
    public static final String FMASTERID = "fmasterid";
    public static final String FPERMCLASSID = "fpermclassid";
    public static final String FDESCRIPTION = "fdescription";
    public static final String FMODELID = "fmodelid";
    public static final String FTHEMEANALYSISID = "fthemeanalysisid";
    public static final String FVIEWDATA = "fviewdata";
    public static final String FDEFAULTPARAM = "fdefaultparam";
    public static final String FSEQUENCE = "fsequence";
    public static final String FPKID = "fpkid";
    public static final String FLOCALEID = "flocaleid";
    public static final String T_FAR_THEMEANALYSIS = "t_far_themeanalysis";
    public static final String T_FAR_THEMEANALYSISBOARD = "t_far_themeanalysisboard";
    public static final DBRoute DBROUTE = new DBRoute("bcm");

    public static void upgradeStart(WatchLogger log) {
        log.info("CommonThematicAnalysisUpgradeService - start");
        try (TXHandle tx = TX.required();){
            try {
                log.info("CommonThematicAnalysisUpgradeService - TXHandle");
                CommonThematicAnalysisUpgradeService.upgradeThemeanalysis(T_FAR_THEMEANALYSIS);
                CommonThematicAnalysisUpgradeService.upgradeThemeanalysis(T_FAR_THEMEANALYSISBOARD);
                CommonThematicAnalysisUpgradeService.upgradeLanguage(T_FAR_THEMEANALYSIS);
                CommonThematicAnalysisUpgradeService.upgradeLanguage(T_FAR_THEMEANALYSISBOARD);
                log.info("CommonThematicAnalysisUpgradeService - end");
            }
            catch (Exception e) {
                tx.markRollback();
                log.error(String.format("CommonThematicAnalysisUpgradeService - upgrade: %s", e.getMessage()));
            }
        }
    }

    public static void upgradeThemeanalysis(final String tableName) throws ParseException {
        StringBuilder selectSql = new StringBuilder();
        if (T_FAR_THEMEANALYSIS.equals(tableName)) {
            selectSql.append("select fid,fnumber,  fname,  fcreatorid,  fstatus,  fmodifierid,  fenable,  fcreatetime,  fmodifytime,  fmasterid,  fpermclassid,  fdescription,  fmodelid from t_far_myanalysis where fid not in(select fid  from t_far_themeanalysis )  ");
        } else {
            selectSql.append("select  fid,  fnumber,  fname,  fcreatorid,  fstatus,  fmodifierid,  fenable,  fcreatetime,  fmodifytime,  fmasterid,  fdescription,  fmodelid,  fid as  fthemeanalysisid,  fviewdata,  fdefaultparam,  1 as fsequence from t_far_myanalysis   where fid not in(select fid  from t_far_themeanalysisboard )  ");
        }
        List userItemList = (List)DB.query((DBRoute)DBROUTE, (String)selectSql.toString(), (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(100);
                while (rs.next()) {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)13);
                    if (!CommonThematicAnalysisUpgradeService.T_FAR_THEMEANALYSIS.equals(tableName)) {
                        Maps.newHashMapWithExpectedSize((int)17);
                    }
                    Long fId = rs.getLong(CommonThematicAnalysisUpgradeService.FID);
                    map.put(CommonThematicAnalysisUpgradeService.FID, fId);
                    String fnumber = rs.getString(CommonThematicAnalysisUpgradeService.FNUMBER) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FNUMBER);
                    map.put(CommonThematicAnalysisUpgradeService.FNUMBER, fnumber);
                    String fname = rs.getString(CommonThematicAnalysisUpgradeService.FNAME) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FNAME);
                    map.put(CommonThematicAnalysisUpgradeService.FNAME, fname);
                    Long fcreatorid = rs.getLong(CommonThematicAnalysisUpgradeService.FCREATORID);
                    map.put(CommonThematicAnalysisUpgradeService.FCREATORID, fcreatorid);
                    String fstatus = rs.getString(CommonThematicAnalysisUpgradeService.FSTATUS) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FSTATUS);
                    map.put(CommonThematicAnalysisUpgradeService.FSTATUS, fstatus);
                    Long fmodifierid = rs.getLong(CommonThematicAnalysisUpgradeService.FMODIFIERID);
                    map.put(CommonThematicAnalysisUpgradeService.FMODIFIERID, fmodifierid);
                    String fenable = rs.getString(CommonThematicAnalysisUpgradeService.FENABLE) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FENABLE);
                    map.put(CommonThematicAnalysisUpgradeService.FENABLE, fenable);
                    String fcreatetime = rs.getString(CommonThematicAnalysisUpgradeService.FCREATETIME) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FCREATETIME);
                    map.put(CommonThematicAnalysisUpgradeService.FCREATETIME, fcreatetime);
                    String fmodifytime = rs.getString(CommonThematicAnalysisUpgradeService.FMODIFYTIME) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FMODIFYTIME);
                    map.put(CommonThematicAnalysisUpgradeService.FMODIFYTIME, fmodifytime);
                    Long fmasterid = rs.getLong(CommonThematicAnalysisUpgradeService.FMASTERID);
                    map.put(CommonThematicAnalysisUpgradeService.FMASTERID, fmasterid);
                    String fdescription = rs.getString(CommonThematicAnalysisUpgradeService.FDESCRIPTION) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FDESCRIPTION);
                    map.put(CommonThematicAnalysisUpgradeService.FDESCRIPTION, fdescription);
                    Long fmodelid = rs.getLong(CommonThematicAnalysisUpgradeService.FMODELID);
                    map.put(CommonThematicAnalysisUpgradeService.FMODELID, fmodelid);
                    if (!CommonThematicAnalysisUpgradeService.T_FAR_THEMEANALYSIS.equals(tableName)) {
                        Long fthemeanalysisid = rs.getLong(CommonThematicAnalysisUpgradeService.FTHEMEANALYSISID);
                        map.put(CommonThematicAnalysisUpgradeService.FTHEMEANALYSISID, fthemeanalysisid);
                        String fviewdata = rs.getString(CommonThematicAnalysisUpgradeService.FVIEWDATA) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FVIEWDATA);
                        map.put(CommonThematicAnalysisUpgradeService.FVIEWDATA, fviewdata);
                        String fdefaultparam = rs.getString(CommonThematicAnalysisUpgradeService.FDEFAULTPARAM) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FDEFAULTPARAM);
                        map.put(CommonThematicAnalysisUpgradeService.FDEFAULTPARAM, fdefaultparam);
                        Long fsequence = rs.getLong(CommonThematicAnalysisUpgradeService.FSEQUENCE);
                        map.put(CommonThematicAnalysisUpgradeService.FSEQUENCE, fsequence);
                    } else {
                        Long fpermclassid = rs.getLong(CommonThematicAnalysisUpgradeService.FPERMCLASSID);
                        map.put(CommonThematicAnalysisUpgradeService.FPERMCLASSID, fpermclassid);
                    }
                    list.add(map);
                    if (list.size() != 2000) continue;
                    ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>();
                    newList.addAll(list);
                    list.clear();
                    ThreadPoolService.runInReportGeneralThread(() -> CommonThematicAnalysisUpgradeService.saveThemeanalysis(newList, tableName));
                }
                return list;
            }
        });
        if (userItemList.size() > 0) {
            CommonThematicAnalysisUpgradeService.saveThemeanalysis(userItemList, tableName);
        }
    }

    private static void saveThemeanalysis(List<Map<String, Object>> userItemList, String tableName) {
        ArrayList paramsThemeanalysisList = Lists.newArrayListWithExpectedSize((int)userItemList.size());
        for (int i = 0; i < userItemList.size(); ++i) {
            String fmodifytime;
            Map<String, Object> map = userItemList.get(i);
            Object[] params = new Object[13];
            if (!T_FAR_THEMEANALYSIS.equals(tableName)) {
                params = new Object[16];
            }
            params[0] = (Long)map.get(FID);
            params[1] = (String)map.get(FNUMBER);
            params[2] = (String)map.get(FNAME);
            params[3] = (Long)map.get(FCREATORID);
            params[4] = (String)map.get(FSTATUS);
            params[5] = (Long)map.get(FMODIFIERID);
            params[6] = (String)map.get(FENABLE);
            String fcreatetime = (String)map.get(FCREATETIME);
            if (!StringUtils.isBlank((String)fcreatetime)) {
                Date date = new Date();
                try {
                    date = DateTimeUtils.parseDate((String)fcreatetime, (String)"yyyy-MM-dd HH:mm:ss.SSS");
                }
                catch (ParseException e) {
                    throw new KDBizException("Date parse error:" + e.getMessage());
                }
                params[7] = date;
            }
            if (!StringUtils.isBlank((String)(fmodifytime = (String)map.get(FMODIFYTIME)))) {
                Date date = new Date();
                try {
                    date = DateTimeUtils.parseDate((String)fmodifytime, (String)"yyyy-MM-dd HH:mm:ss.SSS");
                }
                catch (ParseException e) {
                    throw new KDBizException("Date parse error:" + e.getMessage());
                }
                params[8] = date;
            }
            params[9] = (Long)map.get(FMASTERID);
            if (!T_FAR_THEMEANALYSIS.equals(tableName)) {
                params[10] = (String)map.get(FDESCRIPTION);
                params[11] = (Long)map.get(FMODELID);
                params[12] = (Long)map.get(FTHEMEANALYSISID);
                params[13] = (String)map.get(FVIEWDATA);
                params[14] = (String)map.get(FDEFAULTPARAM);
                params[15] = (Long)map.get(FSEQUENCE);
            } else {
                params[10] = (Long)map.get(FPERMCLASSID);
                params[11] = (String)map.get(FDESCRIPTION);
                params[12] = (Long)map.get(FMODELID);
            }
            paramsThemeanalysisList.add(params);
        }
        if (!CollectionUtils.isEmpty((Collection)paramsThemeanalysisList)) {
            String insertUserpermdetail = "INSERT INTO t_far_themeanalysis (fid,fnumber,  fname,  fcreatorid,  fstatus,  fmodifierid,  fenable,  fcreatetime,  fmodifytime,  fmasterid,  fpermclassid,  fdescription,  fmodelid  ) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            if (!T_FAR_THEMEANALYSIS.equals(tableName)) {
                insertUserpermdetail = "INSERT INTO t_far_themeanalysisboard (fid,  fnumber,  fname,  fcreatorid,  fstatus,  fmodifierid,  fenable,  fcreatetime,  fmodifytime,  fmasterid,  fdescription,  fmodelid,  fthemeanalysisid,  fviewdata,  fdefaultparam,  fsequence  ) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }
            DB.executeBatch((DBRoute)DBROUTE, (String)insertUserpermdetail, (List)paramsThemeanalysisList);
        }
    }

    public static void upgradeLanguage(final String tableName) {
        StringBuilder selectSql = new StringBuilder();
        if (T_FAR_THEMEANALYSIS.equals(tableName)) {
            selectSql.append("select fpkid,fdescription,fname,flocaleid,fid from  t_far_myanalysis_l where fpkid  not in(select fpkid  from t_far_themeanalysis_l ) ");
        } else {
            selectSql.append("select fpkid,fdescription,fname,flocaleid,fid from  t_far_myanalysis_l where fpkid  not in(select fpkid  from t_far_themeanalysisboard_l ) ");
        }
        List userItemList = (List)DB.query((DBRoute)DBROUTE, (String)selectSql.toString(), (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(100);
                while (rs.next()) {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)5);
                    Long fId = rs.getLong(CommonThematicAnalysisUpgradeService.FID);
                    map.put(CommonThematicAnalysisUpgradeService.FID, fId);
                    String fpkid = rs.getString(CommonThematicAnalysisUpgradeService.FPKID) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FPKID);
                    map.put(CommonThematicAnalysisUpgradeService.FPKID, fpkid);
                    String fdescription = rs.getString(CommonThematicAnalysisUpgradeService.FDESCRIPTION) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FDESCRIPTION);
                    map.put(CommonThematicAnalysisUpgradeService.FDESCRIPTION, fdescription);
                    String fname = rs.getString(CommonThematicAnalysisUpgradeService.FNAME) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FNAME);
                    map.put(CommonThematicAnalysisUpgradeService.FNAME, fname);
                    String flocaleid = rs.getString(CommonThematicAnalysisUpgradeService.FLOCALEID) == null ? "" : rs.getString(CommonThematicAnalysisUpgradeService.FLOCALEID);
                    map.put(CommonThematicAnalysisUpgradeService.FLOCALEID, flocaleid);
                    list.add(map);
                    if (list.size() != 2000) continue;
                    ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>();
                    newList.addAll(list);
                    list.clear();
                    ThreadPoolService.runInReportGeneralThread(() -> CommonThematicAnalysisUpgradeService.saveLanguage(newList, tableName));
                }
                return list;
            }
        });
        if (userItemList.size() > 0) {
            CommonThematicAnalysisUpgradeService.saveLanguage(userItemList, tableName);
        }
    }

    private static void saveLanguage(List<Map<String, Object>> userItemList, String tableName) {
        ArrayList paramsThemeanalysisList = Lists.newArrayListWithExpectedSize((int)userItemList.size());
        for (int i = 0; i < userItemList.size(); ++i) {
            Map<String, Object> map = userItemList.get(i);
            Object[] params = new Object[]{(String)map.get(FPKID), (String)map.get(FDESCRIPTION), (String)map.get(FNAME), (String)map.get(FLOCALEID), (Long)map.get(FID)};
            paramsThemeanalysisList.add(params);
        }
        if (!CollectionUtils.isEmpty((Collection)paramsThemeanalysisList)) {
            String insertUserpermdetail = "INSERT INTO t_far_themeanalysis_l (fpkid,fdescription,fname,flocaleid,fid  ) values (?,?,?,?,?)";
            if (!T_FAR_THEMEANALYSIS.equals(tableName)) {
                insertUserpermdetail = "INSERT INTO t_far_themeanalysisboard_l (fpkid,fdescription,fname,flocaleid,fid  ) values (?,?,?,?,?)";
            }
            DB.executeBatch((DBRoute)DBROUTE, (String)insertUserpermdetail, (List)paramsThemeanalysisList);
        }
    }
}

