/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.upgrade;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.far.business.common.upgrade.UpgradeServiceHelper;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.ThrowableHelper;

public abstract class FarUpgradeService
implements IUpgradeService {
    public static final String UR_SUCCESS = "success";
    public static final String UR_LOG = "log";
    public static final String UR_EL = "el";
    public static final String UR_ERRORINFO = "errorInfo";
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, this.getClass());

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try {
            return new UpgradeResult(this.upgradeBefore());
        }
        catch (Throwable t) {
            return new UpgradeResult(this.fail(t));
        }
    }

    protected String getUpgradeType() {
        return "default_not_record";
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try {
            boolean isRecord;
            Pair<Long, String> recorded = null;
            String clzName = this.getClass().getSimpleName();
            boolean bl = isRecord = UpgradeServiceHelper.isExistTableAndField() && !Objects.equals(this.getUpgradeType(), "default_not_record");
            if (isRecord) {
                recorded = UpgradeServiceHelper.getNameByTypeClz(this.getUpgradeType(), clzName);
            }
            if (isRecord && Objects.equals(sqlFileName, recorded.p2)) {
                return new UpgradeResult(this.success());
            }
            UpgradeResult upgradeResult = new UpgradeResult(this.upgrade());
            if (isRecord && upgradeResult.isSuccess()) {
                UpgradeServiceHelper.recordInsertOrUpdate((Long)recorded.p1, this.getUpgradeType(), sqlFileName, clzName);
            }
            return upgradeResult;
        }
        catch (Throwable t) {
            return new UpgradeResult(this.fail(t));
        }
    }

    public Map<String, Object> upgradeBefore() {
        return this.success();
    }

    public Map<String, Object> upgrade() {
        return this.success();
    }

    protected Map<String, Object> success() {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(UR_SUCCESS, true);
        String className = this.getClass().getName();
        result.put(UR_LOG, className + UR_SUCCESS);
        result.put(UR_EL, "");
        result.put(UR_ERRORINFO, "");
        return result;
    }

    protected Map<String, Object> fail(Throwable t) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        String logInfo = String.format("Upgrade error!\n%s", ThrowableHelper.toString((Throwable)t));
        result.put(UR_SUCCESS, false);
        result.put(UR_LOG, logInfo);
        result.put(UR_EL, ThrowableHelper.toString((Throwable)t));
        result.put(UR_ERRORINFO, t.getMessage());
        this.log.error(logInfo);
        return result;
    }
}

