/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.upgrade;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.common.common.BCMConstant;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class UpgradeServiceHelper {
    private static final String FID = "fid";
    private static final String FSEQ = "fseq";
    private static final String T_BCM_UPGRADE_RECORD = "t_bcm_upgraderecord";
    private static final String F_UPGRADE_TYPE = "fupgradetype";
    private static final String F_UPGRADE_TIME = "fupgradetime";
    private static final String F_UPGRADE_NAME = "fupgradename";
    private static final String F_UPGRADE_CLASS = "fupgradeclass";
    private static final String BCM_UPGRADE_SERVICE_IS_EXIST_TABLE_AND_FIELD = "BcmUpgradeService#isExistTableAndField";
    private static final long DFTID = 0L;

    public static Pair<Long, String> getNameByTypeClz(String type, String clzName) {
        String record = "select fid,fupgradename from t_bcm_upgraderecord where fupgradetype=? and fupgradeclass=?";
        Object[] params = new SqlParameter[]{new SqlParameter(": fupgradetype", 12, (Object)type), new SqlParameter(": fupgradeclass", 12, (Object)clzName)};
        Pair recorded = (Pair)DB.query((DBRoute)BCMConstant.DBROUTE, (String)record, (Object[])params, rs -> {
            if (rs.next()) {
                return Pair.onePair((Object)rs.getLong(FID), (Object)rs.getString(F_UPGRADE_NAME));
            }
            return Pair.onePair((Object)0L, (Object)"");
        });
        return recorded;
    }

    public static void recordInsertOrUpdate(Long fid, String type, String name, String clzName) {
        if (Objects.equals(0L, fid)) {
            String sqlInsert = "insert into t_bcm_upgraderecord(fid,fupgradetype,fupgradetime,fupgradename,fupgradeclass) values(?,?,?,?,?)";
            DB.update((DBRoute)BCMConstant.DBROUTE, (String)sqlInsert, (Object[])new Object[]{GlobalIdUtil.genGlobalLongId(), type, TimeServiceHelper.now(), name, clzName});
            return;
        }
        String sqlUpdate = "update t_bcm_upgraderecord set fupgradename=?,fupgradetime=? where fid=?";
        DB.update((DBRoute)BCMConstant.DBROUTE, (String)sqlUpdate, (Object[])new Object[]{name, TimeServiceHelper.now(), fid});
    }

    public static Boolean isRolePermTableNew() {
        String existSql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 't_perm_rolepermdetial' AND KSQL_COL_NAME IN ('froleid')";
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)existSql, ResultSet::next);
    }

    public static boolean isExistTableAndField() {
        return (Boolean)ThreadCache.get((Object)(CacheKey.PrefixString + BCM_UPGRADE_SERVICE_IS_EXIST_TABLE_AND_FIELD), () -> Lists.newArrayList((Iterable)DB.getColumnNames((DBRoute)DBRoute.of((String)"bcm"), (String)T_BCM_UPGRADE_RECORD)).containsAll(Lists.newArrayList((Object[])new String[]{FID, F_UPGRADE_TYPE, F_UPGRADE_TIME, F_UPGRADE_NAME, F_UPGRADE_CLASS})));
    }
}

