/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.far.common.common.util.TypeConversionUtil;

public class ComboEditUtil {
    public static void buildComboEditValue(List<String> list, String key, IDataModel model) {
        String stringValue = TypeConversionUtil.getStringValue((String)key, (IDataModel)model);
        if (StringUtils.isBlank((CharSequence)stringValue)) {
            return;
        }
        String[] split = stringValue.split(",");
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            if (StringUtils.isBlank((CharSequence)s.trim()) || !list.contains(s)) continue;
            sb.append(s).append(",");
        }
        model.setValue(key, (Object)sb.toString());
    }

    public static void buildComboEdit(Map<String, String> combos, String comboEditKey, IFormView modelView) {
        Map<Object, Object> showCombos = Maps.newLinkedHashMapWithExpectedSize((int)1);
        if ("groupby".equals(comboEditKey)) {
            String metaNumTypeCache;
            if (Objects.nonNull(modelView.getParentView()) && kd.bos.util.StringUtils.isNotEmpty((String)(metaNumTypeCache = modelView.getPageCache().get("metanumtype")))) {
                Set metaNumTypeList;
                Set finalMetaNumTypeList = metaNumTypeList = (Set)SerializationUtils.fromJsonString((String)metaNumTypeCache, Set.class);
                if (Objects.nonNull(combos) && combos.size() > 0) {
                    Map<String, String> filterCombos = combos.entrySet().stream().filter(entry -> !finalMetaNumTypeList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    showCombos = filterCombos;
                }
            }
        } else {
            showCombos = combos;
        }
        if (showCombos.size() > 0) {
            ArrayList items = Lists.newArrayListWithExpectedSize((int)showCombos.size());
            ComboEdit comboEdit = (ComboEdit)modelView.getControl(comboEditKey);
            if (showCombos == null || showCombos.size() <= 0) {
                comboEdit.setComboItems((List)items);
                return;
            }
            showCombos.forEach((key, value) -> items.add(new ComboItem(new LocaleString(value), key)));
            comboEdit.setComboItems((List)items);
        }
    }
}

