/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.util.ResultInfo;

public class FarNumberRule {
    private static final List<String> wordNameLimit = Arrays.asList("<", ">", ":", "\"", "/", "\\", "|", "? ", "*");
    private static final Pattern DATASET_NUMBER_REGEX = Pattern.compile("^[a-zA-Z0-9_]+$");
    private static final Pattern DATASET_MUST_CONTAIN_REGEX = Pattern.compile("^[0-9]+$");

    public static boolean checkNumber(String number) {
        String regEx = "^(?!_)[A-Za-z0-9_.-]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        return matcher.matches() && !number.startsWith(".") && !number.startsWith("_") && !number.startsWith("-") && !number.contains("..");
    }

    public static boolean checkVarNumber(String number) {
        String regEx = "^(?!_)[A-Za-z0-9_.-]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        return matcher.matches() && !number.startsWith(".") && !number.startsWith("_") && !number.startsWith("-") && !number.contains("..");
    }

    public static boolean checkModuleNumber(String number) {
        String regEx = "^(?!_)[A-Za-z0-9_.-]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        return matcher.matches() && !number.startsWith(".") && !number.startsWith("_") && !number.startsWith("-") && !number.contains("..");
    }

    public static ResultInfo checkChapterNumber(String number) {
        if (StringUtils.isNotEmpty((String)number)) {
            String regEx = "^(?!_)[-a-zA-Z0-9_.]+$";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(number);
            String showMsg = String.format(ResManager.loadKDString((String)"%s: \u201c\u7f16\u7801\u201d \u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"FarNumberRule_0", (String)"epm-far-business", (Object[])new Object[0]), number);
            if (!matcher.matches()) {
                return ResultInfo.fail(showMsg);
            }
            if (number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
                return ResultInfo.fail(showMsg);
            }
        } else {
            String showMsg = ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FarNumberRule_1", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(showMsg);
        }
        return ResultInfo.success();
    }

    public static ResultInfo checkWordName(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            String showMsg = String.format(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d \u4e0d\u53ef\u5305\u542b%s\u7b49\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"FarNumberRule_2", (String)"epm-far-business", (Object[])new Object[]{"<>:\"/|?*"}), new Object[0]);
            for (String item : wordNameLimit) {
                if (!name.contains(item)) continue;
                return ResultInfo.fail(showMsg);
            }
        } else {
            String showMsg = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FarNumberRule_3", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(showMsg);
        }
        return ResultInfo.success();
    }

    public static ResultInfo checkGeneralNumber(String number) {
        String showMsg = "";
        if (StringUtils.isNotEmpty((String)number)) {
            String regEx = "^(?!_)[-a-zA-Z0-9.]+$";
            Matcher matcher = Pattern.compile(regEx).matcher(number);
            if (!matcher.matches() || number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
                showMsg = ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"DisclosureDataCopy_0", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(showMsg);
            }
        } else {
            showMsg = ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FarNumberRule_1", (String)"epm-far-business", (Object[])new Object[0]);
            return ResultInfo.fail(showMsg);
        }
        return ResultInfo.success();
    }

    public static void checkDatasetNumberFormat(String number) {
        if (number.startsWith(".") || number.startsWith("_") || number.contains("..")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\uff0c\u4e0d\u80fd\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"DatasetServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Matcher matcher = DATASET_MUST_CONTAIN_REGEX.matcher(number);
        if (matcher.matches()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u5305\u542b\u534a\u89d2\u5b57\u6bcd\u6216\u534a\u89d2\u4e0b\u5212\u7ebf\u3002", (String)"DatasetServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Matcher matcher2 = DATASET_NUMBER_REGEX.matcher(number);
        if (!matcher2.matches()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\uff0c\u4e0d\u80fd\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"DatasetServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }
}

