/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.variable;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.common.variable.dto.Variable;
import kd.epm.far.business.common.variable.dto.VariableEnum;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;

public class VariableService {
    public static final String KEY_DISC_MODEL_ID = "DISC_MODEL_ID";
    public static final String VAR_SCOP = "varscop";
    public static final String VAR_CHAPTERID = "chapterid";
    private static final String MODELID = "model";
    private static final String closedcallback_add_variable = "dm_disc_variable_close";
    private static final String callbackid_del_confirm = "callbackid_delVar_confirm";

    public static List<Map<String, String>> getVariableTreeList(Long modelId) {
        return VariableService.getDBTreeList(modelId, "1", null);
    }

    public static List<Map<String, String>> getChapterTreeList(Long modelId, Long chapterId) {
        return VariableService.getDBTreeList(modelId, "2", chapterId);
    }

    private static List<Map<String, String>> getDBTreeList(Long modelId, String scope, Long chapterId) {
        QFilter filter = new QFilter(MODELID, "=", (Object)(Objects.nonNull(modelId) ? modelId : 0L));
        filter.and("scope", "=", (Object)scope);
        if (chapterId != null) {
            filter.and(VAR_CHAPTERID, "=", (Object)chapterId);
        }
        DynamicObjectCollection gv_list = QueryServiceHelper.query((String)"fidm_disc_variable", (String)"id,name,number", (QFilter[])new QFilter[]{filter});
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(gv_list.size());
        for (DynamicObject chapter : gv_list) {
            String number = chapter.getString("number");
            String name = chapter.getString("name");
            HashMap<String, String> treeNode = new HashMap<String, String>();
            treeNode.put("id", chapter.get("id").toString());
            treeNode.put("number", number);
            treeNode.put("name", name);
            treeNode.put("parentid", "0");
            treeNode.put("text", (String)treeNode.get("name"));
            if ("1".equals(scope) || "2".equals(scope)) {
                treeNode.put("vartype", scope);
            }
            treeList.add(treeNode);
        }
        return treeList;
    }

    public static void openVariableEditView(IFormView view, IFormPlugin plugin, String id, String modelId, Long chapterId) {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "fidm_disc_variable");
        openParameter.put("pkId", id);
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setStatus(id == null ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        formShowParameter.setCustomParam(KEY_DISC_MODEL_ID, (Object)modelId);
        formShowParameter.setCustomParam(VAR_SCOP, (Object)"2");
        formShowParameter.setCustomParam(VAR_CHAPTERID, (Object)chapterId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (id == null) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u53d8\u91cf\u65b0\u589e", (String)"VariableListPlugin_11", (String)"epm-far-business", (Object[])new Object[0]));
        } else {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u53d8\u91cf\u7f16\u8f91", (String)"VariableListPlugin_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, closedcallback_add_variable));
        formShowParameter.setCustomParam("dmmodelid", (Object)modelId);
        view.showForm(formShowParameter);
    }

    public static void showDelVarConfirmView(IFormView view, IFormPlugin plugin, String focusId) {
        if (focusId == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5148\u9009\u4e2d\u8282\u70b9\u518d\u5220\u9664\u3002", (String)"VariableListPlugin_12", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        if ("0".equals(focusId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u65e0\u6cd5\u5220\u9664\u3002", (String)"VariableListPlugin_13", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        Long id = Long.parseLong(focusId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fidm_disc_variable");
        if (dynamicObject == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"VariableListPlugin_6", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        Pair<Boolean, String> isVariableUsed = VariableService.isVariableUsed(id, dynamicObject.getString("name"));
        if (((Boolean)isVariableUsed.p1).booleanValue()) {
            view.showTipNotification((String)isVariableUsed.p2);
            return;
        }
        view.showConfirm(String.format(ResManager.loadKDString((String)"\u60a8\u6b63\u5728\u5220\u9664\u7f16\u7801\u4e3a\u201c%1$s\u201d\uff0c\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u7ae0\u8282\u53d8\u91cf\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"VariableListPlugin_14", (String)"epm-far-business", (Object[])new Object[0]), dynamicObject.getString("number"), dynamicObject.getString("name")), MessageBoxOptions.YesNo, new ConfirmCallBackListener(callbackid_del_confirm, plugin));
    }

    public static DynamicObject[] queryChapterVariables(Long chapterId) {
        if (chapterId == null || chapterId == 0L) {
            return null;
        }
        QFilter filter = new QFilter(VAR_CHAPTERID, "=", (Object)chapterId);
        filter.and("scope", "=", (Object)"2");
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"fidm_disc_variable", (String)"id,number,name,valuetype,defaultvalue", (QFilter[])filter.toArray());
        return dyns;
    }

    public static DynamicObject[] queryChapterVariablesWithoutDimension(Long chapterId) {
        if (chapterId == null || chapterId == 0L) {
            return null;
        }
        QFilter filter = new QFilter(VAR_CHAPTERID, "=", (Object)chapterId);
        filter.and("scope", "=", (Object)"2");
        filter.and("valuetype", "!=", (Object)DmVariableTypeEnum.DIM.getIndex());
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"fidm_disc_variable", (String)"id,number,name,valuetype,defaultvalue,entryentity,entryentity.enum_number,entryentity.enum_name,scope,entryentity.isdefault,describe", (QFilter[])filter.toArray());
        return dyns;
    }

    public static void copyChapterVariables(Long toChapterId, Long[] variableIds) {
        if (toChapterId == null || toChapterId == 0L || variableIds == null || variableIds.length == 0) {
            return;
        }
        MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)"fidm_disc_variable");
        DynamicObject[] dyns = BusinessDataServiceHelper.load((Object[])variableIds, (DynamicObjectType)objectType);
        DynamicObject[] copyDyns = new DynamicObject[dyns.length];
        for (int i = 0; i < dyns.length; ++i) {
            copyDyns[i] = (DynamicObject)OrmUtils.clone((IDataEntityBase)dyns[i], (boolean)false, (boolean)true);
        }
        for (DynamicObject copyDyn : copyDyns) {
            copyDyn.set(VAR_CHAPTERID, (Object)toChapterId);
            copyDyn.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
            copyDyn.set("createdate", (Object)TimeServiceHelper.now());
            copyDyn.set("modifier", (Object)0L);
            copyDyn.set("modifydate", null);
        }
        SaveServiceHelper.save((DynamicObject[])copyDyns);
    }

    public static Pair<Boolean, String> isVariableUsed(Long id, String name) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fidm_dataset_variable", (String)"dataset.id,dataset.number,dataset.name", (QFilter[])new QFilter[]{new QFilter("variable.id", "=", (Object)id)});
        if (dynamicObject == null || dynamicObject.getLong("dataset.id") <= 0L) {
            return Pair.onePair((Object)false, (Object)"");
        }
        return Pair.onePair((Object)true, (Object)String.format(ResManager.loadKDString((String)"\u53d8\u91cf\u201c%1$s\u201d\u5df2\u88ab\u6570\u636e\u96c6\u201c%2$s\u201d(\u201c%3$s\u201d)\u4f7f\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"VariableEditPlugin_11", (String)"epm-far-business", (Object[])new Object[0]), name, dynamicObject.getString("dataset.name"), dynamicObject.getString("dataset.number")));
    }

    public static List<Variable> getVariables(long modelId, long chapterId, String name, List<DmVariableTypeEnum> types) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter(MODELID, "=", (Object)modelId));
        if (StringUtils.isNotEmpty((String)name)) {
            qFilters.add(new QFilter("name", "like", (Object)("%" + name + "%")));
        }
        if (types != null) {
            qFilters.add(new QFilter("valuetype", "in", types.stream().map(DmVariableTypeEnum::getIndex).collect(Collectors.toList())));
            if (types.isEmpty()) {
                return new ArrayList<Variable>(1);
            }
        }
        qFilters.add(new QFilter(VAR_CHAPTERID, "=", (Object)chapterId));
        qFilters.add(PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_disc_variable"));
        Map variableDatas = BusinessDataServiceHelper.loadFromCache((String)"fidm_disc_variable", (QFilter[])qFilters.toArray(new QFilter[0]));
        return VariableService.buildVariables(variableDatas.values());
    }

    public static List<Variable> getVariables(long modelId, List<Long> variableIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter(MODELID, "=", (Object)modelId));
        qFilters.add(new QFilter("id", "in", variableIds));
        qFilters.add(PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_disc_variable"));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_disc_variable", (String)"id,number,name,defaultvalue", (QFilter[])qFilters.toArray(new QFilter[0]));
        return VariableService.buildVariables((Collection<DynamicObject>)dys);
    }

    private static List<Variable> buildVariables(Collection<DynamicObject> variableDatas) {
        ArrayList<Variable> variables = new ArrayList<Variable>(variableDatas.size());
        Set properties = null;
        for (DynamicObject dy : variableDatas) {
            if (properties == null) {
                properties = dy.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
            }
            Variable variable = new Variable();
            if (properties.contains("id")) {
                variable.setId(dy.getLong("id"));
            }
            if (properties.contains("number")) {
                variable.setNumber(dy.getString("number"));
            }
            if (properties.contains("name")) {
                variable.setName(dy.getString("name"));
            }
            if (properties.contains(VAR_CHAPTERID)) {
                variable.setChapterId(dy.getLong(VAR_CHAPTERID));
            }
            if (properties.contains("valuetype")) {
                variable.setType(dy.getString("valuetype"));
            }
            if (properties.contains("scope")) {
                variable.setScope(dy.getString("scope"));
            }
            if (properties.contains("permclass")) {
                variable.setPermClassId(dy.getLong("permclass.id"));
            }
            if (properties.contains("describe")) {
                variable.setDescribe(dy.getString("describe"));
            }
            if (properties.contains("disc_dim")) {
                variable.setDimId(dy.getLong("disc_dim"));
            }
            if (properties.contains("defaultvalue")) {
                variable.setDefaultValue(dy.getString("defaultvalue"));
            }
            if (properties.contains("creator")) {
                variable.setCreator(dy.getString("creator.name"));
            }
            if (properties.contains("createdate")) {
                variable.setCreateTime(dy.getDate("createdate"));
            }
            if (properties.contains("modifier")) {
                variable.setModifier(dy.getString("modifier.name"));
            }
            if (properties.contains("modifydate")) {
                variable.setModifyTime(dy.getDate("modifydate"));
            }
            if (properties.contains("valuetype") && DmVariableTypeEnum.ENUM.getIndex().equals(dy.getString("valuetype"))) {
                DynamicObjectCollection enumDatas = dy.getDynamicObjectCollection("entryentity");
                ArrayList<VariableEnum> enums = new ArrayList<VariableEnum>(enumDatas.size());
                for (DynamicObject e : enumDatas) {
                    VariableEnum en = new VariableEnum();
                    en.setId(e.getLong("id"));
                    en.setNumber(e.getString("enum_number"));
                    en.setName(e.getString("enum_name"));
                    en.setDseq(e.getInt("seq"));
                    en.setIsDefault(e.getBoolean("isdefault"));
                    enums.add(en);
                }
                variable.setEnums(enums);
            }
            variables.add(variable);
        }
        return variables;
    }

    public static ResultInfo deleteVariable(long modelId, List<Long> variableIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter(MODELID, "=", (Object)modelId));
        qFilters.add(new QFilter("id", "in", variableIds));
        qFilters.add(PermissionHelper.getWritePermFilter(modelId, "fidm_disc_variable"));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_disc_variable", (String)"id,name", (QFilter[])qFilters.toArray(new QFilter[0]));
        List ids = dys.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        if (ids.isEmpty() || ids.size() < variableIds.size()) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u53d8\u91cf\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"VariableService_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        for (DynamicObject dy : dys) {
            Pair<Boolean, String> isVariableUsed = VariableService.isVariableUsed(dy.getLong("id"), dy.getString("name"));
            if (!Boolean.TRUE.equals(isVariableUsed.p1)) continue;
            return ResultInfo.fail((String)isVariableUsed.p2);
        }
        PlatUtil.executeWithTXNew(tx -> {
            QFilter filter = new QFilter(MODELID, "=", (Object)modelId).and(new QFilter("id", "in", (Object)ids));
            BusinessDataWriter.delete((String)"fidm_disc_variable", (QFilter[])new QFilter[]{filter});
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                PermissionHelper.savePermClassEntity(modelId, id, "fidm_disc_variable", 0L, OperationStatus.EDIT);
            }
        });
        return ResultInfo.success(ids);
    }

    public static ResultInfo saveVariable(long modelId, Variable variableModel) {
        DynamicObject variable;
        Date now = TimeServiceHelper.now();
        long userId = RequestContext.get().getCurrUserId();
        OperationStatus opStatus = OperationStatus.EDIT;
        ResultInfo result = VariableService.checkSave(modelId, variableModel);
        if (Boolean.FALSE.equals(result.isSuccess())) {
            return result;
        }
        if (variableModel.getId() == 0L) {
            opStatus = OperationStatus.ADDNEW;
            variableModel.setId(GlobalIdUtil.genGlobalLongId());
            variable = BusinessDataServiceHelper.newDynamicObject((String)"fidm_disc_variable");
            variable.set(MODELID, (Object)modelId);
            variable.set("id", (Object)variableModel.getId());
            variable.set("creator", (Object)userId);
            variable.set("createdate", (Object)now);
            variableModel.setCreator(RequestContext.get().getUserName());
            variableModel.setCreateTime(now);
        } else {
            variable = (DynamicObject)result.getData();
            variable.set("disc_dim", (Object)StringUtils.getEmpty());
            variable.set("dimmembertype", (Object)StringUtils.getEmpty());
            variableModel.setCreator(variable.getString("creator.name"));
            variableModel.setCreateTime(variable.getDate("createdate"));
        }
        variable.set("number", (Object)variableModel.getNumber());
        variable.set("name", (Object)variableModel.getName());
        variable.set("permclass", (Object)variableModel.getPermClassId());
        variable.set("describe", (Object)variableModel.getDescribe());
        variable.set("valuetype", (Object)variableModel.getType());
        variable.set("defaultvalue", (Object)variableModel.getDefaultValue());
        variable.set(VAR_CHAPTERID, (Object)variableModel.getChapterId());
        variable.set("scope", (Object)(variableModel.getChapterId() > 0L ? "2" : "1"));
        variable.set("modifier", (Object)userId);
        variable.set("modifydate", (Object)now);
        if (DmVariableTypeEnum.DIM.getIndex().equals(variableModel.getType())) {
            variable.set("disc_dim", (Object)variableModel.getDimId());
            List<DimensionInfo> allDims = new ModelStrategyEx(modelId).getDim().getDimList();
            DimensionInfo dim = DimensionUtils.getDimById(allDims, variableModel.getDimId());
            if (dim != null) {
                variable.set("dimmembertype", (Object)dim.getEntityName());
            }
        }
        DynamicObjectCollection variableEnums = variable.getDynamicObjectCollection("entryentity");
        variableEnums.clear();
        if (DmVariableTypeEnum.ENUM.getIndex().equals(variableModel.getType())) {
            variable.set("defaultvalue", (Object)StringUtils.getEmpty());
            for (VariableEnum e : variableModel.getEnums()) {
                DynamicObject variableEnum = variableEnums.addNew();
                variableEnum.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                variableEnum.set("enum_number", (Object)e.getNumber());
                variableEnum.set("enum_name", (Object)e.getName());
                variableEnum.set("isdefault", (Object)e.getIsDefault());
                variableEnum.set("seq", (Object)e.getDseq());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{variable});
        PermissionHelper.savePermClassEntity(modelId, variableModel.getId(), "fidm_disc_variable", variableModel.getPermClassId(), opStatus);
        variableModel.setModifier(RequestContext.get().getUserName());
        variableModel.setModifyTime(now);
        return ResultInfo.success(variableModel);
    }

    public static ResultInfo checkSave(Long dmModelId, Variable variableModel) {
        String msg;
        block29: {
            msg = "";
            if (StringUtils.isEmpty((String)variableModel.getNumber())) {
                msg = ResManager.loadKDString((String)"\u53d8\u91cf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableService_1", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(msg);
            }
            if (!FarNumberRule.checkVarNumber(variableModel.getNumber())) {
                msg = ResManager.loadKDString((String)"\u53d8\u91cf\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"VariableService_3", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(msg);
            }
            if (variableModel.getNumber().length() > 50) {
                msg = ResManager.loadKDString((String)"\u53d8\u91cf\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"VariableService_16", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(msg);
            }
            if (StringUtils.isEmpty((String)variableModel.getName())) {
                msg = ResManager.loadKDString((String)"\u53d8\u91cf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableService_4", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(msg);
            }
            if (variableModel.getName().length() > 50) {
                msg = ResManager.loadKDString((String)"\u53d8\u91cf\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"VariableService_19", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(msg);
            }
            long existId = VariableService.getVariable(dmModelId, variableModel.getChapterId(), variableModel.getNumber());
            if (existId > 0L && existId != variableModel.getId()) {
                msg = ResManager.loadKDString((String)"\u53d8\u91cf\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"VariableService_2", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(msg);
            }
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
            List<DimensionInfo> allDimensions = modelStrategyEx.getDim().getDimList();
            if (DmVariableTypeEnum.DIM.getIndex().equals(variableModel.getType())) {
                if (variableModel.getDimId() == 0L) {
                    msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableService_5", (String)"epm-far-business", (Object[])new Object[0]);
                    return ResultInfo.fail(msg);
                }
                if (StringUtils.isEmpty((String)variableModel.getDefaultValue())) {
                    msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableService_6", (String)"epm-far-business", (Object[])new Object[0]);
                    return ResultInfo.fail(msg);
                }
                DimensionInfo dim = DimensionUtils.getDimById(allDimensions, variableModel.getDimId());
                if (dim == null) {
                    msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"VariableService_7", (String)"epm-far-business", (Object[])new Object[0]);
                    return ResultInfo.fail(msg);
                }
                try {
                    DimMemberInfo member = modelStrategyEx.getDimMember().findMemberById(dim.getEntityName(), LongUtil.toLong((Object)variableModel.getDefaultValue()));
                    if (member == null) {
                        msg = ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"VariableService_8", (String)"epm-far-business", (Object[])new Object[0]);
                        return ResultInfo.fail(msg);
                    }
                    break block29;
                }
                catch (KDBizException ex) {
                    return ResultInfo.fail(ex.getMessage());
                }
            }
            if (DmVariableTypeEnum.ENUM.getIndex().equals(variableModel.getType())) {
                if (variableModel.getEnums() == null || variableModel.getEnums().isEmpty()) {
                    msg = ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableService_9", (String)"epm-far-business", (Object[])new Object[0]);
                    return ResultInfo.fail(msg);
                }
                HashSet<String> enumNumberCheck = new HashSet<String>(16);
                for (VariableEnum e : variableModel.getEnums()) {
                    if (StringUtils.isEmpty((String)e.getNumber())) {
                        msg = ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableService_10", (String)"epm-far-business", (Object[])new Object[0]);
                        return ResultInfo.fail(msg);
                    }
                    if (e.getNumber().length() > 50) {
                        msg = ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"VariableService_21", (String)"epm-far-business", (Object[])new Object[0]);
                        return ResultInfo.fail(msg);
                    }
                    if (StringUtils.isEmpty((String)e.getName())) {
                        msg = ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableService_11", (String)"epm-far-business", (Object[])new Object[0]);
                        return ResultInfo.fail(msg);
                    }
                    if (e.getName().length() > 50) {
                        msg = ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"VariableService_22", (String)"epm-far-business", (Object[])new Object[0]);
                        return ResultInfo.fail(msg);
                    }
                    if (!FarNumberRule.checkNumber(e.getNumber())) {
                        msg = ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"VariableService_12", (String)"epm-far-business", (Object[])new Object[0]);
                        return ResultInfo.fail(msg);
                    }
                    if (enumNumberCheck.add(e.getNumber())) continue;
                    msg = ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"VariableService_13", (String)"epm-far-business", (Object[])new Object[0]);
                    return ResultInfo.fail(msg);
                }
                if (variableModel.getEnums().stream().noneMatch(VariableEnum::getIsDefault)) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u679a\u4e3e\u9879\u3002", (String)"VariableService_14", (String)"epm-far-business", (Object[])new Object[0]);
                    return ResultInfo.fail(msg);
                }
            } else {
                if (StringUtils.isEmpty((String)variableModel.getDefaultValue())) {
                    msg = ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableService_15", (String)"epm-far-business", (Object[])new Object[0]);
                    return ResultInfo.fail(msg);
                }
                if (variableModel.getDefaultValue().length() > 500) {
                    msg = ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500\u3002", (String)"VariableService_20", (String)"epm-far-business", (Object[])new Object[0]);
                    return ResultInfo.fail(msg);
                }
                if (DmVariableTypeEnum.TEXT.getIndex().equals(variableModel.getType()) && DatasetSpecialVarHelper.isContainSpecialChar(variableModel.getDefaultValue())) {
                    msg = ResManager.loadKDString((String)"\u6587\u672c\u7c7b\u578b\u53d8\u91cf\u7684\u9ed8\u8ba4\u503c\u4e0d\u80fd\u542b\u6709$\u7b26\u3002", (String)"VariableService_18", (String)"epm-far-business", (Object[])new Object[0]);
                    return ResultInfo.fail(msg);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)variableModel.getDescribe()) && variableModel.getDescribe().length() > 200) {
            msg = ResManager.loadKDString((String)"\u5907\u6ce8\u63cf\u8ff0\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7200\u3002", (String)"VariableService_23", (String)"epm-far-business", (Object[])new Object[0]);
            return ResultInfo.fail(msg);
        }
        if (variableModel.getId() > 0L) {
            DynamicObject variable = BusinessDataServiceHelper.loadSingle((Object)variableModel.getId(), (String)"fidm_disc_variable");
            ArrayListMultimap<String, Long> permClassMap = PermClassEntityHelper.getFIDMPermissionMap("fidm_disc_variable", dmModelId, RequestContext.get().getCurrUserId());
            if (permClassMap.get((Object)DataTypeEnum.NO.getIndex()).contains(variableModel.getId()) || permClassMap.get((Object)DataTypeEnum.READ.getIndex()).contains(variableModel.getId())) {
                msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u53d8\u91cf\u7684\u5199\u6743\u9650\u3002", (String)"VariableService_17", (String)"epm-far-business", (Object[])new Object[0]);
                return ResultInfo.fail(msg);
            }
            return ResultInfo.success(variable);
        }
        return ResultInfo.success();
    }

    private static long getVariable(Long modelId, Long chapterId, String number) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter(MODELID, "=", (Object)modelId));
        qFilters.add(new QFilter("number", "=", (Object)number));
        if (chapterId == 0L) {
            qFilters.add(new QFilter("scope", "=", (Object)"1"));
        } else {
            qFilters.add(new QFilter("scope", "=", (Object)"2"));
            qFilters.add(new QFilter(VAR_CHAPTERID, "=", (Object)chapterId));
        }
        DynamicObject var = QueryServiceHelper.queryOne((String)"fidm_disc_variable", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (var == null) {
            return 0L;
        }
        return var.getLong("id");
    }
}

