/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.common.variable.util;

import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.variable.dto.Variable;
import kd.epm.far.business.common.variable.dto.VariableEnum;

public class VariableCheckUtil {
    private static void checkNotBlank(String s, String msg) {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new KDBizException(msg);
        }
    }

    private static void checkLengthLimit(int len, String s, String msg) {
        if (s.length() > len) {
            throw new KDBizException(msg);
        }
    }

    public static void valid(Variable var, DynamicObject fidmModel) {
        List<VariableEnum> enumList;
        VariableCheckUtil.checkLengthLimit(25, var.getNumber(), ResManager.loadKDString((String)"\u7f16\u7801\u5b57\u7b26\u8fc7\u957f\uff0c\u9700\u63a7\u5236\u572825\u4e2a\u5b57\u7b26\u4ee5\u5185\u3002", (String)"VariableCheckUtil_1", (String)"epm-far-business", (Object[])new Object[0]));
        VariableCheckUtil.checkLengthLimit(50, var.getName(), ResManager.loadKDString((String)"\u540d\u79f0\u5b57\u7b26\u8fc7\u957f\uff0c\u9700\u63a7\u5236\u572850\u4e2a\u5b57\u7b26\u4ee5\u5185\u3002", (String)"VariableCheckUtil_2", (String)"epm-far-business", (Object[])new Object[0]));
        VariableCheckUtil.checkLengthLimit(250, var.getDescribe(), ResManager.loadKDString((String)"\u63cf\u8ff0\u5b57\u7b26\u8fc7\u957f\uff0c\u9700\u63a7\u5236\u5728250\u4e2a\u5b57\u7b26\u4ee5\u5185\u3002", (String)"VariableCheckUtil_3", (String)"epm-far-business", (Object[])new Object[0]));
        VariableCheckUtil.checkLengthLimit(250, var.getDefaultValue(), ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c\u5b57\u7b26\u8fc7\u957f\uff0c\u9700\u63a7\u5236\u5728250\u4e2a\u5b57\u7b26\u4ee5\u5185\u3002", (String)"VariableCheckUtil_13", (String)"epm-far-business", (Object[])new Object[0]));
        if (!FarNumberRule.checkNumber(var.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u91cf\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"VariableService_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (DmVariableTypeEnum.DIM.getIndex().equals(var.getType())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7ef4\u5ea6\u7c7b\u578b\u5bfc\u5165\u3002", (String)"VariableCheckUtil_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DmVariableTypeEnum[] variableTypes = DmVariableTypeEnum.values();
        boolean wrongType = true;
        for (DmVariableTypeEnum typeEnum : variableTypes) {
            if (!typeEnum.getIndex().equals(var.getType())) continue;
            wrongType = false;
            break;
        }
        if (wrongType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u91cf\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u8bbe\u7f6e\u9519\u8bef\u3002", (String)"VariableCheckUtil_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!DmVariableTypeEnum.ENUM.getIndex().equals(var.getType()) && Objects.nonNull(enumList = var.getEnums()) && enumList.size() != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u679a\u4e3e\u7c7b\u578b\u53d8\u91cf\u4e0d\u80fd\u586b\u5199\u679a\u4e3e\u9879\u3002", (String)"VariableCheckUtil_17", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (DmVariableTypeEnum.TEXT.getIndex().equals(var.getType())) {
            if (DatasetSpecialVarHelper.isContainSpecialChar(var.getDefaultValue())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u672c\u7c7b\u578b\u53d8\u91cf\u7684\u9ed8\u8ba4\u503c\u4e0d\u80fd\u542b\u6709$\u7b26\u3002", (String)"VariableService_18", (String)"epm-far-business", (Object[])new Object[0]));
            }
        } else if (DmVariableTypeEnum.NUM.getIndex().equals(var.getType())) {
            String numValue = var.getDefaultValue();
            String regEx = "^(-)?[0-9.,]+$";
            Matcher matcher1 = Pattern.compile(regEx).matcher(numValue);
            if (!matcher1.matches()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u503c\u7c7b\u578b\u9ed8\u8ba4\u503c\u4ec5\u652f\u6301\u963f\u62c9\u4f2f\u6570\u5b57\uff0c\u5c0f\u6570\u70b9\uff0c\u8d1f\u6570\u7b26\u53f7\u548c\u5343\u5206\u4f4d\u9017\u53f7\u3002", (String)"VariableCheckUtil_6", (String)"epm-far-business", (Object[])new Object[0]));
            }
            String cleanNumValue = numValue.replaceAll(",", "");
            String regex = "^(-)?(\\d{1,13})(\\.\\d+)?$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher2 = pattern.matcher(cleanNumValue);
            if (!matcher2.matches()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u503c\u7c7b\u578b\u7684\u9ed8\u8ba4\u503c\u662f\u5426\u6b63\u5e38\uff0c\u5c0f\u6570\u70b9\u524d\u7684\u6570\u503c\u9650\u523613\u4f4d\uff0c\u5c0f\u6570\u70b9\u540e\u4fdd\u7559\u9650\u523610\u4f4d\uff0c\u8d85\u51fa\u5c06\u81ea\u52a8\u4fdd\u755910\u4f4d\u3002", (String)"VariableCheckUtil_7", (String)"epm-far-business", (Object[])new Object[0]));
            }
        } else if (DmVariableTypeEnum.DATE.getIndex().equals(var.getType())) {
            if (!var.getDefaultValue().matches("^\\d{4}-\\d{2}-\\d{2}$")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u65e5\u671f\u7c7b\u578b\u7684\u9ed8\u8ba4\u503c\u662f\u5426\u6709\u6548\uff0c\u65e5\u671f\u683c\u5f0f\u8981\u6c42\u4e3a\u201cYYYY-MM-DD\u201d\u3002", (String)"VariableCheckUtil_8", (String)"epm-far-business", (Object[])new Object[0]));
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setLenient(false);
            try {
                sdf.parse(var.getDefaultValue());
            }
            catch (ParseException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u65e5\u671f\u7c7b\u578b\u7684\u9ed8\u8ba4\u503c\u662f\u5426\u6709\u6548\uff0c\u65e5\u671f\u683c\u5f0f\u8981\u6c42\u4e3a\u201cYYYY-MM-DD\u201d\u3002", (String)"VariableCheckUtil_8", (String)"epm-far-business", (Object[])new Object[0]));
            }
        } else if (DmVariableTypeEnum.ENUM.getIndex().equals(var.getType())) {
            if (Objects.equals("epm_model", fidmModel.getDynamicObject("model").getDataEntityType().getName())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u524d\u9884\u7b97\u4f53\u7cfb\u4e0d\u652f\u6301\u679a\u4e3e\u7c7b\u578b\u53d8\u91cf\u3002", (String)"VariableCheckUtil_15", (String)"epm-far-business", (Object[])new Object[0]));
            }
            enumList = var.getEnums();
            if (Objects.isNull(enumList) || enumList.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u679a\u4e3e\u7c7b\u578b\u53d8\u91cf\u7684\u679a\u4e3e\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableCheckUtil_16", (String)"epm-far-business", (Object[])new Object[0]));
            }
            HashSet numSet = Sets.newHashSet();
            for (VariableEnum enumObject : enumList) {
                VariableCheckUtil.checkNotBlank(enumObject.getNumber(), ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableCheckUtil_9", (String)"epm-far-business", (Object[])new Object[0]));
                VariableCheckUtil.checkNotBlank(enumObject.getName(), ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VariableCheckUtil_10", (String)"epm-far-business", (Object[])new Object[0]));
                VariableCheckUtil.checkLengthLimit(50, enumObject.getNumber(), ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u7f16\u7801\u5b57\u7b26\u8fc7\u957f\uff0c\u9700\u63a7\u5236\u572850\u4e2a\u5b57\u7b26\u4ee5\u5185\u3002", (String)"VariableCheckUtil_11", (String)"epm-far-business", (Object[])new Object[0]));
                VariableCheckUtil.checkLengthLimit(50, enumObject.getName(), ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u540d\u79f0\u5b57\u7b26\u8fc7\u957f\uff0c\u9700\u63a7\u5236\u572850\u4e2a\u5b57\u7b26\u4ee5\u5185\u3002", (String)"VariableCheckUtil_12", (String)"epm-far-business", (Object[])new Object[0]));
                if (!FarNumberRule.checkNumber(enumObject.getNumber())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u91cf\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"VariableService_3", (String)"epm-far-business", (Object[])new Object[0]));
                }
                if (!Objects.nonNull(enumObject.getNumber()) || numSet.add(enumObject.getNumber())) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u679a\u4e3e\u9879\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"VariableService_13", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (!numSet.contains(var.getDefaultValue())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u679a\u4e3e\u7c7b\u578b\u53d8\u91cf\u9ed8\u8ba4\u503c\u4ec5\u652f\u6301\u8bbe\u7f6e\u4e3a\u679a\u4e3e\u9879\u4e2d\u7684\u7f16\u7801\u3002", (String)"VariableCheckUtil_14", (String)"epm-far-business", (Object[])new Object[0]));
            }
        }
    }
}

